/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.java;

import java.util.Objects;

public class FormatDescription {
    public final Conversion conversion;
    public final String index;
    public final String flags;
    public final String text;
    public final String width;
    public final String precision;
    public final int offset;
    public final int length;

    public FormatDescription(Conversion conversion, String index, String flags, String text, String width, String precision, int offset, int length) {
        this.conversion = conversion;
        this.index = index;
        this.flags = flags;
        this.text = text;
        this.width = width;
        this.precision = precision;
        this.offset = offset;
        this.length = length;
    }

    public int getExplicitIndex() {
        if (this.index == null) {
            throw new IllegalStateException("no explicit idx");
        }
        try {
            return Integer.parseInt(this.index);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public boolean isSimple() {
        switch (this.conversion) {
            case LITERAL: {
                return true;
            }
            case BOOLEAN: {
                return this.width.isEmpty() && this.text.equals("b");
            }
            case INTEGER: {
                return this.flags.isEmpty() && this.width.isEmpty() && this.text.equals("d");
            }
            case REAL: {
                return false;
            }
            case STRING: {
                return this.width.isEmpty() && this.text.equals("s");
            }
        }
        String msg = "Unexpected conversion: " + String.valueOf((Object)this.conversion);
        throw new RuntimeException(msg);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.conversion, this.index, this.flags, this.text, this.width, this.precision, this.offset, this.length});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FormatDescription)) {
            return false;
        }
        FormatDescription other = (FormatDescription)obj;
        return this.conversion == other.conversion && Objects.equals(this.index, other.index) && Objects.equals(this.flags, other.flags) && this.text.equals(other.text) && Objects.equals(this.width, other.width) && Objects.equals(this.precision, other.precision) && this.offset == other.offset && this.length == other.length;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeIndex) {
        switch (this.conversion) {
            case BOOLEAN: 
            case INTEGER: 
            case STRING: {
                String idx = !includeIndex || this.index.isEmpty() ? "" : this.index + "$";
                return "%" + idx + this.flags + this.width + this.text;
            }
            case LITERAL: 
            case ERROR: {
                return this.text;
            }
            case REAL: {
                String idx = !includeIndex || this.index.isEmpty() ? "" : this.index + "$";
                return "%" + idx + this.flags + this.width + (String)(this.precision.isEmpty() ? "" : "." + this.precision) + this.text;
            }
        }
        String msg = "Unknown conversion: " + String.valueOf((Object)this.conversion);
        throw new RuntimeException(msg);
    }

    public static enum Conversion {
        LITERAL,
        BOOLEAN,
        INTEGER,
        REAL,
        STRING,
        ERROR;

    }
}

