/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.common.ui.hover;

import com.google.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.xtext.EnumLiteralDeclaration;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.hover.DispatchingEObjectTextHover;
import org.eclipse.xtext.ui.editor.hover.IEObjectHoverProvider;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Tuples;

public class KeywordEObjectTextHover
extends DispatchingEObjectTextHover {
    @Inject
    protected IEObjectHoverProvider hoverProvider;

    public Object getHoverInfo(EObject first, ITextViewer textViewer, IRegion hoverRegion) {
        if (first instanceof Keyword) {
            this.lastCreatorProvider = this.hoverProvider.getHoverInfo(first, textViewer, hoverRegion);
            return this.lastCreatorProvider == null ? null : this.lastCreatorProvider.getInfo();
        }
        this.lastCreatorProvider = null;
        return super.getHoverInfo(first, textViewer, hoverRegion);
    }

    protected Pair<EObject, IRegion> getXtextElementAt(XtextResource resource, int offset) {
        Pair result = this.resolveKeywordAt(resource, offset);
        if (result == null) {
            result = super.getXtextElementAt(resource, offset);
        }
        return result;
    }

    public Pair<EObject, IRegion> resolveKeywordAt(XtextResource resource, int offset) {
        ILeafNode leaf;
        IParseResult parseResult = resource.getParseResult();
        if (parseResult != null && (leaf = this.findNearestLeafNode(parseResult, offset)) != null) {
            if (leaf.getGrammarElement() instanceof Keyword) {
                Keyword keyword = (Keyword)leaf.getGrammarElement();
                return Tuples.create((Object)keyword, (Object)new Region(leaf.getOffset(), leaf.getLength()));
            }
            if (leaf.getGrammarElement() instanceof EnumLiteralDeclaration) {
                Keyword keyword = ((EnumLiteralDeclaration)leaf.getGrammarElement()).getLiteral();
                return Tuples.create((Object)keyword, (Object)new Region(leaf.getOffset(), leaf.getLength()));
            }
        }
        return null;
    }

    private ILeafNode findNearestLeafNode(IParseResult parseResult, int offset) {
        ILeafNode leaf = NodeModelUtils.findLeafNodeAtOffset((INode)parseResult.getRootNode(), (int)offset);
        if (leaf != null && leaf.isHidden() && leaf.getOffset() == offset) {
            leaf = NodeModelUtils.findLeafNodeAtOffset((INode)parseResult.getRootNode(), (int)(offset - 1));
        }
        return leaf;
    }
}

