/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.ui.cdt;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.CIncludePathEntry;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.common.util.URI;
import org.eclipse.etrice.generator.ui.cdt.ProjectConfigurator;
import org.eclipse.etrice.generator.ui.wizard.ProjectCreator;
import org.eclipse.etrice.generator.ui.wizard.WizardHelpers;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;
import org.eclipse.ui.wizards.datatransfer.ZipFileStructureProvider;

public class CProjectConfigurator
extends ProjectConfigurator {
    private static final String C_MODELLIB_FOLDER_NAME = "etrice_modellib";
    private static final String C_RUNTIME_FOLDER_NAME = "etrice_runtime";
    protected static final IOverwriteQuery OVERWRITE_ALL_QUERY = new IOverwriteQuery(){

        public String queryOverwrite(String pathString) {
            return "ALL";
        }
    };

    @Override
    public boolean isApplicable(IProject project) {
        return CoreModel.hasCNature((IProject)project) && !CoreModel.hasCCNature((IProject)project);
    }

    @Override
    public boolean isIncludePathId(String id) {
        if (id.startsWith("cdt.managedbuild.tool.gnu.c.compiler")) {
            return true;
        }
        if (id.startsWith("org.eclipse.cdt.msvc.cl.inputType.c")) {
            return true;
        }
        if (id.startsWith("cdt.managedbuild.tool.gnu.c.compiler.input")) {
            return true;
        }
        if (id.startsWith("com.ifx.xmc1000.compiler.option.include.paths")) {
            return true;
        }
        if (id.startsWith("com.ifx.xmc1000.cppcompiler.option.include.paths")) {
            return true;
        }
        if (id.startsWith("com.ifx.xmc4000.compiler.option.include.paths")) {
            return true;
        }
        if (id.startsWith("com.ifx.xmc4000.cppcompiler.option.include.paths")) {
            return true;
        }
        if (id.startsWith("org.eclipse.cdt.cross.arm.gnu.sourcery.windows.c.compiler.base.input")) {
            return true;
        }
        return id.startsWith("org.eclipse.cdt.cross.arm.gnu.sourcery.linux.c.compiler.base.input");
    }

    @Override
    public List<CIncludePathEntry> getIncludePaths() {
        ArrayList<CIncludePathEntry> srcIncludes = new ArrayList<CIncludePathEntry>();
        srcIncludes.add(new CIncludePathEntry("${workspace_loc:/${ProjName}/src-gen}", 4));
        if (this.isCopyRuntime()) {
            srcIncludes.add(new CIncludePathEntry("${workspace_loc:/${ProjName}/etrice_runtime/src/common}", 4));
            srcIncludes.add(new CIncludePathEntry("${workspace_loc:/${ProjName}/etrice_runtime/src/config}", 4));
            srcIncludes.add(new CIncludePathEntry("${workspace_loc:/${ProjName}/etrice_runtime/src/util}", 4));
            srcIncludes.add(new CIncludePathEntry("${workspace_loc:/${ProjName}/etrice_runtime/src/platforms/" + this.getPlatform() + "}", 4));
        }
        return srcIncludes;
    }

    @Override
    public Map<String, String> getProjectRefInfo(ICConfigurationDescription configDescription, String toolChain) {
        Map projectRefInfo = configDescription.getReferenceInfo();
        if (!this.isCopyRuntime()) {
            if (toolChain == "MinGW GCC") {
                projectRefInfo.put("org.eclipse.etrice.runtime.c", "cdt.managedbuild.config.gnu.mingw.lib.debug.1978608919");
                projectRefInfo.put("org.eclipse.etrice.modellib.c", "cdt.managedbuild.config.gnu.mingw.lib.debug.847049798");
            } else if (toolChain == "Linux GCC") {
                projectRefInfo.put("org.eclipse.etrice.runtime.c", "cdt.managedbuild.config.gnu.mingw.lib.debug.1978608919.294295052");
                projectRefInfo.put("org.eclipse.etrice.modellib.c", "cdt.managedbuild.config.gnu.mingw.lib.debug.847049798.58778989");
            }
        }
        return projectRefInfo;
    }

    @Override
    protected void configureModelpath(IProject project, IPath path) {
        if (!project.getFile("modelpath").exists()) {
            ArrayList<String> srcDirs = new ArrayList<String>();
            IPath dir = path.removeFirstSegments(1);
            if (!dir.isEmpty()) {
                srcDirs.add(dir.toPortableString());
            }
            if (this.isCopyRuntime()) {
                srcDirs.add("etrice_modellib/model");
            }
            URI modelpathURI = URI.createPlatformResourceURI((String)project.getFullPath().append("modelpath").toPortableString(), (boolean)false);
            ProjectCreator.createModelpathDescription((URI)modelpathURI, srcDirs, Collections.emptyList());
        }
    }

    @Override
    public void copyRuntime(IProject project, IProgressMonitor progressMonitor, String platform) {
        this.copyCRuntime(project, progressMonitor);
        this.copyCModellib(project, progressMonitor);
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void copyCRuntime(IProject project, IProgressMonitor progressMonitor) {
        ImportOperation importOperation = null;
        ZipFile zipFile = null;
        try {
            zipFile = WizardHelpers.getCRuntimeZip();
            if (zipFile != null) {
                ZipFileStructureProvider structureProvider = new ZipFileStructureProvider(zipFile);
                List children = structureProvider.getChildren((Object)structureProvider.getRoot());
                ZipEntry current = null;
                for (Object child : children) {
                    if (!(child instanceof ZipEntry) || !((ZipEntry)child).getName().equals("src/")) continue;
                    current = (ZipEntry)child;
                    break;
                }
                if (current != null) {
                    importOperation = new ImportOperation(project.getFullPath().append(C_RUNTIME_FOLDER_NAME), current, (IImportStructureProvider)structureProvider, OVERWRITE_ALL_QUERY);
                }
            }
            if (importOperation == null) throw new Exception("File error during runtime import");
            importOperation.setContext(null);
            importOperation.run((IProgressMonitor)SubMonitor.convert((IProgressMonitor)progressMonitor, (int)1));
            IFolder folder = project.getFolder(C_RUNTIME_FOLDER_NAME);
            folder = folder.getFolder("src");
            folder = folder.getFolder("platforms");
            IResource[] iResourceArray = folder.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource platform = iResourceArray[n2];
                if (platform.getType() == 2 && !platform.getName().equals(this.getPlatform())) {
                    this.removeUnusedPlatform(platform, progressMonitor);
                }
                ++n2;
            }
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            if (zipFile == null) return;
            try {
                zipFile.close();
                return;
            }
            catch (IOException iOException) {}
            return;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            if (zipFile == null) return;
            try {
                zipFile.close();
                return;
            }
            catch (IOException iOException) {}
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            if (zipFile == null) return;
            {
                catch (Throwable throwable) {
                    if (zipFile == null) throw throwable;
                    try {
                        zipFile.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
            }
            try {
                zipFile.close();
                return;
            }
            catch (IOException iOException) {}
            return;
        }
        if (zipFile == null) return;
        try {
            zipFile.close();
            return;
        }
        catch (IOException iOException) {}
    }

    private void removeUnusedPlatform(final IResource platform, IProgressMonitor progressMonitor) {
        ISchedulingRule rule = ResourcesPlugin.getWorkspace().getRuleFactory().createRule(platform);
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(rule){

            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                platform.delete(true, monitor);
            }
        };
        try {
            operation.run(progressMonitor);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void copyCModellib(IProject project, IProgressMonitor progressMonitor) {
        ZipFile zipFile = null;
        try {
            zipFile = WizardHelpers.getCModellibZip();
            if (zipFile != null) {
                ZipFileStructureProvider structureProvider = new ZipFileStructureProvider(zipFile);
                List children = structureProvider.getChildren((Object)structureProvider.getRoot());
                ZipEntry current = null;
                for (Object child : children) {
                    if (!(child instanceof ZipEntry) || !((ZipEntry)child).getName().equals("model/")) continue;
                    current = (ZipEntry)child;
                    break;
                }
                if (current != null) {
                    children = structureProvider.getChildren(current);
                    for (Object child : children) {
                        if (!(child instanceof ZipEntry)) continue;
                        ImportOperation importOperation = new ImportOperation(project.getFullPath().append(C_MODELLIB_FOLDER_NAME), child, (IImportStructureProvider)structureProvider, OVERWRITE_ALL_QUERY);
                        importOperation.setContext(null);
                        importOperation.run((IProgressMonitor)SubMonitor.convert((IProgressMonitor)progressMonitor, (int)1));
                    }
                }
            }
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            if (zipFile == null) return;
            try {
                zipFile.close();
                return;
            }
            catch (IOException iOException) {}
            return;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            if (zipFile == null) return;
            try {
                zipFile.close();
                return;
            }
            catch (IOException iOException) {}
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            if (zipFile == null) return;
            {
                catch (Throwable throwable) {
                    if (zipFile == null) throw throwable;
                    try {
                        zipFile.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
            }
            try {
                zipFile.close();
                return;
            }
            catch (IOException iOException) {}
            return;
        }
        if (zipFile == null) return;
        try {
            zipFile.close();
            return;
        }
        catch (IOException iOException) {}
    }

    protected ZipFile createZipFile(File file) {
        try {
            return new ZipFile(file);
        }
        catch (ZipException zipException) {
        }
        catch (IOException iOException) {}
        return null;
    }

    @Override
    protected void customizeBuildConfig(IProject project, IConfiguration buildConfig) {
    }
}

