/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.naming;

import java.lang.reflect.InvocationHandler;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Binding;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import org.eclipse.gemini.naming.InvocationHandlerFactory;
import org.eclipse.gemini.naming.NotSupportedContext;
import org.eclipse.gemini.naming.OSGiURLParser;
import org.eclipse.gemini.naming.ReflectionUtils;
import org.eclipse.gemini.naming.ServiceBasedNamingEnumeration;
import org.eclipse.gemini.naming.ServiceInvocationHandler;
import org.eclipse.gemini.naming.ServiceProxyInfo;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

class OSGiServiceListContext
extends NotSupportedContext {
    private static Logger logger = Logger.getLogger(OSGiServiceListContext.class.getName());
    private final BundleContext m_bundleContext;
    private final ServiceReference[] m_serviceReferences;
    private final OSGiURLParser m_urlParser;
    private final Map m_mapOfServices = new HashMap();

    OSGiServiceListContext(BundleContext bundleContext, ServiceReference[] serviceReferences, OSGiURLParser urlParser) {
        super("This operation is not supported in an osgi:servicelist context");
        this.m_bundleContext = bundleContext;
        this.m_serviceReferences = serviceReferences;
        this.m_urlParser = urlParser;
        OSGiServiceListContext.buildMapOfServices(this.m_mapOfServices, this.m_serviceReferences);
    }

    @Override
    public void close() throws NamingException {
    }

    @Override
    public NamingEnumeration list(String name) throws NamingException {
        if (name.equals("")) {
            return new ListNamingEnumeration(this.m_bundleContext, this.m_serviceReferences, this.m_urlParser.getServiceInterface());
        }
        throw new OperationNotSupportedException("This NamingEnumeration cannot support list() operations for anything other than the empty string");
    }

    @Override
    public NamingEnumeration listBindings(String name) throws NamingException {
        if (name.equals("")) {
            return new ListBindingsNamingEnumeration(this.m_bundleContext, this.m_serviceReferences, this.m_urlParser);
        }
        throw new OperationNotSupportedException("This NamingEnumeration cannot support list() operations for anything other than the empty string");
    }

    @Override
    public Object lookup(String name) throws NamingException {
        Long serviceId = new Long(name);
        if (serviceId == null) {
            throw new NameNotFoundException("Service with the name = " + name + " does not exist in this context");
        }
        if (this.m_mapOfServices.containsKey(serviceId)) {
            ServiceReference serviceReference = (ServiceReference)this.m_mapOfServices.get(serviceId);
            ServiceProxyInfo proxyInfo = OSGiServiceListContext.createNoRetryProxiedService(this.m_bundleContext, this.m_urlParser, serviceReference);
            if (!proxyInfo.isProxied()) {
                logger.log(Level.WARNING, "The service returned could not be proxied, OSGi lifecycle maintenance will not be handled by the Context Manager service");
            }
            return proxyInfo.getService();
        }
        throw new NameNotFoundException("Service with the name = " + name + " does not exist in this context");
    }

    private static ServiceProxyInfo createNoRetryProxiedService(BundleContext bundleContext, OSGiURLParser urlParser, ServiceReference serviceReference) {
        return ReflectionUtils.getProxyForSingleService(bundleContext, urlParser, serviceReference, new NoRetryInvocationHandlerFactory());
    }

    private static void buildMapOfServices(Map mapOfServices, ServiceReference[] serviceReferences) {
        int i = 0;
        while (i < serviceReferences.length) {
            Long serviceId = (Long)serviceReferences[i].getProperty("service.id");
            mapOfServices.put(serviceId, serviceReferences[i]);
            ++i;
        }
    }

    private static class ListBindingsNamingEnumeration
    extends ServiceBasedNamingEnumeration {
        private final List m_listOfHandlers = new LinkedList();

        ListBindingsNamingEnumeration(BundleContext bundleContext, ServiceReference[] serviceReferences, OSGiURLParser urlParser) {
            super(bundleContext, serviceReferences, urlParser.getServiceInterface());
            this.m_nameClassPairs = new Binding[this.m_serviceReferences.length];
            int i = 0;
            while (i < this.m_serviceReferences.length) {
                Long serviceId = (Long)this.m_serviceReferences[i].getProperty("service.id");
                ServiceReference serviceReference = this.m_serviceReferences[i];
                ServiceProxyInfo proxyInfo = OSGiServiceListContext.createNoRetryProxiedService(bundleContext, urlParser, serviceReference);
                this.m_listOfHandlers.add(proxyInfo.getHandler());
                this.m_nameClassPairs[i] = new Binding(serviceId.toString(), this.m_interfaceName, proxyInfo.getService());
                ++i;
            }
        }

        @Override
        public void close() throws NamingException {
            super.close();
            int i = 0;
            while (i < this.m_serviceReferences.length) {
                this.m_bundleContext.ungetService(this.m_serviceReferences[i]);
                ++i;
            }
            for (NoRetryServiceInvocationHandler handler : this.m_listOfHandlers) {
                handler.close();
            }
        }
    }

    private static class ListNamingEnumeration
    extends ServiceBasedNamingEnumeration {
        ListNamingEnumeration(BundleContext bundleContext, ServiceReference[] serviceReferences, String interfaceName) {
            super(bundleContext, serviceReferences, interfaceName);
            this.m_nameClassPairs = new NameClassPair[this.m_serviceReferences.length];
            int i = 0;
            while (i < this.m_serviceReferences.length) {
                Long serviceId = (Long)this.m_serviceReferences[i].getProperty("service.id");
                this.m_nameClassPairs[i] = new NameClassPair(serviceId.toString(), this.m_interfaceName);
                ++i;
            }
        }
    }

    private static class NoRetryInvocationHandlerFactory
    implements InvocationHandlerFactory {
        private NoRetryInvocationHandlerFactory() {
        }

        @Override
        public InvocationHandler create(BundleContext bundleContext, ServiceReference serviceReference, OSGiURLParser urlParser, Object osgiService) {
            return new NoRetryServiceInvocationHandler(bundleContext, serviceReference, urlParser, osgiService);
        }
    }

    private static class NoRetryServiceInvocationHandler
    extends ServiceInvocationHandler {
        NoRetryServiceInvocationHandler(BundleContext callerBundleContext, ServiceReference serviceReference, OSGiURLParser urlParser, Object osgiService) {
            super(callerBundleContext, serviceReference, urlParser, osgiService);
        }

        @Override
        protected boolean obtainService() {
            this.m_serviceTracker.close();
            return false;
        }
    }
}

