/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.mgmt.framework.internal;

import java.util.HashMap;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.OpenDataException;
import org.eclipse.gemini.mgmt.framework.CustomBundleWiringStateMBean;
import org.eclipse.gemini.mgmt.framework.internal.OSGiBundleCapability;
import org.eclipse.gemini.mgmt.framework.internal.OSGiBundleRequirement;
import org.eclipse.gemini.mgmt.framework.internal.OSGiBundleRevisionIdTracker;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;

public final class OSGiBundleWire {
    private final BundleWire wire;

    public OSGiBundleWire(BundleWire wire) {
        this.wire = wire;
    }

    public CompositeData asCompositeData() {
        HashMap<String, Object> items = new HashMap<String, Object>();
        BundleWiring providerWiring = this.wire.getProviderWiring();
        BundleWiring requirerWiring = this.wire.getRequirerWiring();
        if (providerWiring != null && requirerWiring != null) {
            items.put("BundleRequirement", new OSGiBundleRequirement(this.wire.getRequirement()).asCompositeData());
            items.put("BundleCapability", new OSGiBundleCapability(this.wire.getCapability()).asCompositeData());
            items.put("ProviderBundleId", providerWiring.getBundle().getBundleId());
            items.put("RequirerBundleId", requirerWiring.getBundle().getBundleId());
        }
        try {
            return new CompositeDataSupport(CustomBundleWiringStateMBean.BUNDLE_WIRE_TYPE, items);
        }
        catch (OpenDataException e) {
            throw new IllegalStateException("Cannot form wire open data", e);
        }
    }

    public CompositeData asCompositeData(OSGiBundleRevisionIdTracker revisionTracker) {
        HashMap<String, Object> items = new HashMap<String, Object>();
        BundleWiring providerWiring = this.wire.getProviderWiring();
        BundleWiring requirerWiring = this.wire.getRequirerWiring();
        if (providerWiring != null && requirerWiring != null) {
            items.put("BundleRequirement", new OSGiBundleRequirement(this.wire.getRequirement()).asCompositeData());
            items.put("BundleCapability", new OSGiBundleCapability(this.wire.getCapability()).asCompositeData());
            items.put("ProviderBundleId", providerWiring.getBundle().getBundleId());
            items.put("ProviderBundleRevisionId", revisionTracker.getRevisionId(providerWiring.getRevision()));
            items.put("RequirerBundleId", requirerWiring.getBundle().getBundleId());
            items.put("RequirerBundleRevisionId", revisionTracker.getRevisionId(requirerWiring.getRevision()));
        }
        try {
            return new CompositeDataSupport(CustomBundleWiringStateMBean.BUNDLE_REVISION_WIRE_TYPE, items);
        }
        catch (OpenDataException e) {
            throw new IllegalStateException("Cannot form wire open data", e);
        }
    }
}

