/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.naming;

import java.security.PrivilegedExceptionAction;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.gemini.naming.SecurityUtils;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleReference;

class BuilderUtils {
    private static Logger logger = Logger.getLogger(BuilderUtils.class.getName());
    private static final GetBundleContextStrategy[] getBundleContextStrategies = new GetBundleContextStrategy[]{new EnvironmentPropertyStrategyImpl(), new ThreadContextStrategyImpl(), new CallStackStrategyImpl()};

    private BuilderUtils() {
    }

    static BundleContext getBundleContext(Hashtable environment, String namingClassType) {
        int i = 0;
        while (i < getBundleContextStrategies.length) {
            BundleContext clientBundleContext = getBundleContextStrategies[i].getBundleContext(environment, namingClassType);
            if (clientBundleContext != null) {
                return clientBundleContext;
            }
            ++i;
        }
        return null;
    }

    private static BundleContext getBundleContextFromClassLoader(ClassLoader classLoader) {
        BundleReference bundleRef = (BundleReference)classLoader;
        if (bundleRef.getBundle() != null) {
            return bundleRef.getBundle().getBundleContext();
        }
        return null;
    }

    private static class CallStackStrategyImpl
    implements GetBundleContextStrategy {
        private CallStackStrategyImpl() {
        }

        @Override
        public BundleContext getBundleContext(Hashtable environment, String namingClassType) {
            Class[] callStack = null;
            try {
                callStack = (Class[])SecurityUtils.invokePrivilegedAction(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return new CallStackSecurityManager().getClientCallStack();
                    }
                });
            }
            catch (Exception e) {
                logger.log(Level.FINE, "Exception occurred while attempting to traverse client call stack to find caller's BundleContext.", e);
            }
            int indexOfConstructor = -1;
            int i = 0;
            while (callStack != null && i < callStack.length) {
                if (callStack[i].getName().equals(namingClassType)) {
                    indexOfConstructor = i;
                }
                ++i;
            }
            if (indexOfConstructor >= 0 && indexOfConstructor + 1 < callStack.length) {
                final Class clientClass = callStack[indexOfConstructor + 1];
                ClassLoader clientClassLoader = null;
                try {
                    clientClassLoader = (ClassLoader)SecurityUtils.invokePrivilegedAction(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            return clientClass.getClassLoader();
                        }
                    });
                }
                catch (Exception e) {
                    logger.log(Level.FINE, "Exception occurred while trying to obtain the client classloader.", e);
                }
                if (clientClassLoader instanceof BundleReference) {
                    return BuilderUtils.getBundleContextFromClassLoader(clientClassLoader);
                }
            }
            return null;
        }

        private static class CallStackSecurityManager
        extends SecurityManager {
            private CallStackSecurityManager() {
            }

            public Class[] getClientCallStack() {
                return this.getClassContext();
            }
        }
    }

    private static class EnvironmentPropertyStrategyImpl
    implements GetBundleContextStrategy {
        private EnvironmentPropertyStrategyImpl() {
        }

        @Override
        public BundleContext getBundleContext(Hashtable environment, String namingClassType) {
            Object result;
            if (environment != null && environment.containsKey("osgi.service.jndi.bundleContext") && (result = environment.get("osgi.service.jndi.bundleContext")) instanceof BundleContext) {
                return (BundleContext)result;
            }
            return null;
        }
    }

    private static interface GetBundleContextStrategy {
        public BundleContext getBundleContext(Hashtable var1, String var2);
    }

    private static class ThreadContextStrategyImpl
    implements GetBundleContextStrategy {
        private ThreadContextStrategyImpl() {
        }

        @Override
        public BundleContext getBundleContext(Hashtable environment, String namingClassType) {
            BundleContext result;
            ClassLoader threadContextClassloader = null;
            try {
                threadContextClassloader = (ClassLoader)SecurityUtils.invokePrivilegedAction(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return Thread.currentThread().getContextClassLoader();
                    }
                });
            }
            catch (Exception e) {
                logger.log(Level.FINE, "Exception occurred while trying to obtain the ThreadContextClassloader.", e);
            }
            if (threadContextClassloader != null && threadContextClassloader instanceof BundleReference && (result = BuilderUtils.getBundleContextFromClassLoader(threadContextClassloader)) != null) {
                return result;
            }
            return null;
        }
    }
}

