/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.naming;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.naming.directory.Attributes;
import javax.naming.spi.DirObjectFactory;
import javax.naming.spi.InitialContextFactory;
import javax.naming.spi.InitialContextFactoryBuilder;
import javax.naming.spi.ObjectFactory;
import javax.naming.spi.ObjectFactoryBuilder;
import org.eclipse.gemini.naming.BuilderSupportedInitialContextFactory;
import org.eclipse.gemini.naming.DefaultInitialContextFactory;
import org.eclipse.gemini.naming.FactoryManager;
import org.eclipse.gemini.naming.InitialContextFactoryWrapper;
import org.eclipse.gemini.naming.SecurityUtils;
import org.eclipse.gemini.naming.ServiceUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

class OSGiInitialContextFactoryBuilder
implements InitialContextFactoryBuilder,
ObjectFactoryBuilder,
FactoryManager {
    private static Logger logger = Logger.getLogger(OSGiInitialContextFactoryBuilder.class.getName());
    private static final String JNDI_PROPERTIES_FILE_NAME = "jndi.properties";
    private static final String NO_CONTEXT_FACTORIES_MSG = "No JNDI implementations available";
    private final BundleContext m_callerBundleContext;
    private final BundleContext m_implBundleContext;
    private ServiceTracker m_contextFactoryServiceTracker = null;
    private ServiceTracker m_contextFactoryBuilderServiceTracker = null;
    private ServiceTracker m_objectFactoryServiceTracker = null;
    private ServiceTracker m_objectFactoryBuilderServiceTracker = null;
    private ServiceTracker m_urlContextFactoryServiceTracker = null;
    private ServiceTracker m_dirObjectFactoryServiceTracker = null;
    private final Map m_mapOfServicesToContexts = Collections.synchronizedMap(new HashMap());

    public OSGiInitialContextFactoryBuilder(BundleContext callerBundleContext, BundleContext implBundleContext) {
        this.m_callerBundleContext = callerBundleContext;
        this.m_implBundleContext = implBundleContext;
        try {
            SecurityUtils.invokePrivilegedActionNoReturn(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    OSGiInitialContextFactoryBuilder.this.createServiceTrackers(OSGiInitialContextFactoryBuilder.this.m_implBundleContext);
                    return null;
                }
            });
        }
        catch (Exception e) {
            logger.log(Level.FINE, "Exception occurred while creating ServiceTracker implementations for JNDI Provider Services", e);
        }
    }

    public InitialContextFactory createInitialContextFactory(Hashtable environment) throws NamingException {
        if (this.m_contextFactoryServiceTracker == null) {
            throw new NoInitialContextException(NO_CONTEXT_FACTORIES_MSG);
        }
        return this.getInitialContextFactoryInternal(this.getCombinedEnvironment(environment));
    }

    private InitialContextFactory getInitialContextFactoryInternal(Hashtable environment) throws NoInitialContextException {
        if (environment.get("java.naming.factory.initial") != null) {
            String initialContextFactoryName = (String)environment.get("java.naming.factory.initial");
            Object factory = this.obtainFactoryService(initialContextFactoryName, this.m_contextFactoryServiceTracker);
            if (factory != null) {
                return new InitialContextFactoryWrapper((InitialContextFactory)factory, this);
            }
            InitialContextFactory contextFactory = this.getContextFactoryFromBuilder(environment);
            if (contextFactory != null) {
                return new InitialContextFactoryWrapper(contextFactory, this);
            }
            throw new NoInitialContextException(NO_CONTEXT_FACTORIES_MSG);
        }
        InitialContextFactory contextFactory = this.getContextFactoryFromBuilder(environment);
        if (contextFactory != null) {
            return new InitialContextFactoryWrapper(contextFactory, this);
        }
        try {
            InitialContextFactory defaultContextFactory = this.getDefaultInitialContextFactory(environment);
            if (defaultContextFactory == null) {
                return new InitialContextFactoryWrapper(new DefaultInitialContextFactory(), this);
            }
            return new InitialContextFactoryWrapper(defaultContextFactory, this);
        }
        catch (NamingException namingException) {
            NoInitialContextException noInitialContextException = new NoInitialContextException("Exception occured while iterating over the default InitialContextFactory services");
            noInitialContextException.setRootCause(namingException);
            throw noInitialContextException;
        }
    }

    public ObjectFactory createObjectFactory(Object obj, Hashtable environment) throws NamingException {
        if (this.m_objectFactoryServiceTracker == null) {
            throw new NoInitialContextException("No Object factories available");
        }
        return new ReturnReferenceInfoObjectFactory(this.createInnerObjectFactory(obj));
    }

    public DirObjectFactory getDirObjectFactory(Object obj, Hashtable environment) throws NamingException {
        if (this.m_dirObjectFactoryServiceTracker == null) {
            throw new NamingException("No DirObjectFactories available");
        }
        return new ReturnReferenceInfoDirObjectFactory(this.createInnerDirObjectFactory(obj));
    }

    @Override
    public ObjectFactory getURLContextFactory(String urlScheme) {
        if (this.m_urlContextFactoryServiceTracker.getServiceReferences() != null) {
            ServiceReference[] serviceReferences = ServiceUtils.sortServiceReferences(this.m_urlContextFactoryServiceTracker);
            int i = 0;
            while (i < serviceReferences.length) {
                ServiceReference serviceReference = serviceReferences[i];
                if (serviceReference.getProperty("osgi.jndi.url.scheme").equals(urlScheme)) {
                    return (ObjectFactory)this.m_callerBundleContext.getService(serviceReference);
                }
                ++i;
            }
        }
        return null;
    }

    @Override
    public void associateFactoryService(Object factory, Context createdContext) {
        if (this.m_mapOfServicesToContexts.containsKey(factory)) {
            List listOfContexts = (List)this.m_mapOfServicesToContexts.get(factory);
            listOfContexts.add(createdContext);
            this.m_mapOfServicesToContexts.put(factory, listOfContexts);
        } else {
            LinkedList<Context> listOfContexts = new LinkedList<Context>();
            listOfContexts.add(createdContext);
            this.m_mapOfServicesToContexts.put(factory, listOfContexts);
        }
    }

    @Override
    public boolean isFactoryServiceActive(Object factory) {
        return this.m_mapOfServicesToContexts.containsKey(factory);
    }

    protected void close() {
        this.m_contextFactoryBuilderServiceTracker.close();
        this.m_contextFactoryServiceTracker.close();
        this.m_objectFactoryServiceTracker.close();
        this.m_objectFactoryBuilderServiceTracker.close();
        this.m_urlContextFactoryServiceTracker.close();
        this.m_dirObjectFactoryServiceTracker.close();
    }

    private final void createServiceTrackers(BundleContext bundleContext) {
        this.m_contextFactoryServiceTracker = new ContextFactoryServiceTracker(bundleContext, InitialContextFactory.class.getName());
        this.m_contextFactoryBuilderServiceTracker = new ContextFactoryServiceTracker(bundleContext, InitialContextFactoryBuilder.class.getName());
        this.m_objectFactoryServiceTracker = new ObjectFactoryServiceTracker(bundleContext, ObjectFactory.class.getName());
        this.m_dirObjectFactoryServiceTracker = new ObjectFactoryServiceTracker(bundleContext, DirObjectFactory.class.getName());
        this.m_objectFactoryBuilderServiceTracker = OSGiInitialContextFactoryBuilder.createServiceTracker(bundleContext, ObjectFactoryBuilder.class.getName());
        this.m_urlContextFactoryServiceTracker = new URLContextFactoryServiceTracker(bundleContext, ObjectFactory.class.getName());
        this.m_contextFactoryServiceTracker.open();
        this.m_contextFactoryBuilderServiceTracker.open();
        this.m_objectFactoryServiceTracker.open();
        this.m_objectFactoryBuilderServiceTracker.open();
        this.m_dirObjectFactoryServiceTracker.open();
        this.m_urlContextFactoryServiceTracker.open();
    }

    private Object obtainFactoryService(String factoryServiceInterface, ServiceTracker serviceTracker) {
        ServiceReference[] serviceReferences = ServiceUtils.sortServiceReferences(serviceTracker);
        int i = 0;
        while (i < serviceReferences.length) {
            ServiceReference serviceReference = serviceReferences[i];
            String[] serviceInterfaces = (String[])serviceReference.getProperty("objectClass");
            List<String> interfaceList = Arrays.asList(serviceInterfaces);
            if (interfaceList.contains(factoryServiceInterface)) {
                return this.m_callerBundleContext.getService(serviceReference);
            }
            ++i;
        }
        return null;
    }

    private InitialContextFactory getContextFactoryFromBuilder(Hashtable environment) {
        if (this.m_contextFactoryBuilderServiceTracker.getServiceReferences() != null) {
            ServiceReference[] serviceReferences = ServiceUtils.sortServiceReferences(this.m_contextFactoryBuilderServiceTracker);
            int i = 0;
            while (i < serviceReferences.length) {
                ServiceReference serviceReference = serviceReferences[i];
                InitialContextFactoryBuilder builder = (InitialContextFactoryBuilder)this.m_callerBundleContext.getService(serviceReference);
                try {
                    InitialContextFactory contextFactory;
                    if (builder != null && (contextFactory = builder.createInitialContextFactory(environment)) != null) {
                        return new DefaultBuilderSupportedInitialContextFactory(contextFactory, builder);
                    }
                }
                catch (NamingException namingException) {
                    logger.log(Level.FINE, "NamingException occurred while invoking on an InitialContextFactoryBuilder", namingException);
                }
                ++i;
            }
        }
        return null;
    }

    private InitialContextFactory getDefaultInitialContextFactory(Hashtable environment) throws NamingException {
        if (this.m_contextFactoryServiceTracker.getServiceReferences() != null) {
            ServiceReference[] serviceReferences = ServiceUtils.sortServiceReferences(this.m_contextFactoryServiceTracker);
            int i = 0;
            while (i < serviceReferences.length) {
                ServiceReference serviceReference = serviceReferences[i];
                InitialContextFactory factoryService = (InitialContextFactory)this.m_callerBundleContext.getService(serviceReference);
                if (factoryService.getInitialContext(environment) != null) {
                    return factoryService;
                }
                this.m_callerBundleContext.ungetService(serviceReference);
                ++i;
            }
        }
        return null;
    }

    private ObjectFactory getObjectFactoryFromBuilder(Hashtable environment, Object refInfo) {
        if (this.m_objectFactoryBuilderServiceTracker.getServiceReferences() != null) {
            ServiceReference[] serviceReferences = ServiceUtils.sortServiceReferences(this.m_objectFactoryBuilderServiceTracker);
            int i = 0;
            while (i < serviceReferences.length) {
                ServiceReference serviceReference = serviceReferences[i];
                ObjectFactoryBuilder builder = (ObjectFactoryBuilder)this.m_callerBundleContext.getService(serviceReference);
                try {
                    ObjectFactory factory = builder.createObjectFactory(refInfo, environment);
                    if (factory != null) {
                        return factory;
                    }
                }
                catch (NamingException namingException) {
                    logger.log(Level.FINE, "NamingException occurred while invoking on an ObjectFactoryBuilder", namingException);
                }
                ++i;
            }
        }
        return null;
    }

    private Object getObjectFromURLContextFactoryFromReference(Reference reference, Hashtable environment) {
        Enumeration<RefAddr> refAddresses = reference.getAll();
        while (refAddresses.hasMoreElements()) {
            RefAddr address = refAddresses.nextElement();
            if (!(address instanceof StringRefAddr) || !address.getType().equals("URL")) continue;
            String urlContent = (String)address.getContent();
            try {
                Object objToReturn;
                URI uri = new URI(urlContent);
                ObjectFactory objectFactory = this.getURLContextFactory(uri.getScheme());
                if (objectFactory == null || (objToReturn = objectFactory.getObjectInstance(urlContent, null, null, environment)) == null) continue;
                return objToReturn;
            }
            catch (URISyntaxException e) {
                logger.log(Level.FINEST, "Exception thrown while parsing URL.  This URL reference address will be skipped.", e);
            }
            catch (Exception e) {
                logger.log(Level.FINEST, "Exception thrown while parsing URL.  This URL reference address will be skipped.", e);
            }
        }
        return null;
    }

    private Object getObjectToResolve(Object obj) throws NamingException {
        Object objToResolve;
        if (obj instanceof Referenceable) {
            Referenceable referenceable = (Referenceable)obj;
            objToResolve = referenceable.getReference();
        } else {
            objToResolve = obj;
        }
        return objToResolve;
    }

    private ObjectFactory createInnerObjectFactory(Object obj) throws NamingException {
        Object objToResolve = this.getObjectToResolve(obj);
        if (objToResolve instanceof Reference) {
            Reference reference = (Reference)objToResolve;
            if (reference.getFactoryClassName() != null) {
                return new FactoryNameSpecifiedObjectFactory();
            }
            return new NoFactoryNameSpecifiedObjectFactory();
        }
        return new NoReferenceObjectFactory();
    }

    private DirObjectFactory createInnerDirObjectFactory(Object obj) throws NamingException {
        Object objToResolve = this.getObjectToResolve(obj);
        if (objToResolve instanceof Reference) {
            Reference reference = (Reference)objToResolve;
            if (reference.getFactoryClassName() != null) {
                return new FactoryNameSpecifiedDirObjectFactory();
            }
            return new NoFactoryNameSpecifiedDirObjectFactory();
        }
        return new NoReferenceDirObjectFactory();
    }

    private Hashtable getCombinedEnvironment(Hashtable userEnvironment) {
        Hashtable<String, Object> combinedEnvironment = new Hashtable<String, Object>();
        combinedEnvironment.putAll(userEnvironment);
        Properties fileDefinedEnvironment = OSGiInitialContextFactoryBuilder.getFileDefinedJndiProperties(this.m_callerBundleContext);
        if (fileDefinedEnvironment != null) {
            Enumeration<Object> keyEnum = fileDefinedEnvironment.keys();
            while (keyEnum.hasMoreElements()) {
                String key = (String)keyEnum.nextElement();
                if (combinedEnvironment.containsKey(key)) continue;
                combinedEnvironment.put(key, fileDefinedEnvironment.get(key));
            }
        }
        return combinedEnvironment;
    }

    private Object resolveObjectUsingBuilders(Object objectToResolve, Name name, Context context, Hashtable environment) throws Exception {
        Object resolvedObject;
        ObjectFactory objectFactory = this.getObjectFactoryFromBuilder(environment, objectToResolve);
        if (objectFactory != null && (resolvedObject = objectFactory.getObjectInstance(objectToResolve, name, context, environment)) != null) {
            return resolvedObject;
        }
        return null;
    }

    private Object resolveObjectUsingObjectFactories(Object objectToResolve, Name name, Context context, Hashtable environment) throws NamingException {
        if (this.m_objectFactoryServiceTracker.getServiceReferences() != null) {
            ServiceReference[] serviceReferences = ServiceUtils.sortServiceReferences(this.m_objectFactoryServiceTracker);
            int i = 0;
            while (i < serviceReferences.length) {
                ServiceReference serviceReference = serviceReferences[i];
                ObjectFactory factory = (ObjectFactory)this.m_callerBundleContext.getService(serviceReference);
                try {
                    Object result = factory.getObjectInstance(objectToResolve, name, context, environment);
                    this.m_callerBundleContext.ungetService(serviceReference);
                    if (result != null) {
                        return result;
                    }
                }
                catch (Exception exception) {
                    NamingException namingException = new NamingException("Exception occurred while trying to resolve object using ObjectFactory search");
                    namingException.setRootCause(exception);
                    throw namingException;
                }
                ++i;
            }
        }
        return null;
    }

    private Object resolveObjectUsingDirObjectFactories(Object objectToResolve, Name name, Context context, Hashtable environment, Attributes attributes) throws NamingException {
        if (this.m_dirObjectFactoryServiceTracker.getServiceReferences() != null) {
            ServiceReference[] serviceReferences = ServiceUtils.sortServiceReferences(this.m_dirObjectFactoryServiceTracker);
            int i = 0;
            while (i < serviceReferences.length) {
                ServiceReference serviceReference = serviceReferences[i];
                DirObjectFactory factory = (DirObjectFactory)this.m_callerBundleContext.getService(serviceReference);
                try {
                    Object result = factory.getObjectInstance(objectToResolve, name, context, environment, attributes);
                    this.m_callerBundleContext.ungetService(serviceReference);
                    if (result != null) {
                        return result;
                    }
                }
                catch (Exception exception) {
                    NamingException namingException = new NamingException("Exception occurred while trying to resolve object using ObjectFactory search");
                    namingException.setRootCause(exception);
                    throw namingException;
                }
                ++i;
            }
        }
        return null;
    }

    private Object resolveDirObjectUsingBuilders(Object objectToResolve, Name name, Context context, Hashtable environment, Attributes attributes) throws Exception {
        DirObjectFactory dirObjectFactory;
        Object resolvedObject;
        ObjectFactory objectFactory = this.getObjectFactoryFromBuilder(environment, objectToResolve);
        if (objectFactory != null && objectFactory instanceof DirObjectFactory && (resolvedObject = (dirObjectFactory = (DirObjectFactory)objectFactory).getObjectInstance(objectToResolve, name, context, environment, attributes)) != null) {
            return resolvedObject;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Properties getFileDefinedJndiProperties(BundleContext callerBundleContext) {
        if (callerBundleContext.getBundle() == null) return null;
        Bundle bundle = callerBundleContext.getBundle();
        try {
            URL propertiesURL = bundle.getResource(JNDI_PROPERTIES_FILE_NAME);
            if (propertiesURL == null) return null;
            InputStream userDefinedPropertiesStream = null;
            try {
                userDefinedPropertiesStream = propertiesURL.openStream();
                Properties fileDefinedJndiProperties = new Properties();
                fileDefinedJndiProperties.load(userDefinedPropertiesStream);
                Properties properties = fileDefinedJndiProperties;
                return properties;
            }
            catch (FileNotFoundException e) {
                logger.log(Level.FINEST, "Exception encountered while trying to locate a jndi.properties file.", e);
                return null;
            }
            finally {
                if (userDefinedPropertiesStream != null) {
                    try {
                        userDefinedPropertiesStream.close();
                    }
                    catch (IOException e2) {
                        logger.log(Level.FINEST, "Exception encountered while trying to close a jndi.properties file.", e2);
                    }
                }
            }
        }
        catch (IOException e3) {
            logger.log(Level.FINEST, "Exception encounted while trying to load a jndi.properties file", e3);
        }
        return null;
    }

    private static ServiceTracker createServiceTracker(BundleContext bundleContext, String serviceInterface) {
        return new ServiceTracker(bundleContext, serviceInterface, null);
    }

    private final class ContextFactoryServiceTracker
    extends ServiceTracker {
        private ContextFactoryServiceTracker(BundleContext context, String clazz) {
            super(context, clazz, null);
        }

        public void removedService(ServiceReference reference, Object service) {
            this.handleRemovedService(reference, service);
        }

        public Object addingService(ServiceReference reference) {
            return this.handleAddingService(reference);
        }

        private void handleRemovedService(ServiceReference reference, Object service) {
            super.removedService(reference, service);
            OSGiInitialContextFactoryBuilder.this.m_mapOfServicesToContexts.remove(service);
        }

        private Object handleAddingService(ServiceReference reference) {
            return super.addingService(reference);
        }
    }

    private static class DefaultBuilderSupportedInitialContextFactory
    implements BuilderSupportedInitialContextFactory {
        private final InitialContextFactory m_factory;
        private final InitialContextFactoryBuilder m_builder;

        DefaultBuilderSupportedInitialContextFactory(InitialContextFactory factory, InitialContextFactoryBuilder builder) {
            this.m_factory = factory;
            this.m_builder = builder;
        }

        @Override
        public InitialContextFactoryBuilder getBuilder() {
            return this.m_builder;
        }

        public Context getInitialContext(Hashtable environment) throws NamingException {
            return this.m_factory.getInitialContext(environment);
        }
    }

    private final class FactoryNameSpecifiedDirObjectFactory
    implements DirObjectFactory {
        private FactoryNameSpecifiedDirObjectFactory() {
        }

        public Object getObjectInstance(Object refInfo, Name name, Context context, Hashtable environment, Attributes attributes) throws Exception {
            Object objectToResolve = OSGiInitialContextFactoryBuilder.this.getObjectToResolve(refInfo);
            if (objectToResolve instanceof Reference) {
                Reference reference = (Reference)objectToResolve;
                Object factory = OSGiInitialContextFactoryBuilder.this.obtainFactoryService(reference.getFactoryClassName(), OSGiInitialContextFactoryBuilder.this.m_dirObjectFactoryServiceTracker);
                if (factory != null) {
                    DirObjectFactory dirObjectFactory = (DirObjectFactory)factory;
                    Object resolvedObject = dirObjectFactory.getObjectInstance(objectToResolve, name, context, environment, attributes);
                    if (resolvedObject != null) {
                        return resolvedObject;
                    }
                } else {
                    return OSGiInitialContextFactoryBuilder.this.resolveDirObjectUsingBuilders(objectToResolve, name, context, environment, attributes);
                }
            }
            return null;
        }

        public Object getObjectInstance(Object refInfo, Name name, Context context, Hashtable environment) throws Exception {
            return null;
        }
    }

    private final class FactoryNameSpecifiedObjectFactory
    implements ObjectFactory {
        private FactoryNameSpecifiedObjectFactory() {
        }

        public Object getObjectInstance(Object refInfo, Name name, Context context, Hashtable environment) throws Exception {
            Object objectToResolve = OSGiInitialContextFactoryBuilder.this.getObjectToResolve(refInfo);
            if (objectToResolve instanceof Reference) {
                Reference reference = (Reference)objectToResolve;
                Object factory = OSGiInitialContextFactoryBuilder.this.obtainFactoryService(reference.getFactoryClassName(), OSGiInitialContextFactoryBuilder.this.m_objectFactoryServiceTracker);
                if (factory != null) {
                    ObjectFactory objectFactory = (ObjectFactory)factory;
                    Object resolvedObject = objectFactory.getObjectInstance(objectToResolve, name, context, environment);
                    if (resolvedObject != null) {
                        return resolvedObject;
                    }
                } else {
                    return OSGiInitialContextFactoryBuilder.this.resolveObjectUsingBuilders(objectToResolve, name, context, environment);
                }
            }
            return null;
        }
    }

    private final class NoFactoryNameSpecifiedDirObjectFactory
    implements DirObjectFactory {
        private NoFactoryNameSpecifiedDirObjectFactory() {
        }

        public Object getObjectInstance(Object refInfo, Name name, Context context, Hashtable environment, Attributes attributes) throws Exception {
            if (refInfo == null) {
                return null;
            }
            Object objectToResolve = OSGiInitialContextFactoryBuilder.this.getObjectToResolve(refInfo);
            if (objectToResolve instanceof Reference) {
                Reference reference = (Reference)objectToResolve;
                Object resultFromURLContextFactories = OSGiInitialContextFactoryBuilder.this.getObjectFromURLContextFactoryFromReference(reference, environment);
                if (resultFromURLContextFactories != null) {
                    return resultFromURLContextFactories;
                }
                Object resultFromBuilders = OSGiInitialContextFactoryBuilder.this.resolveDirObjectUsingBuilders(objectToResolve, name, context, environment, attributes);
                if (resultFromBuilders != null) {
                    return resultFromBuilders;
                }
                Object resultFromDirObjectFactories = OSGiInitialContextFactoryBuilder.this.resolveObjectUsingDirObjectFactories(objectToResolve, name, context, environment, attributes);
                if (resultFromDirObjectFactories != null) {
                    return resultFromDirObjectFactories;
                }
            }
            return null;
        }

        public Object getObjectInstance(Object refInfo, Name name, Context context, Hashtable environment) throws Exception {
            return null;
        }
    }

    private final class NoFactoryNameSpecifiedObjectFactory
    implements ObjectFactory {
        private NoFactoryNameSpecifiedObjectFactory() {
        }

        public Object getObjectInstance(Object refInfo, Name name, Context context, Hashtable environment) throws Exception {
            if (refInfo == null) {
                return null;
            }
            Object objectToResolve = OSGiInitialContextFactoryBuilder.this.getObjectToResolve(refInfo);
            if (objectToResolve instanceof Reference) {
                Reference reference = (Reference)objectToResolve;
                Object resultFromURLContextFactories = OSGiInitialContextFactoryBuilder.this.getObjectFromURLContextFactoryFromReference(reference, environment);
                if (resultFromURLContextFactories != null) {
                    return resultFromURLContextFactories;
                }
                Object resultFromBuilders = OSGiInitialContextFactoryBuilder.this.resolveObjectUsingBuilders(objectToResolve, name, context, environment);
                if (resultFromBuilders != null) {
                    return resultFromBuilders;
                }
                Object resultFromObjectFactories = OSGiInitialContextFactoryBuilder.this.resolveObjectUsingObjectFactories(objectToResolve, name, context, environment);
                if (resultFromObjectFactories != null) {
                    return resultFromObjectFactories;
                }
            }
            return null;
        }
    }

    private class NoReferenceDirObjectFactory
    implements DirObjectFactory {
        private NoReferenceDirObjectFactory() {
        }

        public Object getObjectInstance(Object refInfo, Name name, Context context, Hashtable environment, Attributes attributes) throws Exception {
            Object resultFromBuilders = OSGiInitialContextFactoryBuilder.this.resolveDirObjectUsingBuilders(refInfo, name, context, environment, attributes);
            if (resultFromBuilders != null) {
                return resultFromBuilders;
            }
            Object resultFromDirObjectFactories = OSGiInitialContextFactoryBuilder.this.resolveObjectUsingDirObjectFactories(refInfo, name, context, environment, attributes);
            if (resultFromDirObjectFactories != null) {
                return resultFromDirObjectFactories;
            }
            return null;
        }

        public Object getObjectInstance(Object refInfo, Name name, Context context, Hashtable environment) throws Exception {
            return null;
        }
    }

    private class NoReferenceObjectFactory
    implements ObjectFactory {
        private NoReferenceObjectFactory() {
        }

        public Object getObjectInstance(Object refInfo, Name name, Context context, Hashtable environment) throws Exception {
            Object resultFromBuilders = OSGiInitialContextFactoryBuilder.this.resolveObjectUsingBuilders(refInfo, name, context, environment);
            if (resultFromBuilders != null) {
                return resultFromBuilders;
            }
            Object resultFromObjectFactories = OSGiInitialContextFactoryBuilder.this.resolveObjectUsingObjectFactories(refInfo, name, context, environment);
            if (resultFromObjectFactories != null) {
                return resultFromObjectFactories;
            }
            return null;
        }
    }

    private static final class ObjectFactoryServiceTracker
    extends ServiceTracker {
        private ObjectFactoryServiceTracker(BundleContext context, String clazz) {
            super(context, clazz, null);
        }

        public Object addingService(ServiceReference serviceReference) {
            if (serviceReference.getProperty("osgi.jndi.url.scheme") == null) {
                return super.addingService(serviceReference);
            }
            return null;
        }
    }

    private static final class ReturnReferenceInfoDirObjectFactory
    extends ReturnReferenceInfoObjectFactory
    implements DirObjectFactory {
        private final DirObjectFactory m_dirObjectFactory;

        public ReturnReferenceInfoDirObjectFactory(DirObjectFactory dirObjectFactory) {
            super(dirObjectFactory);
            this.m_dirObjectFactory = dirObjectFactory;
        }

        public Object getObjectInstance(Object refInfo, Name name, Context context, Hashtable environment, Attributes attributes) throws Exception {
            Object resolvedObject;
            if (this.m_dirObjectFactory != null && (resolvedObject = this.m_dirObjectFactory.getObjectInstance(refInfo, name, context, environment, attributes)) != null) {
                return resolvedObject;
            }
            return refInfo;
        }
    }

    private static class ReturnReferenceInfoObjectFactory
    implements ObjectFactory {
        private final ObjectFactory m_objectFactory;

        public ReturnReferenceInfoObjectFactory(ObjectFactory objectFactory) {
            this.m_objectFactory = objectFactory;
        }

        public Object getObjectInstance(Object refInfo, Name name, Context context, Hashtable environment) throws Exception {
            Object resolvedObject;
            if (this.m_objectFactory != null && (resolvedObject = this.m_objectFactory.getObjectInstance(refInfo, name, context, environment)) != null) {
                return resolvedObject;
            }
            return refInfo;
        }
    }

    private static final class URLContextFactoryServiceTracker
    extends ServiceTracker {
        private URLContextFactoryServiceTracker(BundleContext context, String clazz) {
            super(context, clazz, null);
        }

        public Object addingService(ServiceReference serviceReference) {
            if (serviceReference.getProperty("osgi.jndi.url.scheme") != null) {
                return super.addingService(serviceReference);
            }
            return null;
        }
    }
}

