/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.group.interceptors;

import org.apache.catalina.tribes.ChannelException;
import org.apache.catalina.tribes.ChannelMessage;
import org.apache.catalina.tribes.Member;
import org.apache.catalina.tribes.UniqueId;
import org.apache.catalina.tribes.group.ChannelInterceptorBase;
import org.apache.catalina.tribes.group.InterceptorPayload;
import org.apache.catalina.tribes.transport.bio.util.FastQueue;
import org.apache.catalina.tribes.transport.bio.util.LinkObject;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class MessageDispatchInterceptor
extends ChannelInterceptorBase
implements Runnable {
    private static final Log log = LogFactory.getLog(MessageDispatchInterceptor.class);
    protected long maxQueueSize = 0x4000000L;
    protected FastQueue queue = new FastQueue();
    protected volatile boolean run = false;
    protected Thread msgDispatchThread = null;
    protected long currentSize = 0L;
    protected boolean useDeepClone = true;
    protected boolean alwaysSend = true;

    public MessageDispatchInterceptor() {
        this.setOptionFlag(8);
    }

    @Override
    public void sendMessage(Member[] destination, ChannelMessage msg, InterceptorPayload payload) throws ChannelException {
        boolean async;
        boolean bl = async = (msg.getOptions() & 8) == 8;
        if (async && this.run) {
            if (this.getCurrentSize() + (long)msg.getMessage().getLength() > this.maxQueueSize) {
                if (this.alwaysSend) {
                    super.sendMessage(destination, msg, payload);
                    return;
                }
                throw new ChannelException("Asynchronous queue is full, reached its limit of " + this.maxQueueSize + " bytes, current:" + this.getCurrentSize() + " bytes.");
            }
            if (this.useDeepClone) {
                msg = (ChannelMessage)msg.deepclone();
            }
            if (!this.addToQueue(msg, destination, payload)) {
                throw new ChannelException("Unable to add the message to the async queue, queue bug?");
            }
            this.addAndGetCurrentSize(msg.getMessage().getLength());
        } else {
            super.sendMessage(destination, msg, payload);
        }
    }

    public boolean addToQueue(ChannelMessage msg, Member[] destination, InterceptorPayload payload) {
        return this.queue.add(msg, destination, payload);
    }

    public LinkObject removeFromQueue() {
        return this.queue.remove();
    }

    public void startQueue() {
        this.msgDispatchThread = new Thread(this);
        this.msgDispatchThread.setName("MessageDispatchInterceptor.MessageDispatchThread");
        this.msgDispatchThread.setDaemon(true);
        this.msgDispatchThread.setPriority(10);
        this.queue.setEnabled(true);
        this.run = true;
        this.msgDispatchThread.start();
    }

    public void stopQueue() {
        this.run = false;
        this.msgDispatchThread.interrupt();
        this.queue.setEnabled(false);
        this.setAndGetCurrentSize(0L);
    }

    @Override
    public void setOptionFlag(int flag) {
        if (flag != 8) {
            log.warn((Object)"Warning, you are overriding the asynchronous option flag, this will disable the Channel.SEND_OPTIONS_ASYNCHRONOUS that other apps might use.");
        }
        super.setOptionFlag(flag);
    }

    public void setMaxQueueSize(long maxQueueSize) {
        this.maxQueueSize = maxQueueSize;
    }

    public void setUseDeepClone(boolean useDeepClone) {
        this.useDeepClone = useDeepClone;
    }

    public long getMaxQueueSize() {
        return this.maxQueueSize;
    }

    public boolean getUseDeepClone() {
        return this.useDeepClone;
    }

    public long getCurrentSize() {
        return this.currentSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long addAndGetCurrentSize(long inc) {
        MessageDispatchInterceptor messageDispatchInterceptor = this;
        synchronized (messageDispatchInterceptor) {
            this.currentSize += inc;
            return this.currentSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long setAndGetCurrentSize(long value) {
        MessageDispatchInterceptor messageDispatchInterceptor = this;
        synchronized (messageDispatchInterceptor) {
            this.currentSize = value;
            return value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(int svc) throws ChannelException {
        if (!this.run) {
            MessageDispatchInterceptor messageDispatchInterceptor = this;
            synchronized (messageDispatchInterceptor) {
                if (!this.run && (svc & 2) == 2) {
                    this.startQueue();
                }
            }
        }
        super.start(svc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop(int svc) throws ChannelException {
        if (this.run) {
            MessageDispatchInterceptor messageDispatchInterceptor = this;
            synchronized (messageDispatchInterceptor) {
                if (this.run && (svc & 2) == 2) {
                    this.stopQueue();
                }
            }
        }
        super.stop(svc);
    }

    @Override
    public void run() {
        while (this.run) {
            LinkObject link = this.removeFromQueue();
            if (link == null) continue;
            while (link != null && this.run) {
                link = this.sendAsyncData(link);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LinkObject sendAsyncData(LinkObject link) {
        ChannelMessage msg = link.data();
        Member[] destination = link.getDestination();
        try {
            super.sendMessage(destination, msg, null);
            try {
                if (link.getHandler() != null) {
                    link.getHandler().handleCompletion(new UniqueId(msg.getUniqueId()));
                }
            }
            catch (Exception ex) {
                log.error((Object)"Unable to report back completed message.", (Throwable)ex);
            }
        }
        catch (Exception x) {
            ChannelException cx = null;
            cx = x instanceof ChannelException ? (ChannelException)x : new ChannelException(x);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Error while processing async message.", (Throwable)x);
            }
            try {
                if (link.getHandler() != null) {
                    link.getHandler().handleError(cx, new UniqueId(msg.getUniqueId()));
                }
            }
            catch (Exception ex) {
                log.error((Object)"Unable to report back error message.", (Throwable)ex);
            }
        }
        finally {
            this.addAndGetCurrentSize(-msg.getMessage().getLength());
            link = link.next();
        }
        return link;
    }

    public boolean isAlwaysSend() {
        return this.alwaysSend;
    }

    public void setAlwaysSend(boolean alwaysSend) {
        this.alwaysSend = alwaysSend;
    }
}

