/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.web.tomcat.internal.loader;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.apache.catalina.Context;
import org.apache.catalina.Loader;
import org.apache.catalina.util.LifecycleMBeanBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class BaseWebappLoader
extends LifecycleMBeanBase
implements Loader,
PropertyChangeListener {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final PropertyChangeSupport support = new PropertyChangeSupport(this);
    private boolean delegate = false;
    private Context context = null;
    private boolean reloadable = false;

    BaseWebappLoader() {
    }

    protected String getCatalinaContextPath(Context context) {
        String contextName = context.getName();
        if (!contextName.startsWith("/")) {
            contextName = "/";
        }
        return contextName;
    }

    protected String getObjectNameKeyProperties() {
        StringBuilder name = new StringBuilder("type=Loader");
        name.append(",host=");
        name.append(this.context.getParent().getName());
        name.append(",context=");
        name.append(this.getCatalinaContextPath(this.context));
        return name.toString();
    }

    protected String getDomainInternal() {
        return this.context.getDomain();
    }

    public void backgroundProcess() {
        if (this.reloadable && this.modified()) {
            try {
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                if (this.context != null) {
                    this.context.reload();
                }
            }
            finally {
                if (this.context != null && this.context.getLoader() != null) {
                    Thread.currentThread().setContextClassLoader(this.context.getLoader().getClassLoader());
                }
            }
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void setContext(Context context) {
        if (this.context == context) {
            return;
        }
        if (this.getState().isAvailable()) {
            throw new IllegalStateException("Setting the Context is not permitted while the loader is started.");
        }
        if (this.context != null) {
            this.context.removePropertyChangeListener((PropertyChangeListener)this);
        }
        Context oldContext = this.context;
        this.context = context;
        this.support.firePropertyChange("context", oldContext, this.context);
        if (this.context != null) {
            this.setReloadable(this.context.getReloadable());
            this.context.addPropertyChangeListener((PropertyChangeListener)this);
        }
    }

    public final Context getContext() {
        return this.context;
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    public boolean getReloadable() {
        return this.reloadable;
    }

    public void setReloadable(boolean reloadable) {
        boolean oldReloadable = this.reloadable;
        this.reloadable = reloadable;
        this.support.firePropertyChange("reloadable", (Object)oldReloadable, (Object)this.reloadable);
    }

    public boolean getDelegate() {
        return this.delegate;
    }

    public void setDelegate(boolean delegate) {
        boolean oldDelegate = this.delegate;
        this.delegate = delegate;
        this.support.firePropertyChange("delegate", (Object)oldDelegate, (Object)this.delegate);
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (!(event.getSource() instanceof Context)) {
            return;
        }
        if (event.getPropertyName().equals("reloadable")) {
            try {
                this.setReloadable((Boolean)event.getNewValue());
            }
            catch (Exception exception) {
                this.log.error("Cannot set reloadable property to [" + event.getNewValue().toString() + "].");
            }
        }
    }
}

