/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote;

import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistration;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.servlet.http.HttpUpgradeHandler;
import javax.servlet.http.WebConnection;
import org.apache.coyote.AbstractProcessor;
import org.apache.coyote.Adapter;
import org.apache.coyote.ContainerThreadMarker;
import org.apache.coyote.Processor;
import org.apache.coyote.ProtocolHandler;
import org.apache.coyote.Request;
import org.apache.coyote.RequestGroupInfo;
import org.apache.coyote.RequestInfo;
import org.apache.juli.logging.Log;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.collections.SynchronizedStack;
import org.apache.tomcat.util.modeler.Registry;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.DispatchType;
import org.apache.tomcat.util.net.SocketStatus;
import org.apache.tomcat.util.net.SocketWrapper;
import org.apache.tomcat.util.res.StringManager;

public abstract class AbstractProtocol<S>
implements ProtocolHandler,
MBeanRegistration {
    protected static final StringManager sm = StringManager.getManager((String)"org.apache.coyote");
    private static final AtomicInteger nameCounter = new AtomicInteger(0);
    protected ObjectName rgOname = null;
    protected ObjectName tpOname = null;
    private int nameIndex = 0;
    protected AbstractEndpoint<S> endpoint = null;
    protected Adapter adapter;
    protected int processorCache = 200;
    protected String clientCertProvider = null;
    protected String domain;
    protected ObjectName oname;
    protected MBeanServer mserver;

    public boolean setProperty(String name, String value) {
        return this.endpoint.setProperty(name, value);
    }

    public String getProperty(String name) {
        return this.endpoint.getProperty(name);
    }

    @Override
    public void setAdapter(Adapter adapter) {
        this.adapter = adapter;
    }

    @Override
    public Adapter getAdapter() {
        return this.adapter;
    }

    public int getProcessorCache() {
        return this.processorCache;
    }

    public void setProcessorCache(int processorCache) {
        this.processorCache = processorCache;
    }

    public String getClientCertProvider() {
        return this.clientCertProvider;
    }

    public void setClientCertProvider(String s) {
        this.clientCertProvider = s;
    }

    @Override
    public boolean isAprRequired() {
        return false;
    }

    @Override
    public boolean isCometSupported() {
        return this.endpoint.getUseComet();
    }

    @Override
    public boolean isCometTimeoutSupported() {
        return this.endpoint.getUseCometTimeout();
    }

    @Override
    public boolean isSendfileSupported() {
        return this.endpoint.getUseSendfile();
    }

    @Override
    public Executor getExecutor() {
        return this.endpoint.getExecutor();
    }

    public void setExecutor(Executor executor) {
        this.endpoint.setExecutor(executor);
    }

    public int getMaxThreads() {
        return this.endpoint.getMaxThreads();
    }

    public void setMaxThreads(int maxThreads) {
        this.endpoint.setMaxThreads(maxThreads);
    }

    public int getMaxConnections() {
        return this.endpoint.getMaxConnections();
    }

    public void setMaxConnections(int maxConnections) {
        this.endpoint.setMaxConnections(maxConnections);
    }

    public int getMinSpareThreads() {
        return this.endpoint.getMinSpareThreads();
    }

    public void setMinSpareThreads(int minSpareThreads) {
        this.endpoint.setMinSpareThreads(minSpareThreads);
    }

    public int getThreadPriority() {
        return this.endpoint.getThreadPriority();
    }

    public void setThreadPriority(int threadPriority) {
        this.endpoint.setThreadPriority(threadPriority);
    }

    public int getBacklog() {
        return this.endpoint.getBacklog();
    }

    public void setBacklog(int backlog) {
        this.endpoint.setBacklog(backlog);
    }

    public boolean getTcpNoDelay() {
        return this.endpoint.getTcpNoDelay();
    }

    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.endpoint.setTcpNoDelay(tcpNoDelay);
    }

    public int getSoLinger() {
        return this.endpoint.getSoLinger();
    }

    public void setSoLinger(int soLinger) {
        this.endpoint.setSoLinger(soLinger);
    }

    public int getKeepAliveTimeout() {
        return this.endpoint.getKeepAliveTimeout();
    }

    public void setKeepAliveTimeout(int keepAliveTimeout) {
        this.endpoint.setKeepAliveTimeout(keepAliveTimeout);
    }

    public InetAddress getAddress() {
        return this.endpoint.getAddress();
    }

    public void setAddress(InetAddress ia) {
        this.endpoint.setAddress(ia);
    }

    public int getPort() {
        return this.endpoint.getPort();
    }

    public void setPort(int port) {
        this.endpoint.setPort(port);
    }

    public int getLocalPort() {
        return this.endpoint.getLocalPort();
    }

    public int getConnectionTimeout() {
        return this.endpoint.getSoTimeout();
    }

    public void setConnectionTimeout(int timeout) {
        this.endpoint.setSoTimeout(timeout);
    }

    public int getSoTimeout() {
        return this.getConnectionTimeout();
    }

    public void setSoTimeout(int timeout) {
        this.setConnectionTimeout(timeout);
    }

    public int getMaxHeaderCount() {
        return this.endpoint.getMaxHeaderCount();
    }

    public void setMaxHeaderCount(int maxHeaderCount) {
        this.endpoint.setMaxHeaderCount(maxHeaderCount);
    }

    public long getConnectionCount() {
        return this.endpoint.getConnectionCount();
    }

    public synchronized int getNameIndex() {
        if (this.nameIndex == 0) {
            this.nameIndex = nameCounter.incrementAndGet();
        }
        return this.nameIndex;
    }

    public String getName() {
        int port;
        StringBuilder name = new StringBuilder(this.getNamePrefix());
        name.append('-');
        if (this.getAddress() != null) {
            name.append(this.getAddress().getHostAddress());
            name.append('-');
        }
        if ((port = this.getPort()) == 0) {
            name.append("auto-");
            name.append(this.getNameIndex());
            port = this.getLocalPort();
            if (port != -1) {
                name.append('-');
                name.append(port);
            }
        } else {
            name.append(port);
        }
        return ObjectName.quote(name.toString());
    }

    protected abstract Log getLog();

    protected abstract String getNamePrefix();

    protected abstract String getProtocolName();

    protected abstract AbstractEndpoint.Handler getHandler();

    public ObjectName getObjectName() {
        return this.oname;
    }

    public String getDomain() {
        return this.domain;
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.oname = name;
        this.mserver = server;
        this.domain = name.getDomain();
        return name;
    }

    @Override
    public void postRegister(Boolean registrationDone) {
    }

    @Override
    public void preDeregister() throws Exception {
    }

    @Override
    public void postDeregister() {
    }

    private ObjectName createObjectName() throws MalformedObjectNameException {
        this.domain = this.getAdapter().getDomain();
        if (this.domain == null) {
            return null;
        }
        StringBuilder name = new StringBuilder(this.getDomain());
        name.append(":type=ProtocolHandler,port=");
        int port = this.getPort();
        if (port > 0) {
            name.append(this.getPort());
        } else {
            name.append("auto-");
            name.append(this.getNameIndex());
        }
        InetAddress address = this.getAddress();
        if (address != null) {
            name.append(",address=");
            name.append(ObjectName.quote(address.getHostAddress()));
        }
        return new ObjectName(name.toString());
    }

    @Override
    public void init() throws Exception {
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((Object)sm.getString("abstractProtocolHandler.init", new Object[]{this.getName()}));
        }
        if (this.oname == null) {
            this.oname = this.createObjectName();
            if (this.oname != null) {
                Registry.getRegistry(null, null).registerComponent((Object)this, this.oname, null);
            }
        }
        if (this.domain != null) {
            try {
                this.tpOname = new ObjectName(this.domain + ":" + "type=ThreadPool,name=" + this.getName());
                Registry.getRegistry(null, null).registerComponent(this.endpoint, this.tpOname, null);
            }
            catch (Exception e) {
                this.getLog().error((Object)sm.getString("abstractProtocolHandler.mbeanRegistrationFailed", new Object[]{this.tpOname, this.getName()}), (Throwable)e);
            }
            this.rgOname = new ObjectName(this.domain + ":type=GlobalRequestProcessor,name=" + this.getName());
            Registry.getRegistry(null, null).registerComponent(this.getHandler().getGlobal(), this.rgOname, null);
        }
        String endpointName = this.getName();
        this.endpoint.setName(endpointName.substring(1, endpointName.length() - 1));
        try {
            this.endpoint.init();
        }
        catch (Exception ex) {
            this.getLog().error((Object)sm.getString("abstractProtocolHandler.initError", new Object[]{this.getName()}), (Throwable)ex);
            throw ex;
        }
    }

    @Override
    public void start() throws Exception {
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((Object)sm.getString("abstractProtocolHandler.start", new Object[]{this.getName()}));
        }
        try {
            this.endpoint.start();
        }
        catch (Exception ex) {
            this.getLog().error((Object)sm.getString("abstractProtocolHandler.startError", new Object[]{this.getName()}), (Throwable)ex);
            throw ex;
        }
    }

    @Override
    public void pause() throws Exception {
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((Object)sm.getString("abstractProtocolHandler.pause", new Object[]{this.getName()}));
        }
        try {
            this.endpoint.pause();
        }
        catch (Exception ex) {
            this.getLog().error((Object)sm.getString("abstractProtocolHandler.pauseError", new Object[]{this.getName()}), (Throwable)ex);
            throw ex;
        }
    }

    @Override
    public void resume() throws Exception {
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((Object)sm.getString("abstractProtocolHandler.resume", new Object[]{this.getName()}));
        }
        try {
            this.endpoint.resume();
        }
        catch (Exception ex) {
            this.getLog().error((Object)sm.getString("abstractProtocolHandler.resumeError", new Object[]{this.getName()}), (Throwable)ex);
            throw ex;
        }
    }

    @Override
    public void stop() throws Exception {
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((Object)sm.getString("abstractProtocolHandler.stop", new Object[]{this.getName()}));
        }
        try {
            this.endpoint.stop();
        }
        catch (Exception ex) {
            this.getLog().error((Object)sm.getString("abstractProtocolHandler.stopError", new Object[]{this.getName()}), (Throwable)ex);
            throw ex;
        }
    }

    @Override
    public void destroy() {
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((Object)sm.getString("abstractProtocolHandler.destroy", new Object[]{this.getName()}));
        }
        try {
            this.endpoint.destroy();
        }
        catch (Exception e) {
            this.getLog().error((Object)sm.getString("abstractProtocolHandler.destroyError", new Object[]{this.getName()}), (Throwable)e);
        }
        if (this.oname != null) {
            if (this.mserver == null) {
                Registry.getRegistry(null, null).unregisterComponent(this.oname);
            } else {
                try {
                    this.mserver.unregisterMBean(this.oname);
                }
                catch (InstanceNotFoundException | MBeanRegistrationException e) {
                    this.getLog().info((Object)sm.getString("abstractProtocol.mbeanDeregistrationFailed", new Object[]{this.oname, this.mserver}));
                }
            }
        }
        if (this.tpOname != null) {
            Registry.getRegistry(null, null).unregisterComponent(this.tpOname);
        }
        if (this.rgOname != null) {
            Registry.getRegistry(null, null).unregisterComponent(this.rgOname);
        }
    }

    protected static class RecycledProcessors<P extends Processor<S>, S>
    extends SynchronizedStack<Processor<S>> {
        private final transient AbstractConnectionHandler<S, P> handler;
        protected final AtomicInteger size = new AtomicInteger(0);

        public RecycledProcessors(AbstractConnectionHandler<S, P> handler) {
            this.handler = handler;
        }

        @Override
        public boolean push(Processor<S> processor) {
            int cacheSize = this.handler.getProtocol().getProcessorCache();
            boolean offer = cacheSize == -1 ? true : this.size.get() < cacheSize;
            boolean result = false;
            if (offer && (result = super.push(processor))) {
                this.size.incrementAndGet();
            }
            if (!result) {
                this.handler.unregister(processor);
            }
            return result;
        }

        @Override
        public Processor<S> pop() {
            Processor result = (Processor)super.pop();
            if (result != null) {
                this.size.decrementAndGet();
            }
            return result;
        }

        @Override
        public synchronized void clear() {
            Object next = this.pop();
            while (next != null) {
                this.handler.unregister((Processor<S>)next);
                next = this.pop();
            }
            super.clear();
            this.size.set(0);
        }
    }

    protected static abstract class AbstractConnectionHandler<S, P extends Processor<S>>
    implements AbstractEndpoint.Handler {
        protected final RequestGroupInfo global = new RequestGroupInfo();
        protected final AtomicLong registerCount = new AtomicLong(0L);
        protected final ConcurrentHashMap<S, Processor<S>> connections = new ConcurrentHashMap();
        protected final RecycledProcessors<P, S> recycledProcessors = new RecycledProcessors(this);

        protected AbstractConnectionHandler() {
        }

        protected abstract Log getLog();

        protected abstract AbstractProtocol<S> getProtocol();

        @Override
        public Object getGlobal() {
            return this.global;
        }

        @Override
        public void recycle() {
            this.recycledProcessors.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AbstractEndpoint.Handler.SocketState process(SocketWrapper<S> wrapper, SocketStatus status) {
            if (wrapper == null) {
                return AbstractEndpoint.Handler.SocketState.CLOSED;
            }
            S socket = wrapper.getSocket();
            if (socket == null) {
                return AbstractEndpoint.Handler.SocketState.CLOSED;
            }
            Processor<S> processor = this.connections.get(socket);
            if (status == SocketStatus.DISCONNECT && processor == null) {
                return AbstractEndpoint.Handler.SocketState.CLOSED;
            }
            wrapper.setAsync(false);
            ContainerThreadMarker.set();
            try {
                if (processor == null) {
                    processor = this.recycledProcessors.pop();
                }
                if (processor == null) {
                    processor = this.createProcessor();
                }
                this.initSsl(wrapper, processor);
                AbstractEndpoint.Handler.SocketState state = AbstractEndpoint.Handler.SocketState.CLOSED;
                Iterator<DispatchType> dispatches = null;
                do {
                    if (status == SocketStatus.CLOSE_NOW) {
                        processor.errorDispatch();
                        state = AbstractEndpoint.Handler.SocketState.CLOSED;
                    } else if (dispatches != null) {
                        this.connections.put(socket, processor);
                        DispatchType nextDispatch = (DispatchType)((Object)dispatches.next());
                        state = processor.isUpgrade() ? processor.upgradeDispatch(nextDispatch.getSocketStatus()) : processor.asyncDispatch(nextDispatch.getSocketStatus());
                    } else if (status != SocketStatus.DISCONNECT || processor.isComet()) {
                        if (processor.isAsync()) {
                            state = processor.asyncDispatch(status);
                        } else if (state == AbstractEndpoint.Handler.SocketState.ASYNC_END) {
                            state = processor.asyncDispatch(status);
                            if (state == AbstractEndpoint.Handler.SocketState.OPEN) {
                                state = processor.process(wrapper);
                            }
                        } else {
                            state = processor.isComet() ? processor.event(status) : (processor.isUpgrade() ? processor.upgradeDispatch(status) : (status == SocketStatus.OPEN_WRITE ? AbstractEndpoint.Handler.SocketState.LONG : processor.process(wrapper)));
                        }
                    }
                    if (state != AbstractEndpoint.Handler.SocketState.CLOSED && processor.isAsync()) {
                        state = processor.asyncPostProcess();
                    }
                    if (state == AbstractEndpoint.Handler.SocketState.UPGRADING) {
                        HttpUpgradeHandler httpUpgradeHandler = processor.getHttpUpgradeHandler();
                        ByteBuffer leftoverInput = processor.getLeftoverInput();
                        this.release(wrapper, processor, false, false);
                        processor = this.createUpgradeProcessor(wrapper, leftoverInput, httpUpgradeHandler);
                        wrapper.setUpgraded(true);
                        this.connections.put(socket, processor);
                        httpUpgradeHandler.init((WebConnection)processor);
                    }
                    if (this.getLog().isDebugEnabled()) {
                        this.getLog().debug((Object)("Socket: [" + wrapper + "], Status in: [" + (Object)((Object)status) + "], State out: [" + (Object)((Object)state) + "]"));
                    }
                    if (dispatches != null && dispatches.hasNext()) continue;
                    dispatches = wrapper.getIteratorAndClearDispatches();
                } while (state == AbstractEndpoint.Handler.SocketState.ASYNC_END || state == AbstractEndpoint.Handler.SocketState.UPGRADING || dispatches != null && state != AbstractEndpoint.Handler.SocketState.CLOSED);
                if (state == AbstractEndpoint.Handler.SocketState.LONG) {
                    this.connections.put(socket, processor);
                    this.longPoll(wrapper, processor);
                } else if (state == AbstractEndpoint.Handler.SocketState.OPEN) {
                    this.connections.remove(socket);
                    this.release(wrapper, processor, false, true);
                } else if (state == AbstractEndpoint.Handler.SocketState.SENDFILE) {
                    this.connections.remove(socket);
                    this.release(wrapper, processor, false, false);
                } else if (state == AbstractEndpoint.Handler.SocketState.UPGRADED) {
                    if (status != SocketStatus.OPEN_WRITE) {
                        this.longPoll(wrapper, processor);
                    }
                } else {
                    this.connections.remove(socket);
                    if (processor.isUpgrade()) {
                        processor.getHttpUpgradeHandler().destroy();
                    } else {
                        this.release(wrapper, processor, true, false);
                    }
                }
                AbstractEndpoint.Handler.SocketState socketState = state;
                return socketState;
            }
            catch (SocketException e) {
                this.getLog().debug((Object)sm.getString("abstractConnectionHandler.socketexception.debug"), (Throwable)e);
            }
            catch (IOException e) {
                this.getLog().debug((Object)sm.getString("abstractConnectionHandler.ioexception.debug"), (Throwable)e);
            }
            catch (Throwable e) {
                ExceptionUtils.handleThrowable((Throwable)e);
                this.getLog().error((Object)sm.getString("abstractConnectionHandler.error"), e);
            }
            finally {
                ContainerThreadMarker.clear();
            }
            this.connections.remove(socket);
            if (processor != null && !processor.isUpgrade()) {
                this.release(wrapper, processor, true, false);
            }
            return AbstractEndpoint.Handler.SocketState.CLOSED;
        }

        protected abstract P createProcessor();

        protected abstract void initSsl(SocketWrapper<S> var1, Processor<S> var2);

        protected abstract void longPoll(SocketWrapper<S> var1, Processor<S> var2);

        protected abstract void release(SocketWrapper<S> var1, Processor<S> var2, boolean var3, boolean var4);

        protected abstract Processor<S> createUpgradeProcessor(SocketWrapper<S> var1, ByteBuffer var2, HttpUpgradeHandler var3) throws IOException;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void register(AbstractProcessor<S> processor) {
            if (this.getProtocol().getDomain() != null) {
                AbstractConnectionHandler abstractConnectionHandler = this;
                synchronized (abstractConnectionHandler) {
                    try {
                        long count = this.registerCount.incrementAndGet();
                        RequestInfo rp = processor.getRequest().getRequestProcessor();
                        rp.setGlobalProcessor(this.global);
                        ObjectName rpName = new ObjectName(this.getProtocol().getDomain() + ":type=RequestProcessor,worker=" + this.getProtocol().getName() + ",name=" + this.getProtocol().getProtocolName() + "Request" + count);
                        if (this.getLog().isDebugEnabled()) {
                            this.getLog().debug((Object)("Register " + rpName));
                        }
                        Registry.getRegistry(null, null).registerComponent((Object)rp, rpName, null);
                        rp.setRpName(rpName);
                    }
                    catch (Exception e) {
                        this.getLog().warn((Object)"Error registering request");
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void unregister(Processor<S> processor) {
            if (this.getProtocol().getDomain() != null) {
                AbstractConnectionHandler abstractConnectionHandler = this;
                synchronized (abstractConnectionHandler) {
                    try {
                        Request r = processor.getRequest();
                        if (r == null) {
                            return;
                        }
                        RequestInfo rp = r.getRequestProcessor();
                        rp.setGlobalProcessor(null);
                        ObjectName rpName = rp.getRpName();
                        if (this.getLog().isDebugEnabled()) {
                            this.getLog().debug((Object)("Unregister " + rpName));
                        }
                        Registry.getRegistry(null, null).unregisterComponent(rpName);
                        rp.setRpName(null);
                    }
                    catch (Exception e) {
                        this.getLog().warn((Object)"Error unregistering request", (Throwable)e);
                    }
                }
            }
        }
    }
}

