/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.ajp;

import java.io.IOException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.coyote.ajp.AbstractAjpProcessor;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.jni.Socket;
import org.apache.tomcat.jni.Status;
import org.apache.tomcat.util.net.AprEndpoint;
import org.apache.tomcat.util.net.SocketWrapper;

public class AjpAprProcessor
extends AbstractAjpProcessor<Long> {
    private static final Log log = LogFactory.getLog(AjpAprProcessor.class);
    protected final ByteBuffer inputBuffer;
    protected final ByteBuffer outputBuffer;

    @Override
    protected Log getLog() {
        return log;
    }

    public AjpAprProcessor(int packetSize, AprEndpoint endpoint) {
        super(packetSize, endpoint);
        this.response.setOutputBuffer(new AbstractAjpProcessor.SocketOutputBuffer());
        this.inputBuffer = ByteBuffer.allocateDirect(packetSize * 2);
        this.inputBuffer.limit(0);
        this.outputBuffer = ByteBuffer.allocateDirect(packetSize * 2);
    }

    @Override
    protected void registerForEvent(boolean read, boolean write) {
        this.socketWrapper.registerforEvent(-1, read, write);
    }

    @Override
    protected void resetTimeouts() {
    }

    @Override
    protected void setupSocket(SocketWrapper<Long> socketWrapper) {
        long socketRef = socketWrapper.getSocket();
        Socket.setrbb((long)socketRef, (ByteBuffer)this.inputBuffer);
        Socket.setsbb((long)socketRef, (ByteBuffer)this.outputBuffer);
    }

    @Override
    protected void setTimeout(SocketWrapper<Long> socketWrapper, int timeout) throws IOException {
        Socket.timeoutSet((long)socketWrapper.getSocket(), (long)(timeout * 1000));
    }

    @Override
    protected int output(byte[] src, int offset, int length, boolean block) throws IOException {
        if (length == 0) {
            return 0;
        }
        this.outputBuffer.put(src, offset, length);
        int result = -1;
        if ((Long)this.socketWrapper.getSocket() != 0L) {
            result = this.writeSocket(0, this.outputBuffer.position(), block);
            if (Status.APR_STATUS_IS_EAGAIN((int)(-result))) {
                result = 0;
            }
            if (result < 0) {
                this.outputBuffer.clear();
                throw new IOException(sm.getString("ajpprocessor.failedsend"));
            }
        }
        this.outputBuffer.clear();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int writeSocket(int pos, int len, boolean block) {
        Lock readLock = this.socketWrapper.getBlockingStatusReadLock();
        ReentrantReadWriteLock.WriteLock writeLock = this.socketWrapper.getBlockingStatusWriteLock();
        long socket = (Long)this.socketWrapper.getSocket();
        boolean writeDone = false;
        int result = 0;
        readLock.lock();
        try {
            if (this.socketWrapper.getBlockingStatus() == block) {
                result = Socket.sendbb((long)socket, (int)pos, (int)len);
                writeDone = true;
            }
        }
        finally {
            readLock.unlock();
        }
        if (!writeDone) {
            writeLock.lock();
            try {
                this.socketWrapper.setBlockingStatus(block);
                Socket.optSet((long)socket, (int)8, (int)(block ? 0 : 1));
                readLock.lock();
                try {
                    writeLock.unlock();
                    result = Socket.sendbb((long)socket, (int)pos, (int)len);
                }
                finally {
                    readLock.unlock();
                }
            }
            finally {
                if (writeLock.isHeldByCurrentThread()) {
                    writeLock.unlock();
                }
            }
        }
        return result;
    }

    @Override
    protected boolean read(byte[] buf, int pos, int n, boolean block) throws IOException {
        boolean nextReadBlocks = block;
        if (!block && this.inputBuffer.remaining() > 0) {
            nextReadBlocks = true;
        }
        if (this.inputBuffer.capacity() - this.inputBuffer.limit() <= n - this.inputBuffer.remaining()) {
            this.inputBuffer.compact();
            this.inputBuffer.limit(this.inputBuffer.position());
            this.inputBuffer.position(0);
        }
        while (this.inputBuffer.remaining() < n) {
            int nRead = this.readSocket(this.inputBuffer.limit(), this.inputBuffer.capacity() - this.inputBuffer.limit(), nextReadBlocks);
            if (nRead == 0) {
                return false;
            }
            if (-nRead == 120002) {
                return false;
            }
            if (-nRead == 120005 || -nRead == 120001) {
                if (block) {
                    throw new SocketTimeoutException(sm.getString("ajpprocessor.readtimeout"));
                }
                return false;
            }
            if (nRead > 0) {
                this.inputBuffer.limit(this.inputBuffer.limit() + nRead);
                nextReadBlocks = true;
                continue;
            }
            throw new IOException(sm.getString("ajpprocessor.failedread"));
        }
        this.inputBuffer.get(buf, pos, n);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readSocket(int pos, int len, boolean block) {
        Lock readLock = this.socketWrapper.getBlockingStatusReadLock();
        ReentrantReadWriteLock.WriteLock writeLock = this.socketWrapper.getBlockingStatusWriteLock();
        long socket = (Long)this.socketWrapper.getSocket();
        boolean readDone = false;
        int result = 0;
        readLock.lock();
        try {
            if (this.socketWrapper.getBlockingStatus() == block) {
                result = Socket.recvbb((long)socket, (int)pos, (int)len);
                readDone = true;
            }
        }
        finally {
            readLock.unlock();
        }
        if (!readDone) {
            writeLock.lock();
            try {
                this.socketWrapper.setBlockingStatus(block);
                Socket.optSet((long)socket, (int)8, (int)(block ? 0 : 1));
                readLock.lock();
                try {
                    writeLock.unlock();
                    result = Socket.recvbb((long)socket, (int)pos, (int)len);
                }
                finally {
                    readLock.unlock();
                }
            }
            finally {
                if (writeLock.isHeldByCurrentThread()) {
                    writeLock.unlock();
                }
            }
        }
        return result;
    }

    @Override
    public void recycle(boolean socketClosing) {
        super.recycle(socketClosing);
        this.inputBuffer.clear();
        this.inputBuffer.limit(0);
        this.outputBuffer.clear();
    }
}

