/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.ajp;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import org.apache.coyote.ajp.AbstractAjpProcessor;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.net.NioChannel;
import org.apache.tomcat.util.net.NioEndpoint;
import org.apache.tomcat.util.net.NioSelectorPool;
import org.apache.tomcat.util.net.SocketWrapper;

public class AjpNioProcessor
extends AbstractAjpProcessor<NioChannel> {
    private static final Log log = LogFactory.getLog(AjpNioProcessor.class);
    protected final NioSelectorPool pool;

    @Override
    protected Log getLog() {
        return log;
    }

    public AjpNioProcessor(int packetSize, NioEndpoint endpoint) {
        super(packetSize, endpoint);
        this.response.setOutputBuffer(new AbstractAjpProcessor.SocketOutputBuffer());
        this.pool = endpoint.getSelectorPool();
    }

    @Override
    protected void registerForEvent(boolean read, boolean write) {
        NioChannel socket = (NioChannel)this.socketWrapper.getSocket();
        NioEndpoint.KeyAttachment attach = (NioEndpoint.KeyAttachment)socket.getAttachment();
        if (attach == null) {
            return;
        }
        SelectionKey key = socket.getIOChannel().keyFor(socket.getPoller().getSelector());
        if (read) {
            attach.interestOps(attach.interestOps() | 1);
            key.interestOps(key.interestOps() | 1);
        }
        if (write) {
            attach.interestOps(attach.interestOps() | 4);
            key.interestOps(key.interestOps() | 1);
        }
    }

    @Override
    protected void resetTimeouts() {
        NioEndpoint.KeyAttachment attach = (NioEndpoint.KeyAttachment)((NioChannel)this.socketWrapper.getSocket()).getAttachment();
        if (!this.getErrorState().isError() && attach != null && this.asyncStateMachine.isAsyncDispatching()) {
            long soTimeout = this.endpoint.getSoTimeout();
            if (this.keepAliveTimeout > 0) {
                attach.setTimeout(this.keepAliveTimeout);
            } else {
                attach.setTimeout(soTimeout);
            }
        }
    }

    @Override
    protected void setupSocket(SocketWrapper<NioChannel> socketWrapper) throws IOException {
    }

    @Override
    protected void setTimeout(SocketWrapper<NioChannel> socketWrapper, int timeout) throws IOException {
        socketWrapper.setTimeout(timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int output(byte[] src, int offset, int length, boolean block) throws IOException {
        NioEndpoint.KeyAttachment att = (NioEndpoint.KeyAttachment)((NioChannel)this.socketWrapper.getSocket()).getAttachment();
        if (att == null) {
            throw new IOException("Key must be cancelled");
        }
        ByteBuffer writeBuffer = ((NioChannel)this.socketWrapper.getSocket()).getBufHandler().getWriteBuffer();
        int toWrite = Math.min(length, writeBuffer.remaining());
        writeBuffer.put(src, offset, toWrite);
        writeBuffer.flip();
        long writeTimeout = att.getWriteTimeout();
        Selector selector = null;
        try {
            selector = this.pool.get();
        }
        catch (IOException x) {
            // empty catch block
        }
        try {
            int n = this.pool.write(writeBuffer, (NioChannel)this.socketWrapper.getSocket(), selector, writeTimeout, block);
            return n;
        }
        finally {
            writeBuffer.clear();
            if (selector != null) {
                this.pool.put(selector);
            }
        }
    }

    @Override
    protected boolean read(byte[] buf, int pos, int n, boolean blockFirstRead) throws IOException {
        int res = 0;
        boolean block = blockFirstRead;
        for (int read = 0; read < n; read += res) {
            res = this.readSocket(buf, read + pos, n - read, block);
            if (res > 0) {
            } else {
                if (res == 0 && !block) {
                    return false;
                }
                throw new IOException(sm.getString("ajpprocessor.failedread"));
            }
            block = true;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readSocket(byte[] buf, int pos, int n, boolean block) throws IOException {
        int nRead = 0;
        ByteBuffer readBuffer = ((NioChannel)this.socketWrapper.getSocket()).getBufHandler().getReadBuffer();
        readBuffer.clear();
        if (n < readBuffer.capacity()) {
            readBuffer.limit(n);
        }
        if (block) {
            Selector selector = null;
            try {
                selector = this.pool.get();
            }
            catch (IOException x) {
                // empty catch block
            }
            try {
                NioEndpoint.KeyAttachment att = (NioEndpoint.KeyAttachment)((NioChannel)this.socketWrapper.getSocket()).getAttachment();
                if (att == null) {
                    throw new IOException("Key must be cancelled.");
                }
                nRead = this.pool.read(readBuffer, (NioChannel)this.socketWrapper.getSocket(), selector, att.getTimeout());
            }
            catch (EOFException eof) {
                nRead = -1;
            }
            finally {
                if (selector != null) {
                    this.pool.put(selector);
                }
            }
        } else {
            nRead = ((NioChannel)this.socketWrapper.getSocket()).read(readBuffer);
        }
        if (nRead > 0) {
            readBuffer.flip();
            readBuffer.limit(nRead);
            readBuffer.get(buf, pos, nRead);
            return nRead;
        }
        if (nRead == -1) {
            throw new EOFException(sm.getString("iib.eof.error"));
        }
        return 0;
    }
}

