/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.business.internal.bracket.locators;

import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionLocator;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.sirius.diagram.ui.business.internal.bracket.BracketConnectionQuery;
import org.eclipse.sirius.diagram.ui.business.internal.bracket.Direction;

public class BracketConnectionDecoratorLocator
extends ConnectionLocator {
    public static final int DORIGIN = 5;
    public static final int DTARGET = 6;
    private BracketConnectionQuery bracketConnectionQuery;
    private Rectangle bracketSegmentBounds;
    private Direction generalDirection;

    public BracketConnectionDecoratorLocator(Connection connection, int align, BracketConnectionQuery bracketConnectionQuery) {
        super(connection, align);
        this.bracketConnectionQuery = bracketConnectionQuery;
    }

    public void relocate(IFigure target) {
        PointList points = this.getConnection().getPoints();
        RotatableDecoration arrow = (RotatableDecoration)target;
        Point location = this.getLocation(points);
        arrow.setLocation(location);
        Point inversedLocation = this.getInversedLocation(points, location, arrow);
        arrow.setReferencePoint(inversedLocation);
        Point center = arrow.getBounds().getCenter();
        if (this.bracketSegmentTooSmallForDecoration(arrow) && (this.bracketSegmentBounds.contains(center) || this.bracketSegmentBounds.isEmpty())) {
            inversedLocation = location.getTranslated(location.getDifference(inversedLocation).getExpanded(this.getExpansion()));
            arrow.setReferencePoint(inversedLocation);
        }
    }

    protected Point getLocation(PointList points) {
        Point location = null;
        switch (this.getAlignment()) {
            case 5: {
                if (points.size() > 2) {
                    location = points.getPoint(2);
                    break;
                }
                location = points.getFirstPoint();
                break;
            }
            case 6: {
                if (points.size() > 2) {
                    location = points.getPoint(3);
                    break;
                }
                location = points.getLastPoint();
                break;
            }
            default: {
                location = super.getLocation(points);
            }
        }
        return location.getCopy();
    }

    protected Point getInversedLocation(PointList points, Point location, RotatableDecoration arrow) {
        Point inversedLocation = null;
        switch (this.getAlignment()) {
            case 5: {
                if (points.size() > 2) {
                    inversedLocation = points.getPoint(3);
                    break;
                }
                inversedLocation = points.getLastPoint();
                break;
            }
            case 6: {
                if (points.size() > 2) {
                    inversedLocation = points.getPoint(2);
                    break;
                }
                inversedLocation = points.getFirstPoint();
                break;
            }
            default: {
                inversedLocation = super.getLocation(points);
            }
        }
        return inversedLocation.getCopy();
    }

    private boolean bracketSegmentTooSmallForDecoration(RotatableDecoration rotatableDecoration) {
        boolean bracketSegmentTooSmallForDecoration = false;
        Rectangle decorationBounds = rotatableDecoration.getBounds();
        this.bracketSegmentBounds = this.bracketConnectionQuery.getBracketSegmentBounds();
        this.generalDirection = this.bracketConnectionQuery.getGeneralDirection();
        int bracketSegmentLength = Math.max(this.bracketSegmentBounds.width, this.bracketSegmentBounds.height) - 1;
        switch (this.generalDirection) {
            case LEFT: 
            case RIGHT: {
                bracketSegmentTooSmallForDecoration = 3 * decorationBounds.height > bracketSegmentLength;
                this.bracketSegmentBounds.shrink(new Insets(1, 0, 1, 0));
                break;
            }
            case TOP: 
            case BOTTOM: {
                bracketSegmentTooSmallForDecoration = 3 * decorationBounds.width > bracketSegmentLength;
                this.bracketSegmentBounds.shrink(new Insets(0, 1, 0, 1));
            }
        }
        return bracketSegmentTooSmallForDecoration;
    }

    private Dimension getExpansion() {
        Dimension expansion = new Dimension(0, 0);
        int expansionValue = 2;
        if (this.getAlignment() == 6) {
            expansionValue *= -1;
        }
        switch (this.generalDirection) {
            case LEFT: 
            case RIGHT: {
                expansion.height = expansionValue;
                break;
            }
            case TOP: 
            case BOTTOM: {
                expansion.width = expansionValue;
                break;
            }
        }
        return expansion;
    }
}

