/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.dsl.debug.ide.adapter;

import java.util.ArrayList;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gemoc.dsl.debug.StackFrame;
import org.eclipse.gemoc.dsl.debug.State;
import org.eclipse.gemoc.dsl.debug.Thread;
import org.eclipse.gemoc.dsl.debug.ThreadUtils;
import org.eclipse.gemoc.dsl.debug.ide.DSLBreakpoint;
import org.eclipse.gemoc.dsl.debug.ide.DSLEclipseDebugIntegration;
import org.eclipse.gemoc.dsl.debug.ide.adapter.AbstractDSLDebugElementAdapter;
import org.eclipse.gemoc.dsl.debug.ide.adapter.DSLStackFrameAdapter;
import org.eclipse.gemoc.dsl.debug.ide.event.model.ResumeRequest;
import org.eclipse.gemoc.dsl.debug.ide.event.model.StepIntoRequest;
import org.eclipse.gemoc.dsl.debug.ide.event.model.StepOverRequest;
import org.eclipse.gemoc.dsl.debug.ide.event.model.StepReturnRequest;
import org.eclipse.gemoc.dsl.debug.ide.event.model.SuspendRequest;
import org.eclipse.gemoc.dsl.debug.ide.event.model.TerminateRequest;

public class DSLThreadAdapter
extends AbstractDSLDebugElementAdapter
implements IThread {
    public DSLThreadAdapter(DSLEclipseDebugIntegration factory) {
        super(factory);
    }

    @Override
    public boolean isAdapterForType(Object type) {
        return super.isAdapterForType(type) || type == IThread.class;
    }

    protected Thread getHost() {
        assert (this.target instanceof Thread);
        return (Thread)this.target;
    }

    public boolean canResume() {
        return ThreadUtils.canResume((Thread)this.getHost());
    }

    public boolean canSuspend() {
        return ThreadUtils.canSuspend((Thread)this.getHost());
    }

    public boolean isSuspended() {
        return ThreadUtils.isSuspended((Thread)this.getHost());
    }

    public void resume() throws DebugException {
        this.factory.getDebugger().handleEvent(new ResumeRequest(this.getHost().getName()));
    }

    public void suspend() throws DebugException {
        this.factory.getDebugger().handleEvent(new SuspendRequest(this.getHost().getName()));
    }

    public boolean canStepInto() {
        return ThreadUtils.canStepInto((Thread)this.getHost());
    }

    public boolean canStepOver() {
        return ThreadUtils.canStepOver((Thread)this.getHost());
    }

    public boolean canStepReturn() {
        return ThreadUtils.canStepReturn((Thread)this.getHost());
    }

    public boolean isStepping() {
        return ThreadUtils.isStepping((Thread)this.getHost());
    }

    public void stepInto() throws DebugException {
        this.factory.getDebugger().handleEvent(new StepIntoRequest(this.getHost().getName(), this.getHost().getTopStackFrame().getCurrentInstruction()));
    }

    public void stepOver() throws DebugException {
        this.factory.getDebugger().handleEvent(new StepOverRequest(this.getHost().getName(), this.getHost().getTopStackFrame().getCurrentInstruction()));
    }

    public void stepReturn() throws DebugException {
        this.factory.getDebugger().handleEvent(new StepReturnRequest(this.getHost().getName(), this.getHost().getTopStackFrame().getCurrentInstruction()));
    }

    public boolean canTerminate() {
        return ThreadUtils.canTerminate((Thread)this.getHost());
    }

    public boolean isTerminated() {
        return this.getHost().getState() == State.TERMINATED;
    }

    public void terminate() throws DebugException {
        this.factory.getModelUpdater().terminateRequest(this.getHost());
        this.factory.getDebugger().handleEvent(new TerminateRequest(this.getHost().getName()));
    }

    public IStackFrame[] getStackFrames() throws DebugException {
        ArrayList<DSLStackFrameAdapter> res = new ArrayList<DSLStackFrameAdapter>();
        if (this.isSuspended()) {
            StackFrame currentFrame = this.getHost().getTopStackFrame();
            while (currentFrame != null) {
                res.add(this.factory.getStackFrame(currentFrame));
                currentFrame = currentFrame.getParentFrame();
            }
        }
        return res.toArray(new IStackFrame[res.size()]);
    }

    public boolean hasStackFrames() throws DebugException {
        return this.getHost().getTopStackFrame() != null;
    }

    public int getPriority() throws DebugException {
        return this.getHost().getPriority();
    }

    public IStackFrame getTopStackFrame() throws DebugException {
        DSLStackFrameAdapter res = this.getHost().getTopStackFrame() != null ? this.factory.getStackFrame(this.getHost().getTopStackFrame()) : null;
        return res;
    }

    public String getName() throws DebugException {
        return this.getHost().getName();
    }

    public IBreakpoint[] getBreakpoints() {
        ArrayList<IBreakpoint> res = new ArrayList<IBreakpoint>();
        if (this.isSuspended()) {
            URI instructionUri = EcoreUtil.getURI((EObject)this.getHost().getTopStackFrame().getCurrentInstruction());
            IBreakpoint[] iBreakpointArray = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints(this.getModelIdentifier());
            int n = iBreakpointArray.length;
            int n2 = 0;
            while (n2 < n) {
                IBreakpoint breakpoint = iBreakpointArray[n2];
                if (breakpoint instanceof DSLBreakpoint && ((DSLBreakpoint)breakpoint).getURI().equals(instructionUri)) {
                    res.add(breakpoint);
                }
                ++n2;
            }
        }
        return res.toArray(new IBreakpoint[res.size()]);
    }
}

