/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.executionframework.engine.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gemoc.executionframework.engine.Activator;
import org.eclipse.gemoc.executionframework.engine.core.AbstractExecutionEngine;
import org.eclipse.gemoc.trace.commons.model.generictrace.GenericSequentialStep;
import org.eclipse.gemoc.trace.commons.model.generictrace.GenerictraceFactory;
import org.eclipse.gemoc.trace.commons.model.trace.GenericMSE;
import org.eclipse.gemoc.trace.commons.model.trace.MSE;
import org.eclipse.gemoc.trace.commons.model.trace.MSEModel;
import org.eclipse.gemoc.trace.commons.model.trace.MSEOccurrence;
import org.eclipse.gemoc.trace.commons.model.trace.Step;
import org.eclipse.gemoc.trace.commons.model.trace.TraceFactory;
import org.eclipse.gemoc.trace.gemoc.api.IMultiDimensionalTraceAddon;
import org.eclipse.gemoc.xdsmlframework.api.core.IExecutionContext;
import org.eclipse.gemoc.xdsmlframework.api.core.IRunConfiguration;

public abstract class AbstractSequentialExecutionEngine<C extends IExecutionContext<R, ?, ?>, R extends IRunConfiguration>
extends AbstractExecutionEngine<C, R> {
    private MSEModel _actionModel;
    private IMultiDimensionalTraceAddon<?, ?, ?, ?, ?> traceAddon;
    private Map<EClass, Set<EOperation>> orphanOperations = new HashMap<EClass, Set<EOperation>>();

    protected abstract void executeEntryPoint();

    protected abstract void initializeModel();

    protected abstract void prepareEntryPoint(C var1);

    protected abstract void prepareInitializeModel(C var1);

    @Override
    public final void performInitialize(C executionContext) {
        Set<IMultiDimensionalTraceAddon> traceManagers = this.getAddonsTypedBy(IMultiDimensionalTraceAddon.class);
        if (!traceManagers.isEmpty()) {
            this.traceAddon = traceManagers.iterator().next();
        }
        this.prepareEntryPoint(executionContext);
        this.prepareInitializeModel(executionContext);
    }

    @Override
    protected final void performStart() {
        this.initializeModel();
        this.notifyEngineInitialized();
        this.executeEntryPoint();
        Activator.getDefault().info("Execution finished");
    }

    @Override
    protected final void afterExecutionStep() {
        super.afterExecutionStep();
    }

    protected final void beforeExecutionStep(Object caller, String className, String operationName) {
        this.beforeExecutionStep(caller, className, operationName, Collections.emptyList());
    }

    protected final void beforeExecutionStep(Object caller, String className, String operationName, List<Object> args) {
        RecordingCommand rc = new RecordingCommand((TransactionalEditingDomain)this.editingDomain){

            protected void doExecute() {
            }
        };
        this.beforeExecutionStep(caller, className, operationName, rc, args);
        rc.execute();
    }

    protected final void beforeExecutionStep(Object caller, String className, String operationName, RecordingCommand rc) {
        this.beforeExecutionStep(caller, className, operationName, rc, Collections.emptyList());
    }

    protected final void beforeExecutionStep(Object caller, String className, String operationName, RecordingCommand rc, List<Object> args) {
        if (caller != null && caller instanceof EObject && this.editingDomain != null) {
            EObject callerCast = (EObject)caller;
            Step<?> step = this.createStep(callerCast, className, operationName, args);
            this.beforeExecutionStep(step, rc);
        }
    }

    private Step<?> createStep(EObject caller, String className, String methodName, List<Object> args) {
        Step result;
        MSE mse = this.findOrCreateMSE(caller, className, methodName);
        if (this.traceAddon == null) {
            GenericSequentialStep step = GenerictraceFactory.eINSTANCE.createGenericSequentialStep();
            MSEOccurrence occurrence = TraceFactory.eINSTANCE.createMSEOccurrence();
            for (Object arg : args) {
                occurrence.getParameters().add(arg);
            }
            step.setMseoccurrence(occurrence);
            occurrence.setMse(mse);
            result = step;
        } else {
            result = this.traceAddon.getFactory().createStep(mse, new ArrayList(), new ArrayList());
        }
        result.getMseoccurrence().getParameters().addAll(Arrays.asList(args));
        return result;
    }

    private void addOrpanOperation(EClass c, EOperation op) {
        if (!this.orphanOperations.containsKey(c)) {
            this.orphanOperations.put(c, new HashSet());
        }
        this.orphanOperations.get(c).add(op);
    }

    private EOperation findOperation(EObject object, String className, String methodName) {
        EOperation result = null;
        ArrayList<EClass> openSet = new ArrayList<EClass>();
        openSet.add(object.eClass());
        while (result == null && !openSet.isEmpty()) {
            EClass eClass = (EClass)openSet.remove(0);
            for (EOperation operation : eClass.getEOperations()) {
                if (!operation.getName().equalsIgnoreCase(methodName)) continue;
                result = operation;
            }
            openSet.addAll((Collection<EClass>)eClass.getESuperTypes());
        }
        if (result != null) {
            return result;
        }
        if (this.orphanOperations.containsKey(object.eClass())) {
            for (EOperation op : this.orphanOperations.get(object.eClass())) {
                if (!op.getName().equals(methodName)) continue;
                return op;
            }
        }
        EOperation operation = EcoreFactory.eINSTANCE.createEOperation();
        this.getActionModel().getOrphanOperations().add((Object)operation);
        operation.setName(methodName);
        this.addOrpanOperation(object.eClass(), operation);
        return operation;
    }

    private MSEModel getActionModel() {
        if (this._actionModel == null) {
            this._actionModel = TraceFactory.eINSTANCE.createMSEModel();
        }
        return this._actionModel;
    }

    public final MSE findOrCreateMSE(EObject caller, String className, String methodName) {
        EOperation operation = this.findOperation(caller, className, methodName);
        if (this.getActionModel() != null) {
            for (MSE existingMSE : this.getActionModel().getOwnedMSEs()) {
                if (!existingMSE.getCaller().equals(caller) || (existingMSE.getAction() == null || !existingMSE.getAction().equals(operation)) && (existingMSE.getAction() != null || operation != null)) continue;
                return existingMSE;
            }
        }
        final GenericMSE mse = TraceFactory.eINSTANCE.createGenericMSE();
        mse.setCallerReference(caller);
        mse.setActionReference(operation);
        if (operation != null) {
            mse.setName("MSE_" + caller.getClass().getSimpleName() + "_" + operation.getName());
        } else {
            mse.setName("MSE_" + caller.getClass().getSimpleName() + "_" + methodName);
        }
        if (this.getActionModel() != null) {
            if (this.getActionModel().eResource() != null) {
                TransactionUtil.getEditingDomain((Resource)this.getActionModel().eResource());
                RecordingCommand command = new RecordingCommand(TransactionUtil.getEditingDomain((Resource)this.getActionModel().eResource()), "Saving new MSE "){

                    protected void doExecute() {
                        AbstractSequentialExecutionEngine.this.getActionModel().getOwnedMSEs().add((Object)mse);
                        try {
                            AbstractSequentialExecutionEngine.this.getActionModel().eResource().save(null);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                };
                TransactionUtil.getEditingDomain((Resource)this.getActionModel().eResource()).getCommandStack().execute((Command)command);
            }
        } else {
            this.getActionModel().getOwnedMSEs().add((Object)mse);
        }
        return mse;
    }

    @Override
    protected void beforeStart() {
    }

    @Override
    protected void performStop() {
    }

    @Override
    protected void finishDispose() {
    }
}

