/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.trace.commons.model.helper;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gemoc.trace.commons.model.trace.BigStep;
import org.eclipse.gemoc.trace.commons.model.trace.MSE;
import org.eclipse.gemoc.trace.commons.model.trace.MSEOccurrence;
import org.eclipse.gemoc.trace.commons.model.trace.SmallStep;
import org.eclipse.gemoc.trace.commons.model.trace.Step;

public class StepHelper {
    public static String getStepName(Step<?> step) {
        return "LogicalStep [" + (EcoreUtil.getID(step) != null ? EcoreUtil.getID(step) : Integer.valueOf(System.identityHashCode(step))) + "]";
    }

    public static List<MSE> getMSEs(Step<?> instruction) {
        ArrayList<MSE> l = new ArrayList<MSE>();
        for (MSEOccurrence o : StepHelper.collectAllMSEOccurrences(instruction)) {
            l.add(o.getMse());
        }
        return l;
    }

    public static List<MSEOccurrence> collectAllMSEOccurrences(Step<?> instruction) {
        ArrayList<MSEOccurrence> res = new ArrayList<MSEOccurrence>();
        if (instruction instanceof SmallStep) {
            res.add(((SmallStep)instruction).getMseoccurrence());
            return res;
        }
        if (instruction instanceof BigStep) {
            for (Object o : ((BigStep)instruction).getSubSteps()) {
                Step s = (Step)o;
                res.addAll(StepHelper.collectAllMSEOccurrences(s));
            }
            return res;
        }
        return res;
    }

    public static List<MSE> collectAllMSEs(Step<?> instruction) {
        ArrayList<MSE> res = new ArrayList<MSE>();
        for (MSEOccurrence occ : StepHelper.collectAllMSEOccurrences(instruction)) {
            res.add(occ.getMse());
        }
        return res;
    }
}

