/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.codemanipulation.tostringgeneration;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ArrayAccess;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.InstanceofExpression;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.manipulation.CodeGeneration;
import org.eclipse.jdt.internal.core.manipulation.StubUtility;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility2Core;
import org.eclipse.jdt.internal.corext.codemanipulation.tostringgeneration.ToStringGenerationContext;
import org.eclipse.jdt.internal.corext.codemanipulation.tostringgeneration.ToStringTemplateParser;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public abstract class AbstractToStringGenerator {
    protected static final String METHODNAME_TO_STRING = "toString";
    protected static final String TYPENAME_STRING = "String";
    private static final String HELPER_ARRAYTOSTRING_METHOD_NAME = "arrayToString";
    private static final String MAX_LEN_VARIABLE_NAME = "maxLen";
    protected String fMaxLenVariableName = "maxLen";
    protected static final String OVERWRITE_METHOD_PROPERTY = "override_method";
    protected ToStringGenerationContext fContext;
    protected AST fAst;
    protected MethodDeclaration toStringMethod;
    protected boolean needMaxLenVariable;
    protected boolean needCollectionToStringMethod;
    protected List<ITypeBinding> typesThatNeedArrayToStringMethod;
    private Set<String> excluded;

    public ToStringTemplateParser getTemplateParser() {
        return new ToStringTemplateParser();
    }

    public RefactoringStatus checkConditions() {
        return new RefactoringStatus();
    }

    public MethodDeclaration generateToStringMethod() throws CoreException {
        this.initialize();
        String[] stringArray = this.fContext.getTemplateParser().getBeginning();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            this.addElement(this.processElement(element, null));
            ++n2;
        }
        Object[] members = this.fContext.getSelectedMembers();
        int i = 0;
        while (i < members.length) {
            if (!this.fContext.isSkipNulls() || this.getMemberType(members[i]).isPrimitive()) {
                this.addMember(members[i], i != members.length - 1);
            } else {
                this.addMemberCheckNull(members[i], i != members.length - 1);
            }
            ++i;
        }
        String[] stringArray2 = this.fContext.getTemplateParser().getEnding();
        int n3 = stringArray2.length;
        n = 0;
        while (n < n3) {
            String element = stringArray2[n];
            this.addElement(this.processElement(element, null));
            ++n;
        }
        this.complete();
        return this.toStringMethod;
    }

    public List<MethodDeclaration> generateHelperMethods() {
        ArrayList<MethodDeclaration> result = new ArrayList<MethodDeclaration>();
        if (this.needCollectionToStringMethod) {
            result.add(this.createHelperToStringMethod(false));
        }
        if (!this.typesThatNeedArrayToStringMethod.isEmpty()) {
            result.add(this.createHelperToStringMethod(true));
        }
        return result;
    }

    protected void createMethodComment() throws CoreException {
        String docString;
        ITypeBinding object = this.fAst.resolveWellKnownType("java.lang.Object");
        IMethodBinding objectMethod = null;
        IMethodBinding[] iMethodBindingArray = object.getDeclaredMethods();
        int n = iMethodBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethodBinding objm = iMethodBindingArray[n2];
            if (METHODNAME_TO_STRING.equals(objm.getName()) && objm.getParameterTypes().length == 0) {
                objectMethod = objm;
            }
            ++n2;
        }
        if (this.fContext.isCreateComments() && (docString = CodeGeneration.getMethodComment(this.fContext.getCompilationUnit(), this.fContext.getTypeBinding().getQualifiedName(), this.toStringMethod, objectMethod, StubUtility.getLineDelimiterUsed((IJavaElement)this.fContext.getCompilationUnit()))) != null) {
            Javadoc javadoc = (Javadoc)this.fContext.getASTRewrite().createStringPlaceholder(docString, 29);
            this.toStringMethod.setJavadoc(javadoc);
        }
        StubUtility2Core.addOverrideAnnotation(this.fContext.getCodeGenerationSettings(), this.fContext.getTypeBinding().getJavaElement().getJavaProject(), this.fContext.getASTRewrite(), this.fContext.getImportRewrite(), this.toStringMethod, objectMethod.getDeclaringClass().isInterface(), null);
    }

    protected MethodDeclaration createHelperToStringMethod(boolean array) {
        SingleVariableDeclaration param;
        String paramName;
        String stringBuilderName;
        String stringBuilderTypeName;
        String iteratorName = this.createNameSuggestion("iterator", 5);
        String indexName = this.createNameSuggestion("i", 5);
        String lengthParamName = this.createNameSuggestion("len", 4);
        String maxLenParamName = this.createNameSuggestion(MAX_LEN_VARIABLE_NAME, 4);
        if (this.fContext.is50orHigher()) {
            stringBuilderTypeName = "java.lang.StringBuilder";
            stringBuilderName = this.createNameSuggestion("builder", 5);
        } else {
            stringBuilderTypeName = "java.lang.StringBuffer";
            stringBuilderName = this.createNameSuggestion("buffer", 5);
        }
        MethodDeclaration arrayToStringMethod = this.fAst.newMethodDeclaration();
        arrayToStringMethod.setName(this.fAst.newSimpleName(array ? HELPER_ARRAYTOSTRING_METHOD_NAME : METHODNAME_TO_STRING));
        arrayToStringMethod.modifiers().add(this.fAst.newModifier(Modifier.ModifierKeyword.PRIVATE_KEYWORD));
        arrayToStringMethod.setReturnType2((Type)this.fAst.newSimpleType(this.fAst.newName(TYPENAME_STRING)));
        if (array) {
            paramName = this.createNameSuggestion("array", 4);
            param = this.fAst.newSingleVariableDeclaration();
            param.setType((Type)this.fAst.newSimpleType(this.addImport("java.lang.Object")));
            param.setName(this.fAst.newSimpleName(paramName));
            arrayToStringMethod.parameters().add(param);
            param = this.fAst.newSingleVariableDeclaration();
            param.setType((Type)this.fAst.newPrimitiveType(PrimitiveType.INT));
            param.setName(this.fAst.newSimpleName(lengthParamName));
            arrayToStringMethod.parameters().add(param);
        } else {
            paramName = this.createNameSuggestion("collection", 4);
            param = this.fAst.newSingleVariableDeclaration();
            SimpleType collectionType = this.fAst.newSimpleType(this.addImport("java.util.Collection"));
            if (this.fContext.is50orHigher()) {
                ParameterizedType genericType = this.fAst.newParameterizedType((Type)collectionType);
                genericType.typeArguments().add(this.fAst.newWildcardType());
                param.setType((Type)genericType);
            } else {
                param.setType((Type)collectionType);
            }
            param.setName(this.fAst.newSimpleName(paramName));
            arrayToStringMethod.parameters().add(param);
        }
        if (this.fContext.isLimitItems()) {
            param = this.fAst.newSingleVariableDeclaration();
            param.setType((Type)this.fAst.newPrimitiveType(PrimitiveType.INT));
            param.setName(this.fAst.newSimpleName(maxLenParamName));
            arrayToStringMethod.parameters().add(param);
        }
        Block body = this.fAst.newBlock();
        arrayToStringMethod.setBody(body);
        VariableDeclarationFragment fragment = this.fAst.newVariableDeclarationFragment();
        fragment.setName(this.fAst.newSimpleName(stringBuilderName));
        ClassInstanceCreation classInstance = this.fAst.newClassInstanceCreation();
        classInstance.setType((Type)this.fAst.newSimpleType(this.addImport(stringBuilderTypeName)));
        fragment.setInitializer((Expression)classInstance);
        VariableDeclarationStatement vStatement = this.fAst.newVariableDeclarationStatement(fragment);
        vStatement.setType((Type)this.fAst.newSimpleType(this.addImport(stringBuilderTypeName)));
        body.statements().add(vStatement);
        if (array && this.fContext.isLimitItems()) {
            MethodInvocation minInvocation = this.createMethodInvocation((Expression)this.addImport("java.lang.Math"), "min", (Expression)this.fAst.newSimpleName(lengthParamName));
            minInvocation.arguments().add(this.fAst.newSimpleName(maxLenParamName));
            Assignment lengthAssignment = this.fAst.newAssignment();
            lengthAssignment.setLeftHandSide((Expression)this.fAst.newSimpleName(lengthParamName));
            lengthAssignment.setRightHandSide((Expression)minInvocation);
            body.statements().add(this.fAst.newExpressionStatement((Expression)lengthAssignment));
        }
        StringLiteral literal = this.fAst.newStringLiteral();
        literal.setLiteralValue("[");
        body.statements().add(this.fAst.newExpressionStatement((Expression)this.createMethodInvocation(stringBuilderName, "append", (Expression)literal)));
        ForStatement forStatement = this.fAst.newForStatement();
        Block forBlock = this.fAst.newBlock();
        forStatement.setBody((Statement)forBlock);
        VariableDeclarationFragment indexDeclFragment = this.fAst.newVariableDeclarationFragment();
        indexDeclFragment.setName(this.fAst.newSimpleName(indexName));
        indexDeclFragment.setInitializer((Expression)this.fAst.newNumberLiteral("0"));
        VariableDeclarationExpression indexDeclExpression = this.fAst.newVariableDeclarationExpression(indexDeclFragment);
        indexDeclExpression.setType((Type)this.fAst.newPrimitiveType(PrimitiveType.INT));
        PostfixExpression postfixExpr = this.fAst.newPostfixExpression();
        postfixExpr.setOperand((Expression)this.fAst.newSimpleName(indexName));
        postfixExpr.setOperator(PostfixExpression.Operator.INCREMENT);
        forStatement.updaters().add(postfixExpr);
        IfStatement ifStatement = this.fAst.newIfStatement();
        ifStatement.setExpression((Expression)this.createInfixExpression((Expression)this.fAst.newSimpleName(indexName), InfixExpression.Operator.GREATER, (Expression)this.fAst.newNumberLiteral(String.valueOf(0))));
        literal = this.fAst.newStringLiteral();
        literal.setLiteralValue(", ");
        ifStatement.setThenStatement(this.createOneStatementBlock((Expression)this.createMethodInvocation(stringBuilderName, "append", (Expression)literal)));
        forBlock.statements().add(ifStatement);
        if (array) {
            forStatement.initializers().add(indexDeclExpression);
            forStatement.setExpression((Expression)this.createInfixExpression((Expression)this.fAst.newSimpleName(indexName), InfixExpression.Operator.LESS, (Expression)this.fAst.newSimpleName(lengthParamName)));
            for (ITypeBinding typeBinding : this.typesThatNeedArrayToStringMethod) {
                String typeName = typeBinding.getName();
                PrimitiveType.Code code = null;
                if ("byte".equals(typeName)) {
                    code = PrimitiveType.BYTE;
                }
                if ("short".equals(typeName)) {
                    code = PrimitiveType.SHORT;
                }
                if ("char".equals(typeName)) {
                    code = PrimitiveType.CHAR;
                }
                if ("int".equals(typeName)) {
                    code = PrimitiveType.INT;
                }
                if ("long".equals(typeName)) {
                    code = PrimitiveType.LONG;
                }
                if ("float".equals(typeName)) {
                    code = PrimitiveType.FLOAT;
                }
                if ("double".equals(typeName)) {
                    code = PrimitiveType.DOUBLE;
                }
                if ("boolean".equals(typeName)) {
                    code = PrimitiveType.BOOLEAN;
                }
                if (code == null && !"Object".equals(typeName)) continue;
                InstanceofExpression instanceOf = this.fAst.newInstanceofExpression();
                instanceOf.setLeftOperand((Expression)this.fAst.newSimpleName(paramName));
                instanceOf.setRightOperand((Type)this.fAst.newArrayType((Type)(code != null ? this.fAst.newPrimitiveType(code) : this.fAst.newSimpleType(this.addImport("java.lang.Object")))));
                ifStatement = this.fAst.newIfStatement();
                ifStatement.setExpression((Expression)instanceOf);
                CastExpression arrayCast = this.fAst.newCastExpression();
                arrayCast.setExpression((Expression)this.fAst.newSimpleName(paramName));
                arrayCast.setType((Type)this.fAst.newArrayType((Type)(code != null ? this.fAst.newPrimitiveType(code) : this.fAst.newSimpleType(this.addImport("java.lang.Object")))));
                ParenthesizedExpression parenthesizedCast = this.fAst.newParenthesizedExpression();
                parenthesizedCast.setExpression((Expression)arrayCast);
                ArrayAccess arrayAccess = this.fAst.newArrayAccess();
                arrayAccess.setArray((Expression)parenthesizedCast);
                arrayAccess.setIndex((Expression)this.fAst.newSimpleName(indexName));
                ifStatement.setThenStatement(this.createOneStatementBlock((Expression)this.createMethodInvocation(stringBuilderName, "append", (Expression)arrayAccess)));
                forBlock.statements().add(ifStatement);
            }
        } else {
            body.statements().add(this.fAst.newExpressionStatement((Expression)indexDeclExpression));
            fragment = this.fAst.newVariableDeclarationFragment();
            fragment.setName(this.fAst.newSimpleName(iteratorName));
            fragment.setInitializer((Expression)this.createMethodInvocation(paramName, "iterator", null));
            VariableDeclarationExpression vExpression = this.fAst.newVariableDeclarationExpression(fragment);
            SimpleType iteratorType = this.fAst.newSimpleType(this.addImport("java.util.Iterator"));
            if (this.fContext.is50orHigher()) {
                ParameterizedType pType = this.fAst.newParameterizedType((Type)iteratorType);
                pType.typeArguments().add(this.fAst.newWildcardType());
                vExpression.setType((Type)pType);
            } else {
                vExpression.setType((Type)iteratorType);
            }
            forStatement.initializers().add(vExpression);
            InfixExpression indexExpression = this.createInfixExpression((Expression)this.fAst.newSimpleName(indexName), InfixExpression.Operator.LESS, (Expression)this.fAst.newSimpleName(maxLenParamName));
            forStatement.setExpression((Expression)this.createInfixExpression((Expression)this.createMethodInvocation(iteratorName, "hasNext", null), InfixExpression.Operator.CONDITIONAL_AND, (Expression)indexExpression));
            MethodInvocation nextInvocation = this.createMethodInvocation(iteratorName, "next", null);
            forBlock.statements().add(this.fAst.newExpressionStatement((Expression)this.createMethodInvocation(stringBuilderName, "append", (Expression)nextInvocation)));
        }
        body.statements().add(forStatement);
        literal = this.fAst.newStringLiteral();
        literal.setLiteralValue("]");
        body.statements().add(this.fAst.newExpressionStatement((Expression)this.createMethodInvocation(stringBuilderName, "append", (Expression)literal)));
        ReturnStatement returnStatement = this.fAst.newReturnStatement();
        returnStatement.setExpression((Expression)this.createMethodInvocation(stringBuilderName, METHODNAME_TO_STRING, null));
        body.statements().add(returnStatement);
        arrayToStringMethod.setProperty(OVERWRITE_METHOD_PROPERTY, (Object)array);
        return arrayToStringMethod;
    }

    protected void initialize() {
        this.needMaxLenVariable = false;
        this.needCollectionToStringMethod = false;
        this.typesThatNeedArrayToStringMethod = new ArrayList<ITypeBinding>();
        this.checkNeedForHelperMethods();
        this.toStringMethod = this.fAst.newMethodDeclaration();
        this.toStringMethod.modifiers().addAll(ASTNodeFactory.newModifiers(this.fAst, 1));
        this.toStringMethod.setName(this.fAst.newSimpleName(METHODNAME_TO_STRING));
        this.toStringMethod.setConstructor(false);
        this.toStringMethod.setReturnType2((Type)this.fAst.newSimpleType(this.fAst.newName(TYPENAME_STRING)));
        Block body = this.fAst.newBlock();
        this.toStringMethod.setBody(body);
        this.fMaxLenVariableName = this.createNameSuggestion(MAX_LEN_VARIABLE_NAME, 5);
    }

    protected void complete() throws CoreException {
        if (this.needMaxLenVariable) {
            this.toStringMethod.getBody().statements().add(0, this.createMaxLenDeclaration());
        }
        this.createMethodComment();
        this.toStringMethod.setProperty(OVERWRITE_METHOD_PROPERTY, (Object)Boolean.TRUE);
    }

    protected void checkNeedForHelperMethods() {
        if (!this.fContext.isLimitItems() && !this.fContext.isCustomArray() || this.fContext.isLimitItems() && this.fContext.getLimitItemsValue() == 0) {
            return;
        }
        boolean isNonPrimitive = false;
        Object[] objectArray = this.fContext.getSelectedMembers();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object selectedMember = objectArray[n2];
            ITypeBinding memberType = this.getMemberType(selectedMember);
            boolean[] implementsInterfaces = this.implementsInterfaces(memberType.getErasure(), new String[]{"java.util.Collection", "java.util.List", "java.util.Map"});
            boolean isCollection = implementsInterfaces[0];
            boolean isList = implementsInterfaces[1];
            boolean isMap = implementsInterfaces[2];
            if (this.fContext.isLimitItems() && (isCollection || isMap) && !isList) {
                this.needCollectionToStringMethod = true;
            }
            if (this.fContext.isCustomArray() && memberType.isArray()) {
                ITypeBinding componentType = memberType.getComponentType();
                if (componentType.isPrimitive() && (!this.fContext.is50orHigher() || !this.fContext.is60orHigher() && this.fContext.isLimitItems())) {
                    if (!this.typesThatNeedArrayToStringMethod.contains(componentType)) {
                        this.typesThatNeedArrayToStringMethod.add(componentType);
                    }
                } else if (!componentType.isPrimitive()) {
                    isNonPrimitive = true;
                }
            }
            ++n2;
        }
        if (!this.typesThatNeedArrayToStringMethod.isEmpty() && isNonPrimitive) {
            this.typesThatNeedArrayToStringMethod.add(this.fAst.resolveWellKnownType("java.lang.Object"));
        }
    }

    protected Object processElement(String templateElement, Object member) {
        String result = templateElement;
        if ("${object.className}".equals(templateElement)) {
            result = this.fContext.getTypeBinding().getName();
        }
        if ("${object.getClassName}".equals(templateElement)) {
            MethodInvocation getClassInvocation = this.fAst.newMethodInvocation();
            if (this.fContext.isKeywordThis()) {
                getClassInvocation.setExpression((Expression)this.fAst.newThisExpression());
            }
            getClassInvocation.setName(this.fAst.newSimpleName("getClass"));
            MethodInvocation getNameInvocation = this.fAst.newMethodInvocation();
            getNameInvocation.setExpression((Expression)getClassInvocation);
            getNameInvocation.setName(this.fAst.newSimpleName("getName"));
            result = getNameInvocation;
        }
        if ("${object.superToString}".equals(templateElement)) {
            SuperMethodInvocation superToStringInvocation = this.fAst.newSuperMethodInvocation();
            superToStringInvocation.setName(this.fAst.newSimpleName(METHODNAME_TO_STRING));
            result = superToStringInvocation;
        }
        if ("${object.hashCode}".equals(templateElement)) {
            MethodInvocation hashCodeInvocation = this.fAst.newMethodInvocation();
            if (this.fContext.isKeywordThis()) {
                hashCodeInvocation.setExpression((Expression)this.fAst.newThisExpression());
            }
            hashCodeInvocation.setName(this.fAst.newSimpleName("hashCode"));
            result = hashCodeInvocation;
        }
        if ("${object.identityHashCode}".equals(templateElement)) {
            result = this.createMethodInvocation((Expression)this.addImport("java.lang.System"), "identityHashCode", (Expression)this.fAst.newThisExpression());
        }
        if ("${member.name}".equals(templateElement) || "${member.name()}".equals(templateElement)) {
            result = this.getMemberName(member, templateElement);
        }
        if ("${member.value}".equals(templateElement)) {
            result = this.createMemberAccessExpression(member, false, this.fContext.isSkipNulls());
        }
        if (result instanceof StringLiteral) {
            return ((StringLiteral)result).getLiteralValue();
        }
        return result;
    }

    protected abstract void addElement(Object var1);

    protected void addMember(Object member, boolean addSeparator) {
        String[] stringArray = this.fContext.getTemplateParser().getBody();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            this.addElement(this.processElement(element, member));
            ++n2;
        }
        if (addSeparator) {
            this.addElement(this.fContext.getTemplateParser().getSeparator());
        }
    }

    protected void addMemberCheckNull(Object member, boolean addSeparator) {
        this.addMember(member, addSeparator);
    }

    protected MethodInvocation createMethodInvocation(Expression expression, String methodName, Expression argument) {
        MethodInvocation invocation = this.fAst.newMethodInvocation();
        invocation.setExpression(expression);
        invocation.setName(this.fAst.newSimpleName(methodName));
        if (argument != null) {
            invocation.arguments().add(argument);
        }
        return invocation;
    }

    protected MethodInvocation createMethodInvocation(String receiver, String methodName, Expression argument) {
        return this.createMethodInvocation((Expression)this.fAst.newName(receiver), methodName, argument);
    }

    protected Statement createOneStatementBlock(Expression expression) {
        if (this.fContext.isForceBlocks()) {
            Block forBlock = this.fAst.newBlock();
            forBlock.statements().add(this.fAst.newExpressionStatement(expression));
            return forBlock;
        }
        return this.fAst.newExpressionStatement(expression);
    }

    protected InfixExpression createInfixExpression(Expression leftOperand, InfixExpression.Operator operator, Expression rightOperand) {
        InfixExpression expression = this.fAst.newInfixExpression();
        expression.setLeftOperand(leftOperand);
        expression.setOperator(operator);
        expression.setRightOperand(rightOperand);
        return expression;
    }

    protected VariableDeclarationStatement createMaxLenDeclaration() {
        VariableDeclarationFragment fragment = this.fAst.newVariableDeclarationFragment();
        fragment.setName(this.fAst.newSimpleName(this.fMaxLenVariableName));
        fragment.setInitializer((Expression)this.fAst.newNumberLiteral(String.valueOf(this.fContext.getLimitItemsValue())));
        VariableDeclarationStatement declExpression = this.fAst.newVariableDeclarationStatement(fragment);
        declExpression.setType((Type)this.fAst.newPrimitiveType(PrimitiveType.INT));
        declExpression.modifiers().add(this.fAst.newModifier(Modifier.ModifierKeyword.FINAL_KEYWORD));
        return declExpression;
    }

    protected Expression createMemberAccessExpression(Object member, boolean ignoreArraysCollections, boolean ignoreNulls) {
        if (!ignoreArraysCollections) {
            ITypeBinding memberType = this.getMemberType(member);
            boolean isArray = memberType.isArray();
            boolean[] implementsInterfaces = this.implementsInterfaces(memberType.getErasure(), new String[]{"java.util.Collection", "java.util.List", "java.util.Map"});
            boolean isCollection = implementsInterfaces[0];
            boolean isList = implementsInterfaces[1];
            boolean isMap = implementsInterfaces[2];
            if (isCollection || isMap || isArray && this.fContext.isCustomArray()) {
                StringLiteral accessExpression = null;
                if (this.fContext.isLimitItems()) {
                    if (this.fContext.getLimitItemsValue() == 0) {
                        accessExpression = this.fAst.newStringLiteral();
                        accessExpression.setLiteralValue("[]");
                    } else if (isList && !this.needCollectionToStringMethod) {
                        MethodInvocation memberSizeInvocation = this.fAst.newMethodInvocation();
                        memberSizeInvocation.setExpression(this.createMemberAccessExpression(member, true, true));
                        memberSizeInvocation.setName(this.fAst.newSimpleName("size"));
                        accessExpression = this.createSubListInvocation(this.createMemberAccessExpression(member, true, true), (Expression)memberSizeInvocation);
                        this.needMaxLenVariable = true;
                    } else if (isCollection || isMap) {
                        Expression memberAccess = this.createMemberAccessExpression(member, true, true);
                        if (isMap) {
                            MethodInvocation entrySetInvocation = this.fAst.newMethodInvocation();
                            entrySetInvocation.setExpression(memberAccess);
                            entrySetInvocation.setName(this.fAst.newSimpleName("entrySet"));
                            memberAccess = entrySetInvocation;
                        }
                        MethodInvocation toStringInvocation = this.fAst.newMethodInvocation();
                        if (this.fContext.isKeywordThis()) {
                            toStringInvocation.setExpression((Expression)this.fAst.newThisExpression());
                        }
                        toStringInvocation.setName(this.fAst.newSimpleName(METHODNAME_TO_STRING));
                        toStringInvocation.arguments().add(memberAccess);
                        toStringInvocation.arguments().add(this.fAst.newSimpleName(this.fMaxLenVariableName));
                        this.needMaxLenVariable = true;
                        accessExpression = toStringInvocation;
                    } else if (isArray) {
                        FieldAccess lengthAccess = this.fAst.newFieldAccess();
                        lengthAccess.setExpression(this.createMemberAccessExpression(member, true, true));
                        lengthAccess.setName(this.fAst.newSimpleName("length"));
                        ITypeBinding arrayComponentType = memberType.getComponentType();
                        if (!arrayComponentType.isPrimitive() && this.typesThatNeedArrayToStringMethod.isEmpty()) {
                            MethodInvocation asListInvocation = this.createMethodInvocation((Expression)this.addImport("java.util.Arrays"), "asList", this.createMemberAccessExpression(member, true, true));
                            accessExpression = this.createSubListInvocation((Expression)asListInvocation, (Expression)lengthAccess);
                        } else if (this.fContext.is60orHigher()) {
                            Name arraysImport = this.addImport("java.util.Arrays");
                            MethodInvocation minInvocation = this.createMethodInvocation((Expression)this.addImport("java.lang.Math"), "min", (Expression)lengthAccess);
                            minInvocation.arguments().add(this.fAst.newSimpleName(this.fMaxLenVariableName));
                            this.needMaxLenVariable = true;
                            MethodInvocation copyOfInvocation = this.createMethodInvocation((Expression)arraysImport, "copyOf", this.createMemberAccessExpression(member, true, true));
                            copyOfInvocation.arguments().add(minInvocation);
                            Name arraysImportCopy = (Name)ASTNode.copySubtree((AST)this.fAst, (ASTNode)arraysImport);
                            accessExpression = this.createMethodInvocation((Expression)arraysImportCopy, METHODNAME_TO_STRING, (Expression)copyOfInvocation);
                        } else {
                            MethodInvocation arrayToStringInvocation = this.fAst.newMethodInvocation();
                            if (this.fContext.isKeywordThis()) {
                                arrayToStringInvocation.setExpression((Expression)this.fAst.newThisExpression());
                            }
                            arrayToStringInvocation.setName(this.fAst.newSimpleName(HELPER_ARRAYTOSTRING_METHOD_NAME));
                            arrayToStringInvocation.arguments().add(this.createMemberAccessExpression(member, true, true));
                            arrayToStringInvocation.arguments().add(lengthAccess);
                            arrayToStringInvocation.arguments().add(this.fAst.newSimpleName(this.fMaxLenVariableName));
                            this.needMaxLenVariable = true;
                            accessExpression = arrayToStringInvocation;
                        }
                    }
                } else if (isArray && this.fContext.isCustomArray()) {
                    if (this.fContext.is50orHigher()) {
                        return this.createMethodInvocation((Expression)this.addImport("java.util.Arrays"), METHODNAME_TO_STRING, this.createMemberAccessExpression(member, true, true));
                    }
                    ITypeBinding arrayComponentType = memberType.getComponentType();
                    if (!arrayComponentType.isPrimitive() && this.typesThatNeedArrayToStringMethod.isEmpty()) {
                        accessExpression = this.createMethodInvocation((Expression)this.addImport("java.util.Arrays"), "asList", this.createMemberAccessExpression(member, true, true));
                    } else {
                        FieldAccess lengthAccess = this.fAst.newFieldAccess();
                        lengthAccess.setExpression(this.createMemberAccessExpression(member, true, true));
                        lengthAccess.setName(this.fAst.newSimpleName("length"));
                        MethodInvocation arrayToStringInvocation = this.fAst.newMethodInvocation();
                        if (this.fContext.isKeywordThis()) {
                            arrayToStringInvocation.setExpression((Expression)this.fAst.newThisExpression());
                        }
                        arrayToStringInvocation.setName(this.fAst.newSimpleName(HELPER_ARRAYTOSTRING_METHOD_NAME));
                        arrayToStringInvocation.arguments().add(this.createMemberAccessExpression(member, true, true));
                        arrayToStringInvocation.arguments().add(lengthAccess);
                        accessExpression = arrayToStringInvocation;
                    }
                }
                if (accessExpression != null) {
                    if (!ignoreNulls) {
                        ConditionalExpression conditional = this.fAst.newConditionalExpression();
                        conditional.setExpression((Expression)this.createInfixExpression(this.createMemberAccessExpression(member, true, true), InfixExpression.Operator.NOT_EQUALS, (Expression)this.fAst.newNullLiteral()));
                        conditional.setThenExpression((Expression)accessExpression);
                        conditional.setElseExpression((Expression)this.fAst.newNullLiteral());
                        return conditional;
                    }
                    return accessExpression;
                }
            }
        }
        if (member instanceof IVariableBinding) {
            if (this.fContext.isKeywordThis()) {
                FieldAccess fa = this.fAst.newFieldAccess();
                fa.setExpression((Expression)this.fAst.newThisExpression());
                fa.setName(this.fAst.newSimpleName(((IVariableBinding)member).getName()));
                return fa;
            }
            return this.fAst.newSimpleName(((IVariableBinding)member).getName());
        }
        if (member instanceof IMethodBinding) {
            SuperMethodInvocation invocation;
            if (METHODNAME_TO_STRING.equals(((IMethodBinding)member).getName())) {
                invocation = this.fAst.newSuperMethodInvocation();
                invocation.setName(this.fAst.newSimpleName(((IMethodBinding)member).getName()));
                return invocation;
            }
            invocation = this.fAst.newMethodInvocation();
            if (this.fContext.isKeywordThis()) {
                invocation.setExpression((Expression)this.fAst.newThisExpression());
            }
            invocation.setName(this.fAst.newSimpleName(((IMethodBinding)member).getName()));
            return invocation;
        }
        return null;
    }

    protected Expression createSubListInvocation(Expression memberAccess, Expression sizeAccess) {
        MethodInvocation subListInvocation = this.fAst.newMethodInvocation();
        subListInvocation.setExpression(memberAccess);
        subListInvocation.setName(this.fAst.newSimpleName("subList"));
        subListInvocation.arguments().add(this.fAst.newNumberLiteral(String.valueOf(0)));
        MethodInvocation minInvocation = this.createMethodInvocation((Expression)this.addImport("java.lang.Math"), "min", sizeAccess);
        minInvocation.arguments().add(this.fAst.newSimpleName(this.fMaxLenVariableName));
        subListInvocation.arguments().add(minInvocation);
        this.needMaxLenVariable = true;
        return subListInvocation;
    }

    protected Name addImport(String typeName) {
        String importedName = this.fContext.getImportRewrite().addImport(typeName);
        return this.fAst.newName(importedName);
    }

    protected String createNameSuggestion(String baseName, int variableKind) {
        if (this.excluded == null) {
            IVariableBinding[] iVariableBindingArray;
            this.excluded = new HashSet<String>();
            IVariableBinding[] iVariableBindingArray2 = this.fContext.getTypeBinding().getDeclaredFields();
            int n = iVariableBindingArray2.length;
            int n2 = 0;
            while (n2 < n) {
                IVariableBinding field = iVariableBindingArray2[n2];
                this.excluded.add(field.getName());
                ++n2;
            }
            ITypeBinding superType = this.fContext.getTypeBinding().getSuperclass();
            while (superType != null) {
                iVariableBindingArray = superType.getDeclaredFields();
                int n3 = iVariableBindingArray.length;
                n = 0;
                while (n < n3) {
                    IVariableBinding field = iVariableBindingArray[n];
                    if (!Modifier.isPrivate((int)field.getModifiers())) {
                        this.excluded.add(field.getName());
                    }
                    ++n;
                }
                superType = superType.getSuperclass();
            }
            iVariableBindingArray = this.fContext.getTypeBinding().getDeclaredTypes();
            int n4 = iVariableBindingArray.length;
            n = 0;
            while (n < n4) {
                IVariableBinding type = iVariableBindingArray[n];
                this.excluded.add(type.getName());
                ++n;
            }
            superType = this.fContext.getTypeBinding().getSuperclass();
            while (superType != null) {
                iVariableBindingArray = superType.getDeclaredTypes();
                n4 = iVariableBindingArray.length;
                n = 0;
                while (n < n4) {
                    IVariableBinding type = iVariableBindingArray[n];
                    if (!Modifier.isPrivate((int)type.getModifiers())) {
                        this.excluded.add(type.getName());
                    }
                    ++n;
                }
                superType = superType.getSuperclass();
            }
        }
        return StubUtility.getVariableNameSuggestions(variableKind, this.fContext.getCompilationUnit().getJavaProject(), baseName, 0, this.excluded, true)[0];
    }

    protected boolean[] implementsInterfaces(ITypeBinding memberType, String[] interfaceNames) {
        boolean[] result = new boolean[interfaceNames.length];
        int i = 0;
        while (i < interfaceNames.length) {
            if (memberType.getQualifiedName().equals(interfaceNames[i])) {
                result[i] = true;
            }
            ++i;
        }
        ITypeBinding[] iTypeBindingArray = memberType.getInterfaces();
        int n = iTypeBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding intf = iTypeBindingArray[n2];
            boolean[] deeper = this.implementsInterfaces(intf.getErasure(), interfaceNames);
            int j = 0;
            while (j < interfaceNames.length) {
                result[j] = result[j] || deeper[j];
                ++j;
            }
            ++n2;
        }
        return result;
    }

    protected String getMemberName(Object member, String templateElement) {
        if (member instanceof IVariableBinding) {
            return ((IVariableBinding)member).getName();
        }
        if (member instanceof IMethodBinding) {
            String result = ((IMethodBinding)member).getName();
            if ("${member.name()}".equals(templateElement)) {
                result = String.valueOf(result) + "()";
            }
            return result;
        }
        return null;
    }

    protected ITypeBinding getMemberType(Object member) {
        if (member instanceof IVariableBinding) {
            return ((IVariableBinding)member).getType();
        }
        if (member instanceof IMethodBinding) {
            return ((IMethodBinding)member).getReturnType();
        }
        return null;
    }

    public void setContext(ToStringGenerationContext context) {
        this.fContext = context;
        this.fAst = this.fContext.getAST();
        this.excluded = null;
    }

    public ToStringGenerationContext getContext() {
        return this.fContext;
    }
}

