/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.dsl.debug.ide.ui.provider;

import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class DecoratingColumLabelProvider
extends ColumnLabelProvider {
    protected final ILabelProvider labelProvider;
    protected final IFontProvider fontProvider;
    protected final IColorProvider colorProvider;
    protected final ILabelDecorator labelDecorator;
    protected final CellLabelProvider cellLabelProvider;

    public DecoratingColumLabelProvider(ILabelProvider labelProvider, ILabelDecorator labelDecorator) {
        this.labelProvider = labelProvider;
        this.fontProvider = labelProvider instanceof IFontProvider ? (IFontProvider)labelProvider : null;
        this.colorProvider = labelProvider instanceof IColorProvider ? (IColorProvider)labelProvider : null;
        this.labelDecorator = labelDecorator;
        this.cellLabelProvider = labelDecorator instanceof CellLabelProvider ? (CellLabelProvider)labelDecorator : null;
    }

    public void addListener(ILabelProviderListener listener) {
        if (this.labelDecorator != null) {
            this.labelDecorator.addListener(listener);
        }
        super.addListener(listener);
    }

    public void removeListener(ILabelProviderListener listener) {
        if (this.labelDecorator != null) {
            this.labelDecorator.addListener(listener);
        }
        super.removeListener(listener);
    }

    public Font getFont(Object element) {
        Font res = this.fontProvider == null ? null : this.fontProvider.getFont(element);
        return res;
    }

    public Color getBackground(Object element) {
        Color res = this.colorProvider == null ? null : this.colorProvider.getBackground(element);
        return res;
    }

    public Color getForeground(Object element) {
        Color res = this.colorProvider == null ? null : this.colorProvider.getForeground(element);
        return res;
    }

    public Image getImage(Object element) {
        Image image = this.labelProvider.getImage(element);
        Image res = image != null ? this.labelDecorator.decorateImage(image, element) : image;
        return res;
    }

    public String getText(Object element) {
        return this.labelDecorator.decorateText(this.labelProvider.getText(element), element);
    }

    public Image getToolTipImage(Object element) {
        Image res = this.cellLabelProvider == null ? null : this.cellLabelProvider.getToolTipImage(element);
        return res;
    }

    public String getToolTipText(Object element) {
        String res = this.cellLabelProvider == null ? null : this.cellLabelProvider.getToolTipText(element);
        return res;
    }

    public Color getToolTipBackgroundColor(Object element) {
        Color res = this.cellLabelProvider == null ? null : this.cellLabelProvider.getToolTipBackgroundColor(element);
        return res;
    }

    public Color getToolTipForegroundColor(Object element) {
        Color res = this.cellLabelProvider == null ? null : this.cellLabelProvider.getToolTipForegroundColor(element);
        return res;
    }

    public Font getToolTipFont(Object element) {
        Font res = this.cellLabelProvider == null ? null : this.cellLabelProvider.getToolTipFont(element);
        return res;
    }

    public Point getToolTipShift(Object element) {
        Point res = this.cellLabelProvider == null ? null : this.cellLabelProvider.getToolTipShift(element);
        return res;
    }

    public boolean useNativeToolTip(Object element) {
        boolean res = this.cellLabelProvider == null ? false : this.cellLabelProvider.useNativeToolTip(element);
        return res;
    }

    public int getToolTipTimeDisplayed(Object element) {
        int res = this.cellLabelProvider == null ? 0 : this.cellLabelProvider.getToolTipTimeDisplayed(element);
        return res;
    }

    public int getToolTipDisplayDelayTime(Object element) {
        int res = this.cellLabelProvider == null ? 0 : this.cellLabelProvider.getToolTipDisplayDelayTime(element);
        return res;
    }

    public int getToolTipStyle(Object element) {
        int res = this.cellLabelProvider == null ? 0 : this.cellLabelProvider.getToolTipStyle(element);
        return res;
    }

    public void dispose() {
        super.dispose();
        this.labelProvider.dispose();
        this.labelDecorator.dispose();
    }

    public boolean isLabelProperty(Object element, String property) {
        return this.labelProvider.isLabelProperty(element, property);
    }
}

