/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.trace.gemoc.traceaddon;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gemoc.commons.eclipse.emf.EMFResource;
import org.eclipse.gemoc.executionframework.debugger.IDynamicPartAccessor;
import org.eclipse.gemoc.executionframework.debugger.MutableField;
import org.eclipse.gemoc.trace.commons.model.generictrace.BooleanAttributeValue;
import org.eclipse.gemoc.trace.commons.model.generictrace.DoubleAttributeValue;
import org.eclipse.gemoc.trace.commons.model.generictrace.DoubleObjectAttributeValue;
import org.eclipse.gemoc.trace.commons.model.generictrace.GenericDimension;
import org.eclipse.gemoc.trace.commons.model.generictrace.GenericSequentialStep;
import org.eclipse.gemoc.trace.commons.model.generictrace.GenericSmallStep;
import org.eclipse.gemoc.trace.commons.model.generictrace.GenericState;
import org.eclipse.gemoc.trace.commons.model.generictrace.GenericStep;
import org.eclipse.gemoc.trace.commons.model.generictrace.GenericTracedObject;
import org.eclipse.gemoc.trace.commons.model.generictrace.GenericValue;
import org.eclipse.gemoc.trace.commons.model.generictrace.GenerictraceFactory;
import org.eclipse.gemoc.trace.commons.model.generictrace.IntegerAttributeValue;
import org.eclipse.gemoc.trace.commons.model.generictrace.IntegerObjectAttributeValue;
import org.eclipse.gemoc.trace.commons.model.generictrace.LongAttributeValue;
import org.eclipse.gemoc.trace.commons.model.generictrace.LongObjectAttributeValue;
import org.eclipse.gemoc.trace.commons.model.generictrace.ManyBooleanAttributeValue;
import org.eclipse.gemoc.trace.commons.model.generictrace.ManyDoubleAttributeValue;
import org.eclipse.gemoc.trace.commons.model.generictrace.ManyIntegerAttributeValue;
import org.eclipse.gemoc.trace.commons.model.generictrace.ManyLongAttributeValue;
import org.eclipse.gemoc.trace.commons.model.generictrace.ManyReferenceValue;
import org.eclipse.gemoc.trace.commons.model.generictrace.ManyStringAttributeValue;
import org.eclipse.gemoc.trace.commons.model.generictrace.SingleReferenceValue;
import org.eclipse.gemoc.trace.commons.model.generictrace.StringAttributeValue;
import org.eclipse.gemoc.trace.commons.model.launchconfiguration.LaunchConfiguration;
import org.eclipse.gemoc.trace.commons.model.trace.BigStep;
import org.eclipse.gemoc.trace.commons.model.trace.MSEModel;
import org.eclipse.gemoc.trace.commons.model.trace.State;
import org.eclipse.gemoc.trace.commons.model.trace.Step;
import org.eclipse.gemoc.trace.commons.model.trace.Trace;
import org.eclipse.gemoc.trace.commons.model.trace.TraceFactory;
import org.eclipse.gemoc.trace.commons.model.trace.TracedObject;
import org.eclipse.gemoc.trace.gemoc.Activator;
import org.eclipse.gemoc.trace.gemoc.api.ITraceConstructor;
import org.eclipse.gemoc.xdsmlframework.api.engine_addon.modelchangelistener.ModelChange;
import org.eclipse.gemoc.xdsmlframework.api.engine_addon.modelchangelistener.NewObjectModelChange;
import org.eclipse.gemoc.xdsmlframework.api.engine_addon.modelchangelistener.NonCollectionFieldModelChange;
import org.eclipse.gemoc.xdsmlframework.api.engine_addon.modelchangelistener.PotentialCollectionFieldModelChange;
import org.eclipse.gemoc.xdsmlframework.api.engine_addon.modelchangelistener.RemovedObjectModelChange;

public class GenericTraceConstructor
implements ITraceConstructor {
    private Trace<GenericSequentialStep, GenericTracedObject, GenericState> traceRoot;
    private Resource executedModel;
    private MSEModel mseModel;
    private Resource traceResource;
    private final Map<EObject, TracedObject<?>> exeToTraced;
    private final Deque<GenericSequentialStep> context = new LinkedList<GenericSequentialStep>();
    private GenericState lastState;
    IDynamicPartAccessor dynamicPartAccessor;
    private boolean copiedState = false;

    public GenericTraceConstructor(Resource executedModel, Resource traceResource, Map<EObject, TracedObject<?>> exeToTraced, IDynamicPartAccessor dynamicPartAccessor) {
        this.executedModel = executedModel;
        this.traceResource = traceResource;
        this.exeToTraced = exeToTraced;
        this.dynamicPartAccessor = dynamicPartAccessor;
    }

    private Set<Resource> getAllExecutedModelResources() {
        HashSet<Resource> allResources = new HashSet<Resource>();
        allResources.add(this.executedModel);
        allResources.addAll(EMFResource.getRelatedResources((Resource)this.executedModel));
        allResources.removeIf(r -> r == null);
        return allResources;
    }

    private boolean addNewObjectToStateIfDynamic(EObject object, GenericState state) {
        List fields = this.dynamicPartAccessor.extractMutableField(object);
        List<EStructuralFeature> mutableProperties = fields.stream().map(f -> f.getMutableProperty()).collect(Collectors.toList());
        if (this.dynamicPartAccessor.isDynamic(object) || !fields.isEmpty()) {
            return this.addNewObjectToState(object, mutableProperties, this.lastState);
        }
        return true;
    }

    private GenericValue getGenericValue(EObject object, EStructuralFeature mutableProperty, GenericState state) {
        IntegerObjectAttributeValue result = null;
        List fields = this.dynamicPartAccessor.extractMutableField(object);
        Optional<MutableField> dynamicProperty = fields.stream().filter(field -> field.getMutableProperty().getName().equals(mutableProperty.getName())).findFirst();
        if (mutableProperty instanceof EAttribute) {
            EClassifier eType = mutableProperty.getEType();
            if (eType == EcorePackage.Literals.EINT) {
                if (mutableProperty.getUpperBound() == -1) {
                    ManyIntegerAttributeValue value = GenerictraceFactory.eINSTANCE.createManyIntegerAttributeValue();
                    if (dynamicProperty.isPresent()) {
                        value.getAttributeValue().addAll((Collection)((EList)dynamicProperty.get().getValue()));
                    }
                    result = value;
                } else {
                    IntegerAttributeValue value = GenerictraceFactory.eINSTANCE.createIntegerAttributeValue();
                    if (dynamicProperty.isPresent()) {
                        value.setAttributeValue(((Integer)dynamicProperty.get().getValue()).intValue());
                    }
                    result = value;
                }
            } else if (eType == EcorePackage.Literals.EINTEGER_OBJECT) {
                IntegerObjectAttributeValue value = GenerictraceFactory.eINSTANCE.createIntegerObjectAttributeValue();
                if (dynamicProperty.isPresent()) {
                    value.setAttributeValue((Integer)dynamicProperty.get().getValue());
                }
                result = value;
            } else if (eType == EcorePackage.Literals.EBOOLEAN) {
                if (mutableProperty.getUpperBound() == -1) {
                    ManyBooleanAttributeValue value = GenerictraceFactory.eINSTANCE.createManyBooleanAttributeValue();
                    if (dynamicProperty.isPresent()) {
                        value.getAttributeValue().addAll((Collection)((EList)dynamicProperty.get().getValue()));
                    }
                    result = value;
                } else {
                    BooleanAttributeValue value = GenerictraceFactory.eINSTANCE.createBooleanAttributeValue();
                    if (dynamicProperty.isPresent()) {
                        value.setAttributeValue(((Boolean)dynamicProperty.get().getValue()).booleanValue());
                    }
                    result = value;
                }
            } else if (eType == EcorePackage.Literals.ESTRING) {
                if (mutableProperty.getUpperBound() == -1) {
                    ManyStringAttributeValue value = GenerictraceFactory.eINSTANCE.createManyStringAttributeValue();
                    if (dynamicProperty.isPresent()) {
                        value.getAttributeValue().addAll((Collection)((EList)dynamicProperty.get().getValue()));
                    }
                    result = value;
                } else {
                    StringAttributeValue value = GenerictraceFactory.eINSTANCE.createStringAttributeValue();
                    if (dynamicProperty.isPresent()) {
                        value.setAttributeValue((String)dynamicProperty.get().getValue());
                    }
                    result = value;
                }
            } else if (eType == EcorePackage.Literals.EDOUBLE) {
                if (mutableProperty.getUpperBound() == -1) {
                    ManyDoubleAttributeValue value = GenerictraceFactory.eINSTANCE.createManyDoubleAttributeValue();
                    if (dynamicProperty.isPresent()) {
                        value.getAttributeValue().addAll((Collection)((EList)dynamicProperty.get().getValue()));
                    }
                    result = value;
                } else {
                    DoubleAttributeValue value = GenerictraceFactory.eINSTANCE.createDoubleAttributeValue();
                    if (dynamicProperty.isPresent()) {
                        value.setAttributeValue(((Double)dynamicProperty.get().getValue()).doubleValue());
                    }
                    result = value;
                }
            } else if (eType == EcorePackage.Literals.EDOUBLE_OBJECT) {
                DoubleObjectAttributeValue value = GenerictraceFactory.eINSTANCE.createDoubleObjectAttributeValue();
                if (dynamicProperty.isPresent()) {
                    value.setAttributeValue((Double)dynamicProperty.get().getValue());
                }
                result = value;
            } else if (eType == EcorePackage.Literals.ELONG) {
                if (mutableProperty.getUpperBound() == -1) {
                    ManyLongAttributeValue value = GenerictraceFactory.eINSTANCE.createManyLongAttributeValue();
                    if (dynamicProperty.isPresent()) {
                        value.getAttributeValue().addAll((Collection)((EList)dynamicProperty.get().getValue()));
                    }
                    result = value;
                } else {
                    LongAttributeValue value = GenerictraceFactory.eINSTANCE.createLongAttributeValue();
                    if (dynamicProperty.isPresent()) {
                        value.setAttributeValue(((Long)dynamicProperty.get().getValue()).longValue());
                    }
                    result = value;
                }
            } else if (eType == EcorePackage.Literals.ELONG_OBJECT) {
                LongObjectAttributeValue value = GenerictraceFactory.eINSTANCE.createLongObjectAttributeValue();
                if (dynamicProperty.isPresent()) {
                    value.setAttributeValue((Long)dynamicProperty.get().getValue());
                }
                result = value;
            } else {
                Activator.error("eType " + eType + " not supported yet (used by " + mutableProperty.getName() + " of " + object.eClass() + ");\n " + "Please use another type in your RTD or consider to contribute to GEMOC framework", new UnsupportedOperationException("eType " + eType + " not supported yet (used by " + mutableProperty.getName() + " of " + object.eClass() + ")"));
            }
        } else if (mutableProperty instanceof EReference) {
            if (mutableProperty.isMany()) {
                List modelElements = new ArrayList();
                if (dynamicProperty.isPresent()) {
                    modelElements = (List)dynamicProperty.get().getValue();
                }
                ManyReferenceValue value = GenerictraceFactory.eINSTANCE.createManyReferenceValue();
                for (EObject o : modelElements) {
                    if (this.dynamicPartAccessor.isDynamic(o) || !fields.isEmpty()) {
                        TracedObject<?> tracedObj = this.exeToTraced.get(o);
                        if (tracedObj == null) {
                            Activator.error("Cannot find traced object for " + o + " (used by " + mutableProperty.getName() + " of " + object.eClass() + ");\n" + "Did you correctly declare it as Runtime Data ?", new Exception("Cannot find traced object for " + o + " (used by " + mutableProperty.getName() + " of " + object.eClass() + ")"));
                        }
                        value.getReferenceValues().add(tracedObj);
                        continue;
                    }
                    value.getReferenceValues().add((Object)o);
                }
                result = value;
            } else {
                EObject o = null;
                if (dynamicProperty.isPresent()) {
                    o = (EObject)dynamicProperty.get().getValue();
                }
                SingleReferenceValue value = GenerictraceFactory.eINSTANCE.createSingleReferenceValue();
                if (o != null && this.dynamicPartAccessor.isDynamic(o)) {
                    TracedObject<?> tracedObj = this.exeToTraced.get(o);
                    if (tracedObj == null) {
                        Activator.error("Cannot find traced object for " + o + " (used by " + mutableProperty.getName() + " of " + object.eClass() + ");\n" + "Did you correctly declare it as Runtime Data ?", new Exception("Cannot find traced object for " + o + " (used by " + mutableProperty.getName() + " of " + object.eClass() + ")"));
                    }
                    value.setReferenceValue(tracedObj);
                } else {
                    value.setReferenceValue(o);
                }
                result = value;
            }
        }
        return result;
    }

    private boolean addNewObjectToState(EObject object, List<EStructuralFeature> mutableProperties, GenericState state) {
        boolean added = false;
        if (!this.exeToTraced.containsKey(object)) {
            List fields = this.dynamicPartAccessor.extractMutableField(object);
            GenericTracedObject tracedObject = GenerictraceFactory.eINSTANCE.createGenericTracedObject();
            if (!this.dynamicPartAccessor.isDynamic(object)) {
                tracedObject.setOriginalObject(object);
            }
            this.exeToTraced.put(object, (TracedObject<?>)tracedObject);
            for (EStructuralFeature mutableProperty : mutableProperties) {
                ManyIntegerAttributeValue value;
                Optional<MutableField> dynamicProperty = fields.stream().filter(field -> field.getMutableProperty().getName().equals(mutableProperty.getName())).findFirst();
                GenericDimension dimension = GenerictraceFactory.eINSTANCE.createGenericDimension();
                ManyIntegerAttributeValue firstValue = null;
                dimension.setDynamicProperty(mutableProperty);
                tracedObject.getAllDimensions().add((Object)dimension);
                if (mutableProperty instanceof EAttribute) {
                    EClassifier eType = mutableProperty.getEType();
                    if (eType == EcorePackage.Literals.EINT) {
                        if (mutableProperty.getUpperBound() == -1) {
                            value = GenerictraceFactory.eINSTANCE.createManyIntegerAttributeValue();
                            if (dynamicProperty.isPresent()) {
                                value.getAttributeValue().addAll((Collection)((EList)dynamicProperty.get().getValue()));
                            }
                            firstValue = value;
                        } else {
                            value = GenerictraceFactory.eINSTANCE.createIntegerAttributeValue();
                            if (dynamicProperty.isPresent()) {
                                value.setAttributeValue(((Integer)dynamicProperty.get().getValue()).intValue());
                            }
                            firstValue = value;
                        }
                    } else if (eType == EcorePackage.Literals.EBOOLEAN) {
                        if (mutableProperty.getUpperBound() == -1) {
                            value = GenerictraceFactory.eINSTANCE.createManyBooleanAttributeValue();
                            if (dynamicProperty.isPresent()) {
                                value.getAttributeValue().addAll((Collection)((EList)dynamicProperty.get().getValue()));
                            }
                            firstValue = value;
                        } else {
                            value = GenerictraceFactory.eINSTANCE.createBooleanAttributeValue();
                            if (dynamicProperty.isPresent()) {
                                value.setAttributeValue(((Boolean)dynamicProperty.get().getValue()).booleanValue());
                            }
                            firstValue = value;
                        }
                    } else if (eType == EcorePackage.Literals.ESTRING) {
                        if (mutableProperty.getUpperBound() == -1) {
                            value = GenerictraceFactory.eINSTANCE.createManyStringAttributeValue();
                            if (dynamicProperty.isPresent()) {
                                value.getAttributeValue().addAll((Collection)((EList)dynamicProperty.get().getValue()));
                            }
                            firstValue = value;
                        } else {
                            value = GenerictraceFactory.eINSTANCE.createStringAttributeValue();
                            if (dynamicProperty.isPresent()) {
                                value.setAttributeValue((String)dynamicProperty.get().getValue());
                            }
                            firstValue = value;
                        }
                    } else if (eType == EcorePackage.Literals.EDOUBLE) {
                        if (mutableProperty.getUpperBound() == -1) {
                            value = GenerictraceFactory.eINSTANCE.createManyDoubleAttributeValue();
                            if (dynamicProperty.isPresent()) {
                                value.getAttributeValue().addAll((Collection)((EList)dynamicProperty.get().getValue()));
                            }
                            firstValue = value;
                        } else {
                            value = GenerictraceFactory.eINSTANCE.createDoubleAttributeValue();
                            if (dynamicProperty.isPresent()) {
                                value.setAttributeValue(((Double)dynamicProperty.get().getValue()).doubleValue());
                            }
                            firstValue = value;
                        }
                    } else if (eType == EcorePackage.Literals.ELONG) {
                        if (mutableProperty.getUpperBound() == -1) {
                            value = GenerictraceFactory.eINSTANCE.createManyLongAttributeValue();
                            if (dynamicProperty.isPresent()) {
                                value.getAttributeValue().addAll((Collection)((EList)dynamicProperty.get().getValue()));
                            }
                            firstValue = value;
                        } else {
                            value = GenerictraceFactory.eINSTANCE.createLongAttributeValue();
                            if (dynamicProperty.isPresent()) {
                                value.setAttributeValue(((Long)dynamicProperty.get().getValue()).longValue());
                            }
                            firstValue = value;
                        }
                    } else if (eType == EcorePackage.Literals.EINTEGER_OBJECT) {
                        value = GenerictraceFactory.eINSTANCE.createIntegerObjectAttributeValue();
                        if (dynamicProperty.isPresent()) {
                            value.setAttributeValue((Integer)dynamicProperty.get().getValue());
                        }
                        firstValue = value;
                    } else if (eType == EcorePackage.Literals.EDOUBLE_OBJECT) {
                        value = GenerictraceFactory.eINSTANCE.createDoubleObjectAttributeValue();
                        if (dynamicProperty.isPresent()) {
                            value.setAttributeValue((Double)dynamicProperty.get().getValue());
                        }
                        firstValue = value;
                    } else if (eType == EcorePackage.Literals.ELONG_OBJECT) {
                        value = GenerictraceFactory.eINSTANCE.createLongObjectAttributeValue();
                        if (dynamicProperty.isPresent()) {
                            value.setAttributeValue((Long)dynamicProperty.get().getValue());
                        }
                        firstValue = value;
                    } else {
                        Activator.error("eType " + eType + " not supported yet (used by " + mutableProperty.getName() + " of " + object.eClass() + "); " + "Please use another type in your RTD or consider to contribute to GEMOC framework", new UnsupportedOperationException("eType " + eType + " not supported yet (used by " + mutableProperty.getName() + " of " + object.eClass() + ")"));
                    }
                } else if (mutableProperty instanceof EReference) {
                    if (mutableProperty.isMany()) {
                        List modelElements = new ArrayList();
                        if (dynamicProperty.isPresent()) {
                            modelElements = (List)dynamicProperty.get().getValue();
                        }
                        value = GenerictraceFactory.eINSTANCE.createManyReferenceValue();
                        for (EObject o : modelElements) {
                            this.addNewObjectToStateIfDynamic(o, state);
                            TracedObject<?> tracedObj = this.exeToTraced.get(o);
                            if (tracedObj != null) {
                                value.getReferenceValues().add(tracedObj);
                                continue;
                            }
                            value.getReferenceValues().add((Object)o);
                        }
                        firstValue = value;
                    } else {
                        EObject o = null;
                        if (dynamicProperty.isPresent()) {
                            o = (EObject)dynamicProperty.get().getValue();
                        }
                        if (o != null) {
                            this.addNewObjectToStateIfDynamic(o, state);
                            value = GenerictraceFactory.eINSTANCE.createSingleReferenceValue();
                            TracedObject<?> tracedObj = this.exeToTraced.get(o);
                            if (tracedObj != null) {
                                value.setReferenceValue(tracedObj);
                            } else {
                                value.setReferenceValue(o);
                            }
                            firstValue = value;
                        }
                    }
                }
                if (firstValue == null) continue;
                dimension.getValues().add(firstValue);
                state.getValues().add(firstValue);
            }
            this.traceRoot.getTracedObjects().add((Object)tracedObject);
            added = true;
        }
        return added;
    }

    private void addInitialState() {
        if (this.lastState == null) {
            Set<Resource> allResources = this.getAllExecutedModelResources();
            this.lastState = GenerictraceFactory.eINSTANCE.createGenericState();
            for (Resource r : allResources) {
                TreeIterator i = r.getAllContents();
                while (i.hasNext()) {
                    EObject o = (EObject)i.next();
                    this.addNewObjectToStateIfDynamic(o, this.lastState);
                }
            }
            this.traceRoot.getStates().add((Object)this.lastState);
        }
    }

    private GenericState copyState(GenericState oldState) {
        GenericState newState = GenerictraceFactory.eINSTANCE.createGenericState();
        newState.getValues().addAll((Collection)oldState.getValues());
        this.copiedState = true;
        return newState;
    }

    public void addState(List<ModelChange> modelChanges) {
        if (this.lastState == null) {
            this.addInitialState();
        }
        if (!modelChanges.isEmpty()) {
            boolean stateChanged = false;
            GenericState newState = this.copyState(this.lastState);
            for (ModelChange modelChange : modelChanges) {
                List values;
                ManyReferenceValue lastValue;
                GenericDimension dimension;
                GenericTracedObject tracedObject;
                Optional<MutableField> dynamicProperty;
                EStructuralFeature p;
                EObject o = modelChange.getChangedObject();
                List fields = this.dynamicPartAccessor.extractMutableField(o);
                if (modelChange instanceof NewObjectModelChange) {
                    stateChanged = true;
                    this.addNewObjectToStateIfDynamic(o, newState);
                    continue;
                }
                if (modelChange instanceof RemovedObjectModelChange) {
                    stateChanged = true;
                    EList values2 = newState.getValues();
                    EList dimensions = ((GenericTracedObject)this.exeToTraced.get(o)).getAllDimensions();
                    if (dimensions == null || dimensions.size() <= 0) continue;
                    for (GenericDimension d2 : dimensions) {
                        if (d2.getValues() == null || d2.getValues().size() <= 0) continue;
                        values2.remove(d2.getValues().get(d2.getValues().size() - 1));
                    }
                    continue;
                }
                if (modelChange instanceof NonCollectionFieldModelChange) {
                    GenericValue lastValue2;
                    Object pValue;
                    stateChanged = true;
                    p = ((NonCollectionFieldModelChange)modelChange).getChangedField();
                    dynamicProperty = fields.stream().filter(field -> field.getMutableProperty().getName().equals(p.getName())).findFirst();
                    tracedObject = (GenericTracedObject)this.exeToTraced.get(o);
                    dimension = tracedObject.getAllDimensions().stream().filter(d -> d.getDynamicProperty().getName().equals(p.getName())).findFirst().orElse(null);
                    if (dimension == null) continue;
                    EList values3 = dimension.getValues();
                    if (dynamicProperty.isPresent() && (pValue = dynamicProperty.get().getValue()) instanceof EObject) {
                        this.addNewObjectToStateIfDynamic((EObject)pValue, newState);
                    }
                    GenericValue genericValue = lastValue2 = values3.isEmpty() ? null : (GenericValue)values3.get(values3.size() - 1);
                    if (lastValue2 != null) {
                        newState.getValues().remove((Object)lastValue2);
                    }
                    GenericValue newValue = this.getGenericValue(o, p, newState);
                    values3.add(newValue);
                    newState.getValues().add((Object)newValue);
                    continue;
                }
                if (!(modelChange instanceof PotentialCollectionFieldModelChange)) continue;
                p = ((PotentialCollectionFieldModelChange)modelChange).getChangedField();
                dynamicProperty = fields.stream().filter(field -> field.getMutableProperty().getName().equals(p.getName())).findFirst();
                tracedObject = (GenericTracedObject)this.exeToTraced.get(o);
                dimension = tracedObject.getAllDimensions().stream().filter(d -> d.getDynamicProperty() == p).findFirst().orElse(null);
                if (dimension == null) continue;
                EList dimensionValues = dimension.getValues();
                GenericValue lastDimensionValue = (GenericValue)dimensionValues.get(dimensionValues.size() - 1);
                boolean change = false;
                if (lastDimensionValue instanceof ManyReferenceValue) {
                    lastValue = (ManyReferenceValue)lastDimensionValue;
                    values = new ArrayList();
                    if (dynamicProperty.isPresent()) {
                        values = (List)dynamicProperty.get().getValue();
                    }
                    for (EObject eObj : values) {
                        this.addNewObjectToStateIfDynamic(eObj, newState);
                    }
                    if (lastValue != null && lastValue.getReferenceValues().size() == values.size()) {
                        Iterator it = values.iterator();
                        for (EObject aPreviousValue : lastValue.getReferenceValues()) {
                            EObject aCurrentValue;
                            if (aPreviousValue == this.exeToTraced.get(aCurrentValue = (EObject)it.next())) continue;
                            change = true;
                            break;
                        }
                    } else {
                        change = true;
                    }
                } else if (lastDimensionValue instanceof ManyStringAttributeValue) {
                    lastValue = (ManyStringAttributeValue)lastDimensionValue;
                    values = new ArrayList();
                    if (dynamicProperty.isPresent()) {
                        values = (List)dynamicProperty.get().getValue();
                    }
                    if (lastValue != null && lastValue.getAttributeValue().size() == values.size()) {
                        if (!lastValue.getAttributeValue().equals(values)) {
                            change = true;
                            break;
                        }
                    } else {
                        change = true;
                    }
                } else if (lastDimensionValue instanceof ManyIntegerAttributeValue) {
                    lastValue = (ManyIntegerAttributeValue)lastDimensionValue;
                    values = new ArrayList();
                    if (dynamicProperty.isPresent()) {
                        values = (List)dynamicProperty.get().getValue();
                    }
                    if (lastValue != null && lastValue.getAttributeValue().size() == values.size()) {
                        if (!lastValue.getAttributeValue().equals(values)) {
                            change = true;
                            break;
                        }
                    } else {
                        change = true;
                    }
                } else if (lastDimensionValue instanceof ManyBooleanAttributeValue) {
                    lastValue = (ManyBooleanAttributeValue)lastDimensionValue;
                    values = new ArrayList();
                    if (dynamicProperty.isPresent()) {
                        values = (List)dynamicProperty.get().getValue();
                    }
                    if (lastValue != null && lastValue.getAttributeValue().size() == values.size()) {
                        if (!lastValue.getAttributeValue().equals(values)) {
                            change = true;
                            break;
                        }
                    } else {
                        change = true;
                    }
                } else if (lastDimensionValue instanceof ManyDoubleAttributeValue) {
                    lastValue = (ManyDoubleAttributeValue)lastDimensionValue;
                    values = new ArrayList();
                    if (dynamicProperty.isPresent()) {
                        values = (List)dynamicProperty.get().getValue();
                    }
                    if (lastValue != null && lastValue.getAttributeValue().size() == values.size()) {
                        if (!lastValue.getAttributeValue().equals(values)) {
                            change = true;
                            break;
                        }
                    } else {
                        change = true;
                    }
                } else if (lastDimensionValue instanceof ManyLongAttributeValue) {
                    lastValue = (ManyLongAttributeValue)lastDimensionValue;
                    values = new ArrayList();
                    if (dynamicProperty.isPresent()) {
                        values = (List)dynamicProperty.get().getValue();
                    }
                    if (lastValue != null && lastValue.getAttributeValue().size() == values.size()) {
                        if (!lastValue.getAttributeValue().equals(values)) {
                            change = true;
                            break;
                        }
                    } else {
                        change = true;
                    }
                }
                if (!change) continue;
                stateChanged = true;
                newState.getValues().remove((Object)lastDimensionValue);
                GenericValue newValue = this.getGenericValue(o, p, newState);
                dimension.getValues().add((Object)newValue);
                newState.getValues().add((Object)newValue);
            }
            if (stateChanged) {
                GenericStep currentStep = (GenericStep)this.context.peekFirst();
                if (currentStep != null && currentStep instanceof BigStep) {
                    GenericState startingState = this.lastState;
                    GenericState endingState = newState;
                    this.addImplicitStep((BigStep<GenericStep, GenericState>)((BigStep)currentStep), startingState, endingState);
                }
                this.lastState = newState;
                this.traceRoot.getStates().add((Object)this.lastState);
            } else if (this.copiedState) {
                newState.getValues().clear();
            }
            this.copiedState = false;
        }
    }

    private void addImplicitStep(BigStep<GenericStep, GenericState> currentStep, GenericState startingState, GenericState endingState) {
        GenericSmallStep implicitStep = GenerictraceFactory.eINSTANCE.createGenericSmallStep();
        implicitStep.setStartingState((State)startingState);
        implicitStep.setEndingState((State)endingState);
        currentStep.getSubSteps().add((Object)implicitStep);
    }

    public void addStep(Step<?> step) {
        GenericSequentialStep step_cast = null;
        if (step != null && step instanceof GenericSequentialStep) {
            step_cast = (GenericSequentialStep)step;
            if (this.mseModel == null) {
                this.mseModel = TraceFactory.eINSTANCE.createMSEModel();
                this.traceResource.getContents().add((Object)this.mseModel);
            }
            this.mseModel.getOwnedMSEs().add((Object)step_cast.getMseoccurrence().getMse());
            this.mseModel.getOrphanOperations().add((Object)step_cast.getMseoccurrence().getMse().getAction());
            GenericState state = (GenericState)this.traceRoot.getStates().get(this.traceRoot.getStates().size() - 1);
            step_cast.setStartingState((State)state);
            if (!this.context.isEmpty() && this.context.getFirst() != null) {
                this.context.getFirst().getSubSteps().add((Object)step_cast);
            } else {
                ((GenericSequentialStep)this.traceRoot.getRootStep()).getSubSteps().add((Object)step_cast);
            }
        }
        this.context.push(step_cast);
    }

    public void endStep(Step<?> step) {
        GenericStep popped = (GenericStep)this.context.pop();
        if (popped != null) {
            popped.setEndingState((State)this.lastState);
        }
    }

    public EObject initTrace(LaunchConfiguration launchConfiguration) {
        this.traceRoot = GenerictraceFactory.eINSTANCE.createGenericTrace();
        this.traceRoot.setLaunchconfiguration(launchConfiguration);
        GenericSequentialStep rootStep = GenerictraceFactory.eINSTANCE.createGenericSequentialStep();
        this.traceRoot.setRootStep((Step)rootStep);
        this.traceResource.getContents().add(this.traceRoot);
        return this.traceRoot;
    }

    public void save() {
        try {
            this.traceResource.save(null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void save(URI uri) {
        try {
            this.traceResource.setURI(uri);
            this.traceResource.save(null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean isPartialTraceConstructor() {
        return false;
    }
}

