/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.ale.core.interpreter.internal;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.eclipse.acceleo.query.ast.Expression;
import org.eclipse.acceleo.query.parser.AstValidator;
import org.eclipse.acceleo.query.runtime.AcceleoQueryValidationException;
import org.eclipse.acceleo.query.runtime.EvaluationResult;
import org.eclipse.acceleo.query.runtime.IQueryBuilderEngine;
import org.eclipse.acceleo.query.runtime.IQueryEvaluationEngine;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IValidationMessage;
import org.eclipse.acceleo.query.runtime.IValidationResult;
import org.eclipse.acceleo.query.runtime.ValidationMessageLevel;
import org.eclipse.acceleo.query.runtime.impl.ValidationServices;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecoretools.ale.core.diagnostics.Operator;
import org.eclipse.emf.ecoretools.ale.core.diagnostics.impl.ConsoleDiagnosticsFormatter;
import org.eclipse.emf.ecoretools.ale.core.env.IAleEnvironment;
import org.eclipse.emf.ecoretools.ale.core.interpreter.CriticalFailureException;
import org.eclipse.emf.ecoretools.ale.core.interpreter.ServiceNotFoundException;
import org.eclipse.emf.ecoretools.ale.core.interpreter.internal.MessageToDiagnosticAdapter;
import org.eclipse.emf.ecoretools.ale.core.interpreter.internal.Messages;
import org.eclipse.emf.ecoretools.ale.core.interpreter.internal.Scopes;
import org.eclipse.emf.ecoretools.ale.core.interpreter.internal.impl.StackedScopes;
import org.eclipse.emf.ecoretools.ale.core.interpreter.notapi.DynamicFeatureRegistry;
import org.eclipse.emf.ecoretools.ale.core.parser.ParsedFile;
import org.eclipse.emf.ecoretools.ale.core.validation.IAstLookup;
import org.eclipse.emf.ecoretools.ale.core.validation.IConvertType;
import org.eclipse.emf.ecoretools.ale.core.validation.ITypeChecker;
import org.eclipse.emf.ecoretools.ale.core.validation.impl.AleValidator;
import org.eclipse.emf.ecoretools.ale.core.validation.impl.AstLookup;
import org.eclipse.emf.ecoretools.ale.core.validation.impl.ConvertType;
import org.eclipse.emf.ecoretools.ale.core.validation.impl.TypeChecker;
import org.eclipse.emf.ecoretools.ale.implementation.Attribute;
import org.eclipse.emf.ecoretools.ale.implementation.Block;
import org.eclipse.emf.ecoretools.ale.implementation.ConditionalBlock;
import org.eclipse.emf.ecoretools.ale.implementation.ExpressionStatement;
import org.eclipse.emf.ecoretools.ale.implementation.FeatureAssignment;
import org.eclipse.emf.ecoretools.ale.implementation.FeatureInsert;
import org.eclipse.emf.ecoretools.ale.implementation.FeaturePut;
import org.eclipse.emf.ecoretools.ale.implementation.FeatureRemove;
import org.eclipse.emf.ecoretools.ale.implementation.ForEach;
import org.eclipse.emf.ecoretools.ale.implementation.If;
import org.eclipse.emf.ecoretools.ale.implementation.ImplementationPackage;
import org.eclipse.emf.ecoretools.ale.implementation.Method;
import org.eclipse.emf.ecoretools.ale.implementation.ModelUnit;
import org.eclipse.emf.ecoretools.ale.implementation.Statement;
import org.eclipse.emf.ecoretools.ale.implementation.VariableAssignment;
import org.eclipse.emf.ecoretools.ale.implementation.VariableDeclaration;
import org.eclipse.emf.ecoretools.ale.implementation.VariableInsert;
import org.eclipse.emf.ecoretools.ale.implementation.VariableRemove;
import org.eclipse.emf.ecoretools.ale.implementation.While;

public class MethodEvaluator {
    public static final String ROOT_ERROR_MESSAGE = "AQL evaluation failed";
    public static final String AQL_ERROR = "An error occured during evaluation of a query";
    public static final String MTD_ERROR = "[Internal Error, please report] Can't eval null method on %s";
    private static final Object NO_VALUE_RETURNED = null;
    private IAleEnvironment environment;
    private IQueryEvaluationEngine aqlEngine;
    private DynamicFeatureRegistry dynamicFeatureAccess;
    private Scopes scopes;
    private IAstLookup lookup;
    private ITypeChecker types;
    private IConvertType convert;
    private AstValidator validator;
    private MessageToDiagnosticAdapter errors;
    private BasicDiagnostic diagnostic;

    public MethodEvaluator(IAleEnvironment environment, IQueryEvaluationEngine aqlEngine, DynamicFeatureRegistry dynamicFeatureAccess) {
        this.environment = Objects.requireNonNull(environment, "environment");
        this.aqlEngine = Objects.requireNonNull(aqlEngine, "aqlEngine");
        this.dynamicFeatureAccess = Objects.requireNonNull(dynamicFeatureAccess, "dynamicFeatureAccess");
        this.scopes = new StackedScopes();
        this.convert = new ConvertType((IReadOnlyQueryEnvironment)environment.getContext());
        this.lookup = new AstLookup(environment, this.scopes, this.convert);
        this.types = new TypeChecker(this.scopes, environment.getContext());
        this.validator = new AleValidator(new ValidationServices((IReadOnlyQueryEnvironment)environment.getContext()));
        this.errors = new MessageToDiagnosticAdapter(environment, new ConsoleDiagnosticsFormatter());
    }

    public EvaluationResult eval(EObject target, Method operation, List<Object> parameters) throws CriticalFailureException {
        this.diagnostic = new BasicDiagnostic();
        if (operation.getOperationRef() == null) {
            this.diagnostic.add((Diagnostic)this.errors.newDiagnostic(operation, String.format(MTD_ERROR, target)));
            this.stopExecution(ROOT_ERROR_MESSAGE);
            return null;
        }
        this.scopes.clear();
        Throwable throwable = null;
        Object var5_6 = null;
        try (Scopes.Scope methodScope = this.scopes.pushNew();){
            boolean isVoidMethod;
            methodScope.putValue("self", target);
            methodScope.putTypes("self", (Set<IType>)Sets.newHashSet((Object[])new IType[]{this.convert.toAQL((EClassifier)target.eClass())}));
            boolean bl = isVoidMethod = operation.getOperationRef().getEType() == null || operation.getOperationRef().getEType() == ImplementationPackage.eINSTANCE.getVoidEClassifier();
            if (!isVoidMethod) {
                methodScope.putTypes("result", (Set<IType>)Sets.newHashSet((Object[])new IType[]{this.convert.toAQL((ETypedElement)operation.getOperationRef())}));
            }
            EOperation opDefinition = operation.getOperationRef();
            int i = 0;
            while (i < opDefinition.getEParameters().size()) {
                EParameter param = (EParameter)opDefinition.getEParameters().get(i);
                methodScope.putValue(param.getName(), parameters.get(i));
                methodScope.putTypes(param.getName(), (Set<IType>)Sets.newHashSet((Object[])new IType[]{this.convert.toAQL((ETypedElement)param)}));
                ++i;
            }
            this.throwableSwitch(operation.getBody());
            if (!isVoidMethod && !methodScope.hasValue("result")) {
                this.diagnostic.add((Diagnostic)this.errors.missingReturnStatement(operation, this.scopes));
                this.stopExecution(ROOT_ERROR_MESSAGE);
            }
            return new EvaluationResult(methodScope.findValue("result").orElse(null), (Diagnostic)this.diagnostic);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public Object caseBlock(Block block) throws CriticalFailureException {
        for (Statement stmt : block.getStatements()) {
            this.throwableSwitch(stmt);
        }
        return NO_VALUE_RETURNED;
    }

    public Object caseVariableDeclaration(VariableDeclaration varDecl) throws CriticalFailureException {
        Object value;
        if (this.scopes.getCurrent().contains(varDecl.getName())) {
            this.diagnostic.add((Diagnostic)this.errors.alreadyBound(varDecl, this.scopes));
            this.stopExecution(ROOT_ERROR_MESSAGE);
        }
        if (varDecl.getInitialValue() == null) {
            value = this.defaultValueFor(varDecl).orElse(null);
            this.scopes.getCurrent().putTypes(varDecl.getName(), (Set<IType>)Sets.newHashSet((Object[])new IType[]{this.convert.toAQL(varDecl.getType())}));
        } else {
            Set<IType> valueTypes;
            IType variableType = this.convert.toAQL(varDecl.getType());
            boolean initialValueCanBeAssigned = this.types.isAssignable(variableType, valueTypes = this.validateAndStoreType(varDecl.getInitialValue()));
            if (!initialValueCanBeAssigned) {
                this.diagnostic.add((Diagnostic)this.errors.typeMismatch(varDecl, (Object)varDecl.getInitialValue(), (Set<IType>)Sets.newHashSet((Object[])new IType[]{variableType}), valueTypes));
                this.stopExecution(ROOT_ERROR_MESSAGE);
            }
            value = this.aqlEval(varDecl.getInitialValue());
            this.scopes.getCurrent().putTypes(varDecl.getName(), (Set<IType>)Sets.newHashSet((Object[])new IType[]{variableType}));
        }
        this.scopes.getCurrent().putValue(varDecl.getName(), value);
        return NO_VALUE_RETURNED;
    }

    private Optional<Object> defaultValueFor(VariableDeclaration varDecl) {
        if (varDecl.getType().isMany()) {
            return Optional.of(new BasicEList());
        }
        if (varDecl.getType().getEType() == EcorePackage.eINSTANCE.getEString()) {
            return Optional.of("");
        }
        if (varDecl.getType().getEType() == EcorePackage.eINSTANCE.getEInt()) {
            return Optional.of(0);
        }
        if (varDecl.getType().getEType() == EcorePackage.eINSTANCE.getEBoolean()) {
            return Optional.of(false);
        }
        return Optional.empty();
    }

    public Object caseVariableAssignment(VariableAssignment varAssign) throws CriticalFailureException {
        if (varAssign.getName().equals("self")) {
            this.diagnostic.add((Diagnostic)this.errors.assignmentToSelf(varAssign, this.scopes));
            this.stopExecution(ROOT_ERROR_MESSAGE);
        }
        if (!this.scopes.getCurrent().contains(varAssign.getName())) {
            this.diagnostic.add((Diagnostic)this.errors.variableNotFound(varAssign.getName(), varAssign, this.scopes));
            this.stopExecution(ROOT_ERROR_MESSAGE);
        }
        Set<IType> variableTypes = this.scopes.getCurrent().getTypes(varAssign.getName());
        Set<IType> valueTypes = varAssign.getValue() == null ? variableTypes : this.validateAndStoreType(varAssign.getValue());
        boolean valueCannotBeAssigned = variableTypes.stream().noneMatch(variableType -> this.types.isAssignable((IType)variableType, valueTypes));
        if (valueCannotBeAssigned) {
            this.diagnostic.add((Diagnostic)this.errors.typeMismatch(varAssign, (Object)varAssign.getValue(), variableTypes, valueTypes));
            this.stopExecution(ROOT_ERROR_MESSAGE);
        }
        Object value = this.aqlEval(varAssign.getValue());
        Optional<Scopes.Scope> declaringScope = this.scopes.getDeclaringScope(varAssign.getName());
        declaringScope.ifPresent(scope -> scope.putValue(varAssign.getName(), value));
        return NO_VALUE_RETURNED;
    }

    public Object caseFeatureAssignment(FeatureAssignment featAssign) throws CriticalFailureException {
        EReference oppositeRef;
        Optional<Attribute> featureDef;
        boolean valueCannotBeAssigned;
        Object rawOwner = this.aqlEval(featAssign.getTarget());
        if (!(rawOwner instanceof EObject)) {
            this.stopExecution(ROOT_ERROR_MESSAGE);
        }
        this.validateAndStoreType(featAssign.getTarget());
        Set<IType> variableTypes = this.lookup.findFeatureTypes(featAssign.getTargetFeature(), featAssign.getTarget());
        Set<IType> valueTypes = featAssign.getValue() == null ? variableTypes : this.validateAndStoreType(featAssign.getValue());
        EObject owner = (EObject)rawOwner;
        if (variableTypes.isEmpty()) {
            this.diagnostic.add((Diagnostic)this.errors.attributeNotFound(featAssign.getTargetFeature(), featAssign, owner.eClass(), this.scopes));
            this.stopExecution(ROOT_ERROR_MESSAGE);
        }
        if (valueCannotBeAssigned = variableTypes.stream().noneMatch(variableType -> this.types.isAssignable((IType)variableType, valueTypes))) {
            this.diagnostic.add((Diagnostic)this.errors.typeMismatch(featAssign, (Object)featAssign.getValue(), variableTypes, valueTypes));
            this.stopExecution(ROOT_ERROR_MESSAGE);
        }
        Object value = this.aqlEval(featAssign.getValue());
        EStructuralFeature feature = owner.eClass().getEStructuralFeature(featAssign.getTargetFeature());
        if (feature != null) {
            if (value instanceof Collection) {
                BasicEList newList = new BasicEList((Collection)value);
                owner.eSet(feature, (Object)newList);
            } else {
                owner.eSet(feature, value);
            }
        } else if (value instanceof Collection) {
            this.dynamicFeatureAccess.setDynamicFeatureValue(owner, featAssign.getTargetFeature(), new BasicEList((Collection)value));
        } else {
            this.dynamicFeatureAccess.setDynamicFeatureValue(owner, featAssign.getTargetFeature(), value);
        }
        if (value instanceof EObject && feature instanceof EReference) {
            EReference oppositeRef2 = ((EReference)feature).getEOpposite();
            if (oppositeRef2 != null) {
                EStructuralFeature opFeat = ((EObject)value).eClass().getEStructuralFeature(oppositeRef2.getName());
                if (opFeat != null) {
                    ((EObject)value).eSet(opFeat, (Object)owner);
                } else {
                    this.dynamicFeatureAccess.setDynamicFeatureValue((EObject)value, oppositeRef2.getName(), owner);
                }
            }
        } else if (value instanceof EObject && feature == null && (featureDef = this.dynamicFeatureAccess.findFeature(owner.eClass(), featAssign.getTargetFeature())).isPresent() && featureDef.get().getFeatureRef() instanceof EReference && (oppositeRef = ((EReference)featureDef.get().getFeatureRef()).getEOpposite()) != null) {
            EStructuralFeature opFeat = ((EObject)value).eClass().getEStructuralFeature(oppositeRef.getName());
            if (opFeat != null) {
                ((EObject)value).eSet(opFeat, (Object)owner);
            } else {
                this.dynamicFeatureAccess.setDynamicFeatureValue((EObject)value, oppositeRef.getName(), owner);
            }
        }
        return NO_VALUE_RETURNED;
    }

    public Object caseVariableInsert(VariableInsert varInsert) throws CriticalFailureException {
        boolean valueCanBeAssigned;
        if (!this.scopes.getCurrent().contains(varInsert.getName())) {
            this.diagnostic.add((Diagnostic)this.errors.variableNotFound(varInsert.getName(), varInsert, this.scopes));
            this.stopExecution(ROOT_ERROR_MESSAGE);
        }
        Set<IType> variableTypes = this.scopes.getCurrent().getTypes(varInsert.getName());
        Set<IType> valueTypes = varInsert.getValue() == null ? variableTypes : this.validateAndStoreType(varInsert.getValue());
        boolean supportsInsertion = variableTypes.stream().anyMatch(this.types::supportsInsertion);
        if (!supportsInsertion) {
            this.diagnostic.add((Diagnostic)this.errors.unsupportedOperator(varInsert, varInsert.getName(), variableTypes, Operator.ADDITION_ASSIGNMENT, this.scopes));
            this.stopExecution(ROOT_ERROR_MESSAGE);
        }
        if (!(valueCanBeAssigned = this.types.acceptsInsertion(variableTypes, valueTypes))) {
            this.diagnostic.add((Diagnostic)this.errors.typeMismatch(varInsert, (Object)varInsert.getValue(), variableTypes, valueTypes));
            this.stopExecution(ROOT_ERROR_MESSAGE);
        }
        Object insertedValue = this.aqlEval(varInsert.getValue());
        Object variableValue = this.scopes.getCurrent().getValue(varInsert.getName());
        if (variableValue instanceof Collection) {
            if (insertedValue instanceof Collection) {
                ((Collection)variableValue).addAll((Collection)insertedValue);
            } else {
                ((Collection)variableValue).add(insertedValue);
            }
        } else if (variableValue instanceof String) {
            String concatenated = "" + variableValue + insertedValue;
            Optional<Scopes.Scope> declaringScope = this.scopes.getDeclaringScope(varInsert.getName());
            declaringScope.ifPresent(scope -> scope.putValue(varInsert.getName(), concatenated));
        } else if (variableValue instanceof Integer && insertedValue instanceof Number) {
            Integer sum = (Integer)variableValue + ((Number)insertedValue).intValue();
            Optional<Scopes.Scope> declaringScope = this.scopes.getDeclaringScope(varInsert.getName());
            declaringScope.ifPresent(scope -> scope.putValue(varInsert.getName(), sum));
        } else if (variableValue instanceof Double && insertedValue instanceof Number) {
            Double sum = (Double)variableValue + ((Number)insertedValue).doubleValue();
            Optional<Scopes.Scope> declaringScope = this.scopes.getDeclaringScope(varInsert.getName());
            declaringScope.ifPresent(scope -> scope.putValue(varInsert.getName(), sum));
        } else {
            throw new CriticalFailureException("Operator `+=` not implemented for variable=" + Messages.repr(variableTypes) + " value=" + Messages.repr(valueTypes), this.diagnostic);
        }
        return NO_VALUE_RETURNED;
    }

    public Object caseVariableRemove(VariableRemove varRemove) throws CriticalFailureException {
        boolean valueCanBeAssigned;
        if (!this.scopes.getCurrent().contains(varRemove.getName())) {
            this.diagnostic.add((Diagnostic)this.errors.variableNotFound(varRemove.getName(), varRemove, this.scopes));
            this.stopExecution(ROOT_ERROR_MESSAGE);
        }
        Set<IType> variableTypes = this.scopes.getCurrent().getTypes(varRemove.getName());
        Set<IType> valueTypes = varRemove.getValue() == null ? variableTypes : this.validateAndStoreType(varRemove.getValue());
        boolean supportsRemoval = variableTypes.stream().anyMatch(this.types::supportsRemoval);
        if (!supportsRemoval) {
            this.diagnostic.add((Diagnostic)this.errors.unsupportedOperator(varRemove, varRemove.getName(), variableTypes, Operator.SUBSTRACTION_ASSIGNMENT, this.scopes));
            this.stopExecution(ROOT_ERROR_MESSAGE);
        }
        if (!(valueCanBeAssigned = this.types.acceptsRemoval(variableTypes, valueTypes))) {
            this.diagnostic.add((Diagnostic)this.errors.typeMismatch(varRemove, (Object)varRemove.getValue(), variableTypes, valueTypes));
            this.stopExecution(ROOT_ERROR_MESSAGE);
        }
        Object removedValue = this.aqlEval(varRemove.getValue());
        Object variableValue = this.scopes.getCurrent().getValue(varRemove.getName());
        if (variableValue instanceof Collection) {
            if (removedValue instanceof Collection) {
                ((Collection)variableValue).removeAll((Collection)removedValue);
            } else {
                ((Collection)variableValue).remove(removedValue);
            }
        } else if (variableValue instanceof Integer && removedValue instanceof Integer) {
            Integer substraction = (Integer)variableValue - (Integer)removedValue;
            this.scopes.getCurrent().putValue(varRemove.getName(), substraction);
        } else {
            throw new CriticalFailureException("Operator `-=` not implemented for variable=" + Messages.repr(variableTypes) + " value=" + Messages.repr(valueTypes), this.diagnostic);
        }
        return NO_VALUE_RETURNED;
    }

    public Object caseFeatureInsert(FeatureInsert featInsert) throws CriticalFailureException {
        boolean valueCanBeAssigned;
        Object rawOwner = this.aqlEval(featInsert.getTarget());
        if (!(rawOwner instanceof EObject)) {
            this.stopExecution(ROOT_ERROR_MESSAGE);
        }
        this.validateAndStoreType(featInsert.getTarget());
        Set<IType> variableTypes = this.lookup.findFeatureTypes(featInsert.getTargetFeature(), featInsert.getTarget());
        Set<IType> valueTypes = featInsert.getValue() == null ? variableTypes : this.validateAndStoreType(featInsert.getValue());
        EObject owner = (EObject)rawOwner;
        if (variableTypes.isEmpty()) {
            this.diagnostic.add((Diagnostic)this.errors.attributeNotFound(featInsert.getTargetFeature(), featInsert, owner.eClass(), this.scopes));
            this.stopExecution(ROOT_ERROR_MESSAGE);
        }
        boolean supportsInsertion = variableTypes.stream().anyMatch(this.types::supportsInsertion);
        if (!supportsInsertion) {
            this.diagnostic.add((Diagnostic)this.errors.unsupportedOperator(featInsert, featInsert.getTargetFeature(), variableTypes, Operator.ADDITION_ASSIGNMENT, this.scopes));
            this.stopExecution(ROOT_ERROR_MESSAGE);
        }
        if (!(valueCanBeAssigned = this.types.acceptsInsertion(variableTypes, valueTypes))) {
            this.diagnostic.add((Diagnostic)this.errors.typeMismatch(featInsert, (Object)featInsert.getValue(), variableTypes, valueTypes));
            this.stopExecution(ROOT_ERROR_MESSAGE);
        }
        Object inserted = this.aqlEval(featInsert.getValue());
        EStructuralFeature feature = owner.eClass().getEStructuralFeature(featInsert.getTargetFeature());
        if (feature != null) {
            Object featureValue = owner.eGet(feature);
            if (featureValue instanceof Collection) {
                if (inserted instanceof Collection) {
                    ((Collection)featureValue).addAll((Collection)inserted);
                } else {
                    ((Collection)featureValue).add(inserted);
                }
            } else if (featureValue instanceof String) {
                String concat = "" + featureValue + inserted;
                ((EObject)rawOwner).eSet(feature, (Object)concat);
            } else if (featureValue instanceof Integer && inserted instanceof Number) {
                Integer sum = (Integer)featureValue + ((Number)inserted).intValue();
                owner.eSet(feature, (Object)sum);
            } else if (featureValue instanceof Double && inserted instanceof Number) {
                Double sum = (Double)featureValue + ((Number)inserted).doubleValue();
                owner.eSet(feature, (Object)sum);
            }
        } else {
            this.dynamicFeatureAccess.insertDynamicFeatureValue(owner, featInsert.getTargetFeature(), inserted);
        }
        return NO_VALUE_RETURNED;
    }

    public Object caseFeatureRemove(FeatureRemove featRemove) throws CriticalFailureException {
        boolean valueCanBeAssigned;
        Object rawOwner = this.aqlEval(featRemove.getTarget());
        if (!(rawOwner instanceof EObject)) {
            this.stopExecution(ROOT_ERROR_MESSAGE);
        }
        this.validateAndStoreType(featRemove.getTarget());
        Set<IType> variableTypes = this.lookup.findFeatureTypes(featRemove.getTargetFeature(), featRemove.getTarget());
        Set<IType> valueTypes = featRemove.getValue() == null ? variableTypes : this.validateAndStoreType(featRemove.getValue());
        EObject owner = (EObject)rawOwner;
        if (variableTypes.isEmpty()) {
            this.diagnostic.add((Diagnostic)this.errors.attributeNotFound(featRemove.getTargetFeature(), featRemove, owner.eClass(), this.scopes));
            this.stopExecution(ROOT_ERROR_MESSAGE);
        }
        boolean supportsRemove = variableTypes.stream().anyMatch(this.types::supportsRemoval);
        if (!supportsRemove) {
            this.diagnostic.add((Diagnostic)this.errors.unsupportedOperator(featRemove, featRemove.getTargetFeature(), variableTypes, Operator.SUBSTRACTION_ASSIGNMENT, this.scopes));
            this.stopExecution(ROOT_ERROR_MESSAGE);
        }
        if (!(valueCanBeAssigned = this.types.acceptsRemoval(variableTypes, valueTypes))) {
            this.diagnostic.add((Diagnostic)this.errors.typeMismatch(featRemove, (Object)featRemove.getValue(), variableTypes, valueTypes));
            this.stopExecution(ROOT_ERROR_MESSAGE);
        }
        Object removed = this.aqlEval(featRemove.getValue());
        EStructuralFeature feature = owner.eClass().getEStructuralFeature(featRemove.getTargetFeature());
        if (feature != null) {
            Object featureValue = owner.eGet(feature);
            if (featureValue instanceof Collection) {
                if (removed instanceof Collection) {
                    ((Collection)featureValue).removeAll((Collection)removed);
                } else {
                    ((Collection)featureValue).remove(removed);
                }
            } else if (featureValue instanceof Integer && removed instanceof Number) {
                Integer substraction = (Integer)featureValue - ((Number)removed).intValue();
                owner.eSet(feature, (Object)substraction);
            } else if (featureValue instanceof Double && removed instanceof Number) {
                Double substraction = (Double)featureValue - ((Number)removed).doubleValue();
                owner.eSet(feature, (Object)substraction);
            }
        } else {
            this.dynamicFeatureAccess.removeDynamicFeatureValue(owner, featRemove.getTargetFeature(), removed);
        }
        return NO_VALUE_RETURNED;
    }

    public Object caseFeaturePut(FeaturePut featPut) throws CriticalFailureException {
        EStructuralFeature feature;
        Object featureValue;
        Object assigned = this.aqlEval(featPut.getTarget());
        Object key = this.aqlEval(featPut.getKey());
        Object value = this.aqlEval(featPut.getValue());
        if (assigned instanceof EObject && (featureValue = ((EObject)assigned).eGet(feature = ((EObject)assigned).eClass().getEStructuralFeature(featPut.getTargetFeature()))) instanceof EMap) {
            ((EMap)featureValue).put(key, value);
        }
        return null;
    }

    public Object caseForEach(ForEach forEach) throws CriticalFailureException {
        if (this.scopes.getCurrent().contains(forEach.getVariable())) {
            this.diagnostic.add((Diagnostic)this.errors.alreadyBound(forEach, this.scopes));
            this.stopExecution(ROOT_ERROR_MESSAGE);
        }
        Set<IType> collectionTypes = this.validateAndStoreType(forEach.getCollectionExpression());
        if (collectionTypes.stream().noneMatch(this.types::isCollection)) {
            this.diagnostic.add((Diagnostic)this.errors.notIterable(forEach, collectionTypes, this.scopes));
            this.stopExecution(ROOT_ERROR_MESSAGE);
        }
        Object iterable = this.aqlEval(forEach.getCollectionExpression());
        Collection iterableElements = (Collection)iterable;
        for (Object currentElement : iterableElements) {
            Throwable throwable = null;
            Object var9_9 = null;
            try (Scopes.Scope newScope = this.scopes.pushNew();){
                newScope.putVariable(forEach.getVariable(), collectionTypes, currentElement);
                this.throwableSwitch(forEach.getBody());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return NO_VALUE_RETURNED;
    }

    public Object caseWhile(While loop) throws CriticalFailureException {
        Set<IType> conditionTypes = this.validateAndStoreType(loop.getCondition());
        if (conditionTypes.stream().noneMatch(this.types::isBoolean)) {
            this.diagnostic.add((Diagnostic)this.errors.typeMismatch(loop, (Object)loop.getCondition(), (Set<IType>)Sets.newHashSet((Object[])new IType[]{this.convert.toAQL((EClassifier)EcorePackage.eINSTANCE.getEBoolean())}), conditionTypes));
            this.stopExecution(ROOT_ERROR_MESSAGE);
        }
        boolean conditionValue = (Boolean)this.aqlEval(loop.getCondition());
        while (conditionValue) {
            this.throwableSwitch(loop.getBody());
            conditionValue = (Boolean)this.aqlEval(loop.getCondition());
        }
        return NO_VALUE_RETURNED;
    }

    public Object caseIf(If ifStmt) throws CriticalFailureException {
        Block selectedBlock = null;
        for (ConditionalBlock conditionalBlock : ifStmt.getBlocks()) {
            boolean condition;
            Set<IType> conditionTypes = this.validateAndStoreType(conditionalBlock.getCondition());
            if (conditionTypes.stream().noneMatch(this.types::isBoolean)) {
                this.diagnostic.add((Diagnostic)this.errors.typeMismatch(ifStmt, (Object)conditionalBlock, (Set<IType>)Sets.newHashSet((Object[])new IType[]{this.convert.toAQL((EClassifier)EcorePackage.eINSTANCE.getEBoolean())}), conditionTypes));
                this.stopExecution(ROOT_ERROR_MESSAGE);
            }
            if (!(condition = ((Boolean)this.aqlEval(conditionalBlock.getCondition())).booleanValue())) continue;
            selectedBlock = conditionalBlock.getBlock();
            break;
        }
        if (selectedBlock != null) {
            this.throwableSwitch(selectedBlock);
        } else if (ifStmt.getElse() != null) {
            this.throwableSwitch(ifStmt.getElse());
        }
        return NO_VALUE_RETURNED;
    }

    public Object caseExpressionStatement(ExpressionStatement stmt) throws CriticalFailureException {
        return this.aqlEval(stmt.getExpression());
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private Object aqlEval(Expression expression) throws CriticalFailureException {
        block4: {
            dummyAstResult = new IQueryBuilderEngine.AstResult(expression, new HashMap<K, V>(), new HashMap<K, V>(), new ArrayList<E>(), (Diagnostic)new BasicDiagnostic());
            try {
                result = this.aqlEngine.eval(dummyAstResult, this.scopes.getCurrent().getVariableValues());
                break block4;
            }
            catch (Exception e) {
                t /* !! */  = e;
                ** while (t /* !! */ .getCause() != null)
            }
lbl-1000:
            // 1 sources

            {
                if (!((t /* !! */  = t /* !! */ .getCause()) instanceof ServiceNotFoundException)) continue;
                notFound = (ServiceNotFoundException)t /* !! */ ;
                this.diagnostic.add((Diagnostic)this.errors.methodNotFound(expression, notFound, this.scopes));
                this.stopExecution("AQL evaluation failed");
                continue;
            }
lbl13:
            // 1 sources

            throw e;
        }
        if (result.getDiagnostic().getSeverity() != 0) {
            child = new BasicDiagnostic(result.getDiagnostic().getSeverity(), "org.eclipse.emf.ecoretools.ale.core", 0, "An error occured during evaluation of a query", new Object[]{expression, result.getDiagnostic()});
            this.diagnostic.add((Diagnostic)child);
            this.stopExecution("AQL evaluation failed");
        }
        return result.getResult();
    }

    private Set<IType> validateAndStoreType(Expression expression) throws CriticalFailureException {
        IValidationResult validation = this.validate(expression);
        Set inferredTypes = validation.getPossibleTypes(expression);
        inferredTypes = inferredTypes == null ? new HashSet() : inferredTypes;
        for (IValidationMessage message : validation.getMessages()) {
            if (message.getLevel() != ValidationMessageLevel.ERROR) continue;
            this.diagnostic.add((Diagnostic)this.errors.newDiagnostic(expression, message.getMessage()));
        }
        this.scopes.getCurrent().putTypes(expression, (Set<IType>)inferredTypes);
        return inferredTypes;
    }

    private IValidationResult validate(Expression exp) throws CriticalFailureException {
        try {
            ParsedFile<ModelUnit> file = this.findSourceFile(exp).orElseThrow(() -> new IllegalArgumentException("Cannot find file defining " + exp));
            IQueryBuilderEngine.AstResult fakeAst = new IQueryBuilderEngine.AstResult(exp, file.getStartPositions(), file.getEndPositions(), new ArrayList(), (Diagnostic)new BasicDiagnostic());
            return this.validator.validate(this.scopes.getCurrent().getVariableTypes(), fakeAst);
        }
        catch (AcceleoQueryValidationException e) {
            this.diagnostic.add((Diagnostic)this.errors.internalError(exp, e));
            this.stopExecution(ROOT_ERROR_MESSAGE);
            return null;
        }
    }

    private Optional<ParsedFile<ModelUnit>> findSourceFile(Expression exp) {
        Expression element = exp;
        while (element != null) {
            Optional<ParsedFile<ModelUnit>> file = this.environment.getBehaviors().findParsedFileDefining(element);
            if (file.isPresent()) {
                return file;
            }
            element = element.eContainer();
        }
        return Optional.empty();
    }

    private void stopExecution(String message) throws CriticalFailureException {
        throw new CriticalFailureException(message, this.diagnostic);
    }

    private Object throwableSwitch(Object obj) throws CriticalFailureException {
        if (obj instanceof Block) {
            return this.caseBlock((Block)obj);
        }
        if (obj instanceof ExpressionStatement) {
            return this.caseExpressionStatement((ExpressionStatement)obj);
        }
        if (obj instanceof FeatureAssignment) {
            return this.caseFeatureAssignment((FeatureAssignment)obj);
        }
        if (obj instanceof FeatureInsert) {
            return this.caseFeatureInsert((FeatureInsert)obj);
        }
        if (obj instanceof FeaturePut) {
            return this.caseFeaturePut((FeaturePut)obj);
        }
        if (obj instanceof FeatureRemove) {
            return this.caseFeatureRemove((FeatureRemove)obj);
        }
        if (obj instanceof ForEach) {
            return this.caseForEach((ForEach)obj);
        }
        if (obj instanceof If) {
            return this.caseIf((If)obj);
        }
        if (obj instanceof VariableAssignment) {
            return this.caseVariableAssignment((VariableAssignment)obj);
        }
        if (obj instanceof VariableDeclaration) {
            return this.caseVariableDeclaration((VariableDeclaration)obj);
        }
        if (obj instanceof VariableInsert) {
            return this.caseVariableInsert((VariableInsert)obj);
        }
        if (obj instanceof VariableRemove) {
            return this.caseVariableRemove((VariableRemove)obj);
        }
        if (obj instanceof While) {
            return this.caseWhile((While)obj);
        }
        return null;
    }
}

