/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.ale.core.validation;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.eclipse.emf.ecoretools.ale.core.Activator;
import org.eclipse.emf.ecoretools.ale.core.diagnostics.Message;
import org.eclipse.emf.ecoretools.ale.core.validation.BaseValidator;
import org.eclipse.emf.ecoretools.ale.core.validation.IValidator;
import org.eclipse.emf.ecoretools.ale.implementation.ExtendedClass;
import org.eclipse.emf.ecoretools.ale.implementation.FeatureAssignment;
import org.eclipse.emf.ecoretools.ale.implementation.FeatureInsert;
import org.eclipse.emf.ecoretools.ale.implementation.FeatureRemove;
import org.eclipse.emf.ecoretools.ale.implementation.ForEach;
import org.eclipse.emf.ecoretools.ale.implementation.If;
import org.eclipse.emf.ecoretools.ale.implementation.Method;
import org.eclipse.emf.ecoretools.ale.implementation.ModelUnit;
import org.eclipse.emf.ecoretools.ale.implementation.RuntimeClass;
import org.eclipse.emf.ecoretools.ale.implementation.VariableAssignment;
import org.eclipse.emf.ecoretools.ale.implementation.VariableDeclaration;
import org.eclipse.emf.ecoretools.ale.implementation.VariableInsert;
import org.eclipse.emf.ecoretools.ale.implementation.VariableRemove;
import org.eclipse.emf.ecoretools.ale.implementation.While;

public final class SafeValidator
implements IValidator {
    private final IValidator unsafeValidator;

    public SafeValidator(IValidator validator) {
        this.unsafeValidator = Objects.requireNonNull(validator, "validator");
    }

    @Override
    public void setBase(BaseValidator baseValidator) {
        this.unsafeValidator.setBase(baseValidator);
    }

    @Override
    public List<Message> validateModelBehavior(List<ModelUnit> units) {
        try {
            return this.unsafeValidator.validateModelBehavior(units);
        }
        catch (Exception e) {
            Activator.error("An internal error occurred while validating ModelBehavior: " + units, e);
            return Collections.emptyList();
        }
    }

    @Override
    public List<Message> validateModelUnit(ModelUnit unit) {
        try {
            return this.unsafeValidator.validateModelUnit(unit);
        }
        catch (Exception e) {
            Activator.error("An internal error occurred while validating ModelUnit: " + unit, e);
            return Collections.emptyList();
        }
    }

    @Override
    public List<Message> validateExtendedClass(ExtendedClass xtdClass) {
        try {
            return this.unsafeValidator.validateExtendedClass(xtdClass);
        }
        catch (Exception e) {
            Activator.error("An internal error occurred while validating ExtendedClass: " + xtdClass, e);
            return Collections.emptyList();
        }
    }

    @Override
    public List<Message> validateRuntimeClass(RuntimeClass classDef) {
        try {
            return this.unsafeValidator.validateRuntimeClass(classDef);
        }
        catch (Exception e) {
            Activator.error("An internal error occurred while validating RuntimeClass: " + classDef, e);
            return Collections.emptyList();
        }
    }

    @Override
    public List<Message> validateMethod(Method mtd) {
        try {
            return this.unsafeValidator.validateMethod(mtd);
        }
        catch (Exception e) {
            Activator.error("An internal error occurred while validating Method: " + mtd, e);
            return Collections.emptyList();
        }
    }

    @Override
    public List<Message> validateFeatureAssignment(FeatureAssignment featAssign) {
        try {
            return this.unsafeValidator.validateFeatureAssignment(featAssign);
        }
        catch (Exception e) {
            Activator.error("An internal error occurred while validating FeatureAssignment: " + featAssign, e);
            return Collections.emptyList();
        }
    }

    @Override
    public List<Message> validateFeatureInsert(FeatureInsert featInsert) {
        try {
            return this.unsafeValidator.validateFeatureInsert(featInsert);
        }
        catch (Exception e) {
            Activator.error("An internal error occurred while validating FeatureInsert: " + featInsert, e);
            return Collections.emptyList();
        }
    }

    @Override
    public List<Message> validateFeatureRemove(FeatureRemove featRemove) {
        try {
            return this.unsafeValidator.validateFeatureRemove(featRemove);
        }
        catch (Exception e) {
            Activator.error("An internal error occurred while validating FeatureRemove: " + featRemove, e);
            return Collections.emptyList();
        }
    }

    @Override
    public List<Message> validateVariableAssignment(VariableAssignment varAssign) {
        try {
            return this.unsafeValidator.validateVariableAssignment(varAssign);
        }
        catch (Exception e) {
            Activator.error("An internal error occurred while validating VariableAssignment: " + varAssign, e);
            return Collections.emptyList();
        }
    }

    @Override
    public List<Message> validateVariableDeclaration(VariableDeclaration varDecl) {
        try {
            return this.unsafeValidator.validateVariableDeclaration(varDecl);
        }
        catch (Exception e) {
            Activator.error("An internal error occurred while validating VariableDeclaration: " + varDecl, e);
            return Collections.emptyList();
        }
    }

    @Override
    public List<Message> validateVariableInsert(VariableInsert varInsert) {
        try {
            return this.unsafeValidator.validateVariableInsert(varInsert);
        }
        catch (Exception e) {
            Activator.error("An internal error occurred while validating VariableInsert: " + varInsert, e);
            return Collections.emptyList();
        }
    }

    @Override
    public List<Message> validateVariableRemove(VariableRemove varRemove) {
        try {
            return this.unsafeValidator.validateVariableRemove(varRemove);
        }
        catch (Exception e) {
            Activator.error("An internal error occurred while validating VariableRemove: " + varRemove, e);
            return Collections.emptyList();
        }
    }

    @Override
    public List<Message> validateForEach(ForEach loop) {
        try {
            return this.unsafeValidator.validateForEach(loop);
        }
        catch (Exception e) {
            Activator.error("An internal error occurred while validating ForEach: " + loop, e);
            return Collections.emptyList();
        }
    }

    @Override
    public List<Message> validateIf(If ifStmt) {
        try {
            return this.unsafeValidator.validateIf(ifStmt);
        }
        catch (Exception e) {
            Activator.error("An internal error occurred while validating If: " + ifStmt, e);
            return Collections.emptyList();
        }
    }

    @Override
    public List<Message> validateWhile(While loop) {
        try {
            return this.unsafeValidator.validateWhile(loop);
        }
        catch (Exception e) {
            Activator.error("An internal error occurred while validating While: " + loop, e);
            return Collections.emptyList();
        }
    }
}

