/**
 * Copyright (c) 2017 Inria and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Inria - initial API and implementation
 */
package fr.inria.diverse.melange.compiler;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import fr.inria.diverse.melange.lib.IMetamodel;
import fr.inria.diverse.melange.lib.IModelType;
import fr.inria.diverse.melange.metamodel.melange.ModelType;
import fr.inria.diverse.melange.typesystem.MelangeTypesRegistry;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.xbase.XCastedExpression;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.compiler.XbaseCompiler;
import org.eclipse.xtext.xbase.compiler.output.ITreeAppendable;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;

/**
 * Specializes the type system and the code generator of Xbase to emulate
 * model-oriented object manipulation in the code of {@link XbaseTransformation}s.
 * 
 * @deprecated Shouldn't be used anymore as {@link XbaseTransformation}s will
 * eventually disappear from Melange.
 */
@SuppressWarnings("all")
public class ModelOrientedXbaseCompiler extends XbaseCompiler {
  @Inject
  @Extension
  private IQualifiedNameProvider _iQualifiedNameProvider;
  
  @Inject
  private MelangeTypesRegistry typesRegistry;
  
  /**
   * Whenever we can't find a match between expected and returned modeltypes,
   * let's see if we have an adapter for that purpose
   */
  @Override
  public void internalToConvertedExpression(final XExpression expr, final ITreeAppendable appendable) {
    final LightweightTypeReference expected = this.getLightweightExpectedType(expr);
    final LightweightTypeReference returned = this.getLightweightReturnType(expr);
    final boolean wrap = ((((expected != null) && (returned != null)) && (!Objects.equal(expected.getIdentifier(), returned.getIdentifier()))) && expected.isSubtypeOf(IModelType.class));
    final boolean isImplements = ((wrap && returned.isSubtypeOf(IMetamodel.class)) && IterableExtensions.<ModelType>exists(this.typesRegistry.getImplementations(returned.getIdentifier()), new Function1<ModelType, Boolean>() {
      @Override
      public Boolean apply(final ModelType it) {
        String _string = ModelOrientedXbaseCompiler.this._iQualifiedNameProvider.getFullyQualifiedName(it).toString();
        String _identifier = expected.getIdentifier();
        return Boolean.valueOf(Objects.equal(_string, _identifier));
      }
    }));
    final boolean isSubtype = ((wrap && returned.isSubtypeOf(IModelType.class)) && IterableExtensions.<ModelType>exists(this.typesRegistry.getSubtypings(returned.getIdentifier()), new Function1<ModelType, Boolean>() {
      @Override
      public Boolean apply(final ModelType it) {
        String _string = ModelOrientedXbaseCompiler.this._iQualifiedNameProvider.getFullyQualifiedName(it).toString();
        String _identifier = expected.getIdentifier();
        return Boolean.valueOf(Objects.equal(_string, _identifier));
      }
    }));
    if (isSubtype) {
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("((fr.inria.diverse.melange.lib.GenericAdapter<XXX>) ");
      appendable.append(_builder);
    }
    super.internalToConvertedExpression(expr, appendable);
    if (isImplements) {
      final Function1<ModelType, Boolean> _function = new Function1<ModelType, Boolean>() {
        @Override
        public Boolean apply(final ModelType it) {
          String _string = ModelOrientedXbaseCompiler.this._iQualifiedNameProvider.getFullyQualifiedName(it).toString();
          String _identifier = expected.getIdentifier();
          return Boolean.valueOf(Objects.equal(_string, _identifier));
        }
      };
      final ModelType match = IterableExtensions.<ModelType>findFirst(this.typesRegistry.getImplementations(returned.getIdentifier()), _function);
      StringConcatenation _builder_1 = new StringConcatenation();
      _builder_1.append(".to");
      String _name = match.getName();
      _builder_1.append(_name);
      _builder_1.append("()");
      appendable.append(_builder_1);
    } else {
      if (isSubtype) {
        final Function1<ModelType, Boolean> _function_1 = new Function1<ModelType, Boolean>() {
          @Override
          public Boolean apply(final ModelType it) {
            String _string = ModelOrientedXbaseCompiler.this._iQualifiedNameProvider.getFullyQualifiedName(it).toString();
            String _identifier = expected.getIdentifier();
            return Boolean.valueOf(Objects.equal(_string, _identifier));
          }
        };
        final ModelType match_1 = IterableExtensions.<ModelType>findFirst(this.typesRegistry.getSubtypings(returned.getIdentifier()), _function_1);
        StringConcatenation _builder_2 = new StringConcatenation();
        _builder_2.append(").getAdaptee().to");
        String _name_1 = match_1.getName();
        _builder_2.append(_name_1);
        _builder_2.append("()");
        appendable.append(_builder_2);
      }
    }
  }
  
  /**
   * If the cast operation involves metamodels and modeltypes,
   * let's use the appropriate adapters
   */
  @Override
  public void _toJavaExpression(final XCastedExpression expr, final ITreeAppendable b) {
    final LightweightTypeReference type = this.getLightweightType(expr.getTarget());
    final LightweightTypeReference expectedType = this.getLightweightType(expr);
    if (((expectedType.isSubtypeOf(IModelType.class) && type.isSubtypeOf(IMetamodel.class)) && IterableExtensions.<ModelType>exists(this.typesRegistry.getImplementations(type.getIdentifier()), new Function1<ModelType, Boolean>() {
      @Override
      public Boolean apply(final ModelType it) {
        String _string = ModelOrientedXbaseCompiler.this._iQualifiedNameProvider.getFullyQualifiedName(it).toString();
        String _identifier = expectedType.getIdentifier();
        return Boolean.valueOf(Objects.equal(_string, _identifier));
      }
    }))) {
      final Function1<ModelType, Boolean> _function = new Function1<ModelType, Boolean>() {
        @Override
        public Boolean apply(final ModelType it) {
          String _string = ModelOrientedXbaseCompiler.this._iQualifiedNameProvider.getFullyQualifiedName(it).toString();
          String _identifier = expectedType.getIdentifier();
          return Boolean.valueOf(Objects.equal(_string, _identifier));
        }
      };
      final ModelType match = IterableExtensions.<ModelType>findFirst(this.typesRegistry.getImplementations(type.getIdentifier()), _function);
      this.internalToConvertedExpression(expr.getTarget(), b, expectedType);
      StringConcatenation _builder = new StringConcatenation();
      _builder.append(".to");
      String _name = match.getName();
      _builder.append(_name);
      _builder.append("()");
      b.append(_builder);
    } else {
      if (((expectedType.isSubtypeOf(IModelType.class) && type.isSubtypeOf(IModelType.class)) && IterableExtensions.<ModelType>exists(this.typesRegistry.getSubtypings(type.getIdentifier()), new Function1<ModelType, Boolean>() {
        @Override
        public Boolean apply(final ModelType it) {
          String _string = ModelOrientedXbaseCompiler.this._iQualifiedNameProvider.getFullyQualifiedName(it).toString();
          String _identifier = expectedType.getIdentifier();
          return Boolean.valueOf(Objects.equal(_string, _identifier));
        }
      }))) {
        final Function1<ModelType, Boolean> _function_1 = new Function1<ModelType, Boolean>() {
          @Override
          public Boolean apply(final ModelType it) {
            String _string = ModelOrientedXbaseCompiler.this._iQualifiedNameProvider.getFullyQualifiedName(it).toString();
            String _identifier = expectedType.getIdentifier();
            return Boolean.valueOf(Objects.equal(_string, _identifier));
          }
        };
        final ModelType match_1 = IterableExtensions.<ModelType>findFirst(this.typesRegistry.getSubtypings(type.getIdentifier()), _function_1);
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("((fr.inria.diverse.melange.lib.GenericAdapter<XXX>) ");
        b.append(_builder_1);
        this.internalToConvertedExpression(expr.getTarget(), b, expectedType);
        StringConcatenation _builder_2 = new StringConcatenation();
        _builder_2.append(").getAdaptee().to");
        String _name_1 = match_1.getName();
        _builder_2.append(_name_1);
        _builder_2.append("()");
        b.append(_builder_2);
      } else {
        super._toJavaExpression(expr, b);
      }
    }
  }
}
