/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.cocoa.NSAffineTransform;
import org.eclipse.swt.internal.cocoa.NSAutoreleasePool;
import org.eclipse.swt.internal.cocoa.NSBezierPath;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSThread;
import org.eclipse.swt.internal.cocoa.OS;

public final class Region
extends Resource {
    public long handle;
    NSAffineTransform transform;
    NSPoint pt = new NSPoint();
    short[] rect = new short[4];

    public Region() {
        this(null);
    }

    public Region(Device device) {
        super(device);
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.handle = OS.NewRgn();
            if (this.handle == 0L) {
                SWT.error(2);
            }
            this.init();
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    Region(Device device, long handle) {
        super(device);
        this.handle = handle;
        this.ignoreNonDisposed();
    }

    public static Region cocoa_new(Device device, long handle) {
        return new Region(device, handle);
    }

    static long polyToRgn(int[] poly, int length) {
        short[] r = new short[4];
        long polyRgn = OS.NewRgn();
        long rectRgn = OS.NewRgn();
        int minY = poly[1];
        int maxY = poly[1];
        int y = 3;
        while (y < length) {
            if (poly[y] < minY) {
                minY = poly[y];
            }
            if (poly[y] > maxY) {
                maxY = poly[y];
            }
            y += 2;
        }
        int[] inter = new int[length + 1];
        int y2 = minY;
        while (y2 <= maxY) {
            int count = 0;
            int x1 = poly[0];
            int y1 = poly[1];
            int p = 2;
            while (p < length) {
                int x2 = poly[p];
                int y22 = poly[p + 1];
                if (y1 != y22 && (y1 <= y2 && y2 < y22 || y22 <= y2 && y2 < y1)) {
                    inter[count++] = (int)((float)(y2 - y1) / (float)(y22 - y1) * (float)(x2 - x1) + (float)x1 + 0.5f);
                }
                x1 = x2;
                y1 = y22;
                p += 2;
            }
            int x2 = poly[0];
            int y23 = poly[1];
            if (y1 != y23 && (y1 <= y2 && y2 < y23 || y23 <= y2 && y2 < y1)) {
                inter[count++] = (int)((float)(y2 - y1) / (float)(y23 - y1) * (float)(x2 - x1) + (float)x1 + 0.5f);
            }
            int gap = count / 2;
            while (gap > 0) {
                int i = gap;
                while (i < count) {
                    int j = i - gap;
                    while (j >= 0) {
                        if (inter[j] - inter[j + gap] <= 0) break;
                        int temp = inter[j];
                        inter[j] = inter[j + gap];
                        inter[j + gap] = temp;
                        j -= gap;
                    }
                    ++i;
                }
                gap /= 2;
            }
            int i = 0;
            while (i < count) {
                OS.SetRect(r, (short)inter[i], (short)y2, (short)inter[i + 1], (short)(y2 + 1));
                OS.RectRgn(rectRgn, r);
                OS.UnionRgn(polyRgn, rectRgn, polyRgn);
                i += 2;
            }
            ++y2;
        }
        OS.DisposeRgn(rectRgn);
        return polyRgn;
    }

    static long polyRgn(int[] pointArray, int count) {
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            long polyRgn;
            if (C.PTR_SIZEOF == 4) {
                polyRgn = OS.NewRgn();
                OS.OpenRgn();
                OS.MoveTo((short)pointArray[0], (short)pointArray[1]);
                int i = 1;
                while (i < count / 2) {
                    OS.LineTo((short)pointArray[2 * i], (short)pointArray[2 * i + 1]);
                    ++i;
                }
                OS.LineTo((short)pointArray[0], (short)pointArray[1]);
                OS.CloseRgn(polyRgn);
            } else {
                polyRgn = Region.polyToRgn(pointArray, count);
            }
            long l = polyRgn;
            return l;
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    public void add(int[] pointArray) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (pointArray == null) {
            SWT.error(4);
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.add(pointArray, pointArray.length);
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    void add(int[] pointArray, int count) {
        if ((count = count / 2 * 2) <= 2) {
            return;
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            long polyRgn = Region.polyRgn(pointArray, count);
            OS.UnionRgn(this.handle, polyRgn, this.handle);
            OS.DisposeRgn(polyRgn);
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    public void add(Rectangle rect) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (rect == null) {
            SWT.error(4);
        }
        if (rect.width < 0 || rect.height < 0) {
            SWT.error(5);
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.add(rect.x, rect.y, rect.width, rect.height);
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    public void add(int x, int y, int width, int height) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (width < 0 || height < 0) {
            SWT.error(5);
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            long rectRgn = OS.NewRgn();
            short[] r = new short[4];
            OS.SetRect(r, (short)x, (short)y, (short)(x + width), (short)(y + height));
            OS.RectRgn(rectRgn, r);
            OS.UnionRgn(this.handle, rectRgn, this.handle);
            OS.DisposeRgn(rectRgn);
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    public void add(Region region) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (region == null) {
            SWT.error(4);
        }
        if (region.isDisposed()) {
            SWT.error(5);
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            OS.UnionRgn(this.handle, region.handle, this.handle);
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    public boolean contains(int x, int y) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            short[] point = new short[]{(short)y, (short)x};
            boolean bl = OS.PtInRgn(point, this.handle);
            return bl;
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    public boolean contains(Point pt) {
        if (pt == null) {
            SWT.error(4);
        }
        return this.contains(pt.x, pt.y);
    }

    void convertRgn(NSAffineTransform transform) {
        long newRgn = OS.NewRgn();
        Callback callback = new Callback(this, "convertRgn", 4);
        this.transform = transform;
        OS.QDRegionToRects(this.handle, 5, callback.getAddress(), newRgn);
        this.transform = null;
        callback.dispose();
        OS.CopyRgn(newRgn, this.handle);
        OS.DisposeRgn(newRgn);
    }

    long convertRgn(long message, long rgn, long r, long newRgn) {
        if (message == 2L) {
            short[] rect = new short[4];
            C.memmove(rect, r, (long)(rect.length * 2));
            int i = 0;
            NSPoint point = new NSPoint();
            int[] points = new int[10];
            point.x = rect[1];
            point.y = rect[0];
            point = this.transform.transformPoint(point);
            int n = i++;
            short startX = (short)point.x;
            points[n] = startX;
            int n2 = i++;
            short startY = (short)point.y;
            points[n2] = startY;
            point.x = rect[3];
            point.y = rect[0];
            point = this.transform.transformPoint(point);
            points[i++] = (short)Math.round(point.x);
            points[i++] = (short)point.y;
            point.x = rect[3];
            point.y = rect[2];
            point = this.transform.transformPoint(point);
            points[i++] = (short)Math.round(point.x);
            points[i++] = (short)Math.round(point.y);
            point.x = rect[1];
            point.y = rect[2];
            point = this.transform.transformPoint(point);
            points[i++] = (short)point.x;
            points[i++] = (short)Math.round(point.y);
            points[i++] = startX;
            points[i++] = startY;
            long polyRgn = Region.polyRgn(points, points.length);
            OS.UnionRgn(newRgn, polyRgn, newRgn);
            OS.DisposeRgn(polyRgn);
        }
        return 0L;
    }

    @Override
    void destroy() {
        OS.DisposeRgn(this.handle);
        this.handle = 0L;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Region)) {
            return false;
        }
        Region region = (Region)object;
        return this.handle == region.handle;
    }

    public Rectangle getBounds() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            short[] bounds = new short[4];
            OS.GetRegionBounds(this.handle, bounds);
            int width = bounds[3] - bounds[1];
            int height = bounds[2] - bounds[0];
            Rectangle rectangle = new Rectangle(bounds[1], bounds[0], width, height);
            return rectangle;
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    NSBezierPath getPath() {
        Callback callback = new Callback(this, "regionToRects", 4);
        NSBezierPath path = NSBezierPath.bezierPath();
        path.retain();
        OS.QDRegionToRects(this.handle, 5, callback.getAddress(), path.id);
        callback.dispose();
        if (path.isEmpty()) {
            path.appendBezierPathWithRect(new NSRect());
        }
        return path;
    }

    long regionToRects(long message, long rgn, long r, long path) {
        if (message == 2L) {
            C.memmove(this.rect, r, (long)(this.rect.length * 2));
            this.pt.x = this.rect[1];
            this.pt.y = this.rect[0];
            OS.objc_msgSend(path, OS.sel_moveToPoint_, this.pt);
            this.pt.x = this.rect[3];
            OS.objc_msgSend(path, OS.sel_lineToPoint_, this.pt);
            this.pt.x = this.rect[3];
            this.pt.y = this.rect[2];
            OS.objc_msgSend(path, OS.sel_lineToPoint_, this.pt);
            this.pt.x = this.rect[1];
            OS.objc_msgSend(path, OS.sel_lineToPoint_, this.pt);
            OS.objc_msgSend(path, OS.sel_closePath);
        }
        return 0L;
    }

    public int hashCode() {
        return (int)this.handle;
    }

    public void intersect(Rectangle rect) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (rect == null) {
            SWT.error(4);
        }
        this.intersect(rect.x, rect.y, rect.width, rect.height);
    }

    public void intersect(int x, int y, int width, int height) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (width < 0 || height < 0) {
            SWT.error(5);
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            long rectRgn = OS.NewRgn();
            short[] r = new short[4];
            OS.SetRect(r, (short)x, (short)y, (short)(x + width), (short)(y + height));
            OS.RectRgn(rectRgn, r);
            OS.SectRgn(this.handle, rectRgn, this.handle);
            OS.DisposeRgn(rectRgn);
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    public void intersect(Region region) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (region == null) {
            SWT.error(4);
        }
        if (region.isDisposed()) {
            SWT.error(5);
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            OS.SectRgn(this.handle, region.handle, this.handle);
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    public boolean intersects(int x, int y, int width, int height) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            short[] r = new short[4];
            OS.SetRect(r, (short)x, (short)y, (short)(x + width), (short)(y + height));
            boolean bl = OS.RectInRgn(r, this.handle);
            return bl;
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    public boolean intersects(Rectangle rect) {
        if (rect == null) {
            SWT.error(4);
        }
        return this.intersects(rect.x, rect.y, rect.width, rect.height);
    }

    @Override
    public boolean isDisposed() {
        return this.handle == 0L;
    }

    public boolean isEmpty() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            boolean bl = OS.EmptyRgn(this.handle);
            return bl;
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    public void subtract(int[] pointArray) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (pointArray == null) {
            SWT.error(4);
        }
        if (pointArray.length < 2) {
            return;
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            long polyRgn = Region.polyRgn(pointArray, pointArray.length);
            OS.DiffRgn(this.handle, polyRgn, this.handle);
            OS.DisposeRgn(polyRgn);
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    public void subtract(Rectangle rect) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (rect == null) {
            SWT.error(4);
        }
        this.subtract(rect.x, rect.y, rect.width, rect.height);
    }

    public void subtract(int x, int y, int width, int height) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (width < 0 || height < 0) {
            SWT.error(5);
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            long rectRgn = OS.NewRgn();
            short[] r = new short[4];
            OS.SetRect(r, (short)x, (short)y, (short)(x + width), (short)(y + height));
            OS.RectRgn(rectRgn, r);
            OS.DiffRgn(this.handle, rectRgn, this.handle);
            OS.DisposeRgn(rectRgn);
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    public void subtract(Region region) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (region == null) {
            SWT.error(4);
        }
        if (region.isDisposed()) {
            SWT.error(5);
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            OS.DiffRgn(this.handle, region.handle, this.handle);
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    public void translate(int x, int y) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            OS.OffsetRgn(this.handle, (short)x, (short)y);
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    public void translate(Point pt) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (pt == null) {
            SWT.error(4);
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.translate(pt.x, pt.y);
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Region {*DISPOSED*}";
        }
        return "Region {" + this.handle + "}";
    }
}

