/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.launcher.core.actiondelegate;

import fr.inria.aoste.timesquare.launcher.debug.model.CCSLDebugTarget;
import fr.inria.aoste.timesquare.launcher.debug.model.CCSLDebugThread;
import fr.inria.aoste.timesquare.launcher.debug.model.CCSLStackFrame;
import fr.inria.aoste.timesquare.launcher.debug.model.ICCSLDebugTarget;
import fr.inria.aoste.timesquare.launcher.debug.model.ISimulationInterface;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public abstract class AbstractCCSLActionDelegate
implements IViewActionDelegate,
IDebugContextListener {
    protected ICCSLDebugTarget ccsldt;

    public AbstractCCSLActionDelegate() {
        DebugUITools.getDebugContextManager().addDebugContextListener((IDebugContextListener)this);
    }

    public void debugContextChanged(DebugContextEvent event) {
    }

    public void init(IViewPart view) {
    }

    public void run(final IAction action) {
        try {
            Thread t = new Thread(this.getClass().getName()){

                @Override
                public void run() {
                    AbstractCCSLActionDelegate.this.runningAction(action);
                }
            };
            t.start();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    protected abstract void runningAction(IAction var1);

    protected ICCSLDebugTarget getDebugTargetOnSelection(ISelection selection) {
        if (selection instanceof TreeSelection) {
            Object o = ((TreeSelection)selection).getFirstElement();
            if (o instanceof CCSLDebugTarget) {
                return (CCSLDebugTarget)o;
            }
            if (o instanceof CCSLStackFrame) {
                return ((CCSLStackFrame)((Object)o)).getDebugTarget();
            }
            if (o instanceof CCSLDebugThread) {
                return ((CCSLDebugThread)o).getDebugTarget();
            }
        }
        return null;
    }

    public void selectionChanged(IAction action, ISelection _selection) {
        try {
            this.ccsldt = this.getDebugTargetOnSelection(_selection);
            if (this.ccsldt != null) {
                ISimulationInterface isim = ((CCSLDebugThread)this.ccsldt.getThreads()[0]).getSim();
                this.updateAction(action, isim, this.ccsldt);
            } else {
                action.setEnabled(false);
            }
        }
        catch (Throwable e) {
            action.setEnabled(false);
        }
    }

    protected abstract void updateAction(IAction var1, ISimulationInterface var2, ICCSLDebugTarget var3);

    protected void fireEvent(DebugEvent event) {
        DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{event});
    }
}

