/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.moccml.mapping.ecltoqvto.ui.popup.actions;

import com.google.inject.Injector;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.gemoc.moccml.mapping.ecltoqvto.main.AcceleoLauncherForEclToQvto;
import org.eclipse.gemoc.moccml.mapping.xtext.EclStandaloneSetup;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;

public class EclToQvtoTranslator
implements IObjectActionDelegate {
    private IFile eclModel = null;
    private AcceleoLauncherForEclToQvto launcher = null;

    public EclToQvtoTranslator() {
        this.initializeXtext();
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    private void initializeXtext() {
        EclStandaloneSetup ess = new EclStandaloneSetup();
        Injector injector = ess.createInjector();
        XtextResourceSet aset = (XtextResourceSet)injector.getInstance(XtextResourceSet.class);
        aset.addLoadOption((Object)XtextResource.OPTION_RESOLVE_ALL, (Object)Boolean.TRUE);
        EclStandaloneSetup.doSetup();
    }

    public void run(IAction action) {
        String uristring = this.eclModel.getLocation().toOSString();
        URI uri = URI.createFileURI((String)uristring);
        String folderPath = uri.devicePath().replace(uri.lastSegment(), "");
        File folder = new File(folderPath);
        ArrayList<String> arguments = new ArrayList<String>();
        String qvtoFileName = uri.lastSegment().replace(".ecl", "_toCCSL.qvto");
        arguments.add(qvtoFileName);
        arguments.add("Package");
        try {
            System.out.println("launching ecl to qvto:\n\turi=" + uri + "\n\tfolder=" + folder + "\n\targs=" + arguments);
            this.launcher = new AcceleoLauncherForEclToQvto(uri, folder, arguments);
            this.launcher.doGenerate((Monitor)new BasicMonitor());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        StructuredSelection ss;
        Object o;
        this.eclModel = null;
        if (selection instanceof StructuredSelection && (o = (ss = (StructuredSelection)selection).getFirstElement()) instanceof IFile) {
            this.eclModel = (IFile)o;
        }
    }
}

