/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.factory;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;

public class Mappers {
    private static final String IMPLEMENTATION_SUFFIX = "Impl";

    private Mappers() {
    }

    public static <T> T getMapper(Class<T> clazz) {
        try {
            List<ClassLoader> classLoaders = Mappers.collectClassLoaders(clazz.getClassLoader());
            return Mappers.getMapper(clazz, classLoaders);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    private static <T> T getMapper(Class<T> mapperType, Iterable<ClassLoader> classLoaders) throws ClassNotFoundException, NoSuchMethodException {
        for (ClassLoader classLoader : classLoaders) {
            T mapper = Mappers.doGetMapper(mapperType, classLoader);
            if (mapper == null) continue;
            return mapper;
        }
        throw new ClassNotFoundException("Cannot find implementation for " + mapperType.getName());
    }

    private static <T> T doGetMapper(Class<T> clazz, ClassLoader classLoader) throws NoSuchMethodException {
        try {
            Class<?> implementation = classLoader.loadClass(clazz.getName() + IMPLEMENTATION_SUFFIX);
            Constructor<?> constructor = implementation.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return (T)constructor.newInstance(new Object[0]);
        }
        catch (ClassNotFoundException e) {
            return Mappers.getMapperFromServiceLoader(clazz, classLoader);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> Class<? extends T> getMapperClass(Class<T> clazz) {
        try {
            List<ClassLoader> classLoaders = Mappers.collectClassLoaders(clazz.getClassLoader());
            return Mappers.getMapperClass(clazz, classLoaders);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private static <T> Class<? extends T> getMapperClass(Class<T> mapperType, Iterable<ClassLoader> classLoaders) throws ClassNotFoundException {
        for (ClassLoader classLoader : classLoaders) {
            Class<T> mapperClass = Mappers.doGetMapperClass(mapperType, classLoader);
            if (mapperClass == null) continue;
            return mapperClass;
        }
        throw new ClassNotFoundException("Cannot find implementation for " + mapperType.getName());
    }

    private static <T> Class<? extends T> doGetMapperClass(Class<T> clazz, ClassLoader classLoader) {
        try {
            return classLoader.loadClass(clazz.getName() + IMPLEMENTATION_SUFFIX);
        }
        catch (ClassNotFoundException e) {
            T mapper = Mappers.getMapperFromServiceLoader(clazz, classLoader);
            if (mapper != null) {
                return mapper.getClass();
            }
            return null;
        }
    }

    private static <T> T getMapperFromServiceLoader(Class<T> clazz, ClassLoader classLoader) {
        ServiceLoader<T> loader = ServiceLoader.load(clazz, classLoader);
        for (T mapper : loader) {
            if (mapper == null) continue;
            return mapper;
        }
        return null;
    }

    private static List<ClassLoader> collectClassLoaders(ClassLoader classLoader) {
        ArrayList<ClassLoader> classLoaders = new ArrayList<ClassLoader>(3);
        classLoaders.add(classLoader);
        if (Thread.currentThread().getContextClassLoader() != null) {
            classLoaders.add(Thread.currentThread().getContextClassLoader());
        }
        classLoaders.add(Mappers.class.getClassLoader());
        return classLoaders;
    }
}

