/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.ccslkernel.solver.helpers;

import fr.inria.aoste.timesquare.ccslkernel.runtime.ICCSLConstraint;
import fr.inria.aoste.timesquare.ccslkernel.runtime.elements.RuntimeClock;
import fr.inria.aoste.timesquare.ccslkernel.runtime.helpers.AbstractSemanticHelper;
import fr.inria.aoste.timesquare.ccslkernel.runtime.helpers.AbstractUpdateHelper;
import fr.inria.aoste.timesquare.ccslkernel.runtime.relations.AbstractRuntimeRelation;
import fr.inria.aoste.timesquare.ccslkernel.solver.CCSLKernelSolver;
import fr.inria.aoste.timesquare.ccslkernel.solver.ISolverConcrete;
import fr.inria.aoste.timesquare.ccslkernel.solver.StepExecutor;
import fr.inria.aoste.timesquare.ccslkernel.solver.TimeModel.SolverClock;
import fr.inria.aoste.timesquare.ccslkernel.solver.statistics.SolverRuntimeStats;
import java.util.Set;
import net.sf.javabdd.BuDDyFactory;

public class SemanticHelper
extends AbstractSemanticHelper {
    private CCSLKernelSolver solver;
    private StepExecutor stepExecutor;

    public SemanticHelper(CCSLKernelSolver solver, StepExecutor stepExecutor) {
        super(solver.bddHelper);
        this.solver = solver;
        this.stepExecutor = stepExecutor;
    }

    public void semanticBDDAnd(BuDDyFactory.BuDDyBDD term) {
        if (CCSLKernelSolver.runtimeStatsCollection) {
            SolverRuntimeStats.enterMethod(String.valueOf(((Object)((Object)this)).getClass().getName()) + ".semanticBDDAnd");
        }
        this.stepExecutor.semanticBDDAnd(term);
        term.free();
        if (CCSLKernelSolver.runtimeStatsCollection) {
            SolverRuntimeStats.leaveMethod(String.valueOf(((Object)((Object)this)).getClass().getName()) + ".semanticBDDAnd");
        }
    }

    public void registerAssertion(AbstractRuntimeRelation relation) {
        this.stepExecutor.addAssertionVariable(relation.getAssertionVariable());
    }

    public void registerDeathEquality(RuntimeClock c1, RuntimeClock c2) {
        this.stepExecutor.getClockDeathSolver().registerEquality(c1, c2);
    }

    public void registerDeathImplication(RuntimeClock c1, RuntimeClock c2) {
        this.stepExecutor.getClockDeathSolver().registerImplication(c1, c2);
    }

    public void registerDeathConjunctionImplies(RuntimeClock left1, RuntimeClock left2, RuntimeClock right) {
        this.stepExecutor.getClockDeathSolver().registerConjunctionImplication(left1, left2, right);
    }

    public void forceDeath(RuntimeClock cl) {
        this.stepExecutor.getClockDeathSolver().registerDeadClock(cl);
    }

    public Set<RuntimeClock> getUsedClocks() {
        return this.stepExecutor.getUsedClocks();
    }

    public void registerClockUse(RuntimeClock clock) {
        this.stepExecutor.getUsedClocks().add((SolverClock)clock);
    }

    public void registerClockUse(RuntimeClock[] clocks) {
        RuntimeClock[] runtimeClockArray = clocks;
        int n = clocks.length;
        int n2 = 0;
        while (n2 < n) {
            RuntimeClock clock = runtimeClockArray[n2];
            this.stepExecutor.getUsedClocks().add((SolverClock)clock);
            ++n2;
        }
    }

    public boolean isSemanticDone(ICCSLConstraint concrete) {
        return this.stepExecutor.getSemanticDoneConcretes().contains(concrete);
    }

    public void registerSemanticDone(ICCSLConstraint concrete) {
        this.stepExecutor.getSemanticDoneConcretes().add((ISolverConcrete)concrete);
    }

    public void registerDeadClock(RuntimeClock clock) {
        this.solver.addDeadClock(clock);
    }

    public void unregisterDeadClock(RuntimeClock clock) {
        this.solver.removeDeadClock(clock);
    }

    public void registerClockToStart(RuntimeClock clock) {
        this.stepExecutor.getStartQueue().add((SolverClock)clock);
    }

    public void unregisterClockToStart(RuntimeClock clock) {
        this.stepExecutor.getStartQueue().remove(clock);
    }

    public AbstractUpdateHelper getUpdateHelper() {
        return this.stepExecutor.getUpdateHelper();
    }
}

