/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.ccslkernel.solver.relation;

import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.BasicType.BooleanElement;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.BasicType.PrimitiveElement;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClassicalExpression.BooleanExpression;
import fr.inria.aoste.timesquare.ccslkernel.runtime.SerializedConstraintState;
import fr.inria.aoste.timesquare.ccslkernel.runtime.exceptions.EvaluationTypeError;
import fr.inria.aoste.timesquare.ccslkernel.runtime.exceptions.SimulationException;
import fr.inria.aoste.timesquare.ccslkernel.runtime.helpers.AbstractSemanticHelper;
import fr.inria.aoste.timesquare.ccslkernel.runtime.helpers.AbstractUpdateHelper;
import fr.inria.aoste.timesquare.ccslkernel.solver.ClassicalExpressionEvaluator;
import fr.inria.aoste.timesquare.ccslkernel.solver.ConditionalCase;
import fr.inria.aoste.timesquare.ccslkernel.solver.ISolverConcrete;
import fr.inria.aoste.timesquare.ccslkernel.solver.ImplicitClock;
import fr.inria.aoste.timesquare.ccslkernel.solver.SolverElement;
import fr.inria.aoste.timesquare.ccslkernel.solver.relation.SolverRelation;
import java.util.ArrayList;
import java.util.List;

public class ConditionalRelation
extends SolverRelation
implements ISolverConcrete {
    private List<ConditionalCase> cases = new ArrayList<ConditionalCase>();
    private List<ISolverConcrete> defaultCase = new ArrayList<ISolverConcrete>();
    private List<ImplicitClock> defaultCaseClocks = new ArrayList<ImplicitClock>();
    private ConditionalCase selectedCase;

    public List<ConditionalCase> getCases() {
        return this.cases;
    }

    public List<ISolverConcrete> getDefaultCase() {
        return this.defaultCase;
    }

    public List<ImplicitClock> getDefaultCaseClocks() {
        return this.defaultCaseClocks;
    }

    @Override
    public void start(AbstractSemanticHelper helper) throws SimulationException {
        for (ConditionalCase relationCase : this.getCases()) {
            for (ISolverConcrete conc : relationCase.getConcretes()) {
                conc.start(helper);
            }
            for (ImplicitClock clock : relationCase.getImplicitClocks()) {
                if (clock.getRefCount() != 0) continue;
                clock.start(helper);
            }
        }
        for (ISolverConcrete conc : this.getDefaultCase()) {
            conc.start(helper);
        }
        for (ImplicitClock clock : this.getDefaultCaseClocks()) {
            if (clock.getRefCount() != 0) continue;
            clock.start(helper);
        }
        for (ConditionalCase relationCase : this.getCases()) {
            BooleanExpression condition = relationCase.getCondition();
            ClassicalExpressionEvaluator eval = new ClassicalExpressionEvaluator(this.getAbstractMapping());
            SolverElement test = eval.evaluate((PrimitiveElement)condition);
            if (!(test.getModelElement() instanceof BooleanElement)) {
                throw new EvaluationTypeError("ConditionalRelation.semantic(): BooleanElement expected");
            }
            if (!((BooleanElement)test.getModelElement()).getValue().booleanValue()) continue;
            this.selectedCase = relationCase;
            break;
        }
    }

    @Override
    public void semantic(AbstractSemanticHelper semanticHelper) throws SimulationException {
        boolean goDefault = true;
        this.selectedCase = null;
        for (ConditionalCase relationCase : this.getCases()) {
            BooleanExpression condition = relationCase.getCondition();
            ClassicalExpressionEvaluator eval = new ClassicalExpressionEvaluator(this.getAbstractMapping());
            SolverElement test = eval.evaluate((PrimitiveElement)condition);
            if (!(test.getModelElement() instanceof BooleanElement)) {
                throw new EvaluationTypeError("ConditionalRelation.semantic(): BooleanElement expected");
            }
            if (!((BooleanElement)test.getModelElement()).getValue().booleanValue()) continue;
            this.selectedCase = relationCase;
            for (ISolverConcrete conc : relationCase.getConcretes()) {
                conc.semantic(semanticHelper);
            }
            goDefault = false;
            break;
        }
        if (goDefault) {
            for (ISolverConcrete conc : this.getDefaultCase()) {
                conc.semantic(semanticHelper);
            }
        }
    }

    @Override
    public void deathSemantic(AbstractSemanticHelper semanticHelper) throws SimulationException {
        if (this.selectedCase != null) {
            for (ISolverConcrete conc : this.selectedCase.getConcretes()) {
                conc.deathSemantic(semanticHelper);
            }
        } else {
            for (ISolverConcrete conc : this.getDefaultCase()) {
                conc.deathSemantic(semanticHelper);
            }
        }
    }

    @Override
    public void update(AbstractUpdateHelper helper) throws SimulationException {
        if (this.selectedCase != null) {
            for (ISolverConcrete conc : this.selectedCase.getConcretes()) {
                conc.update(helper);
            }
        } else {
            for (ISolverConcrete conc : this.getDefaultCase()) {
                conc.update(helper);
            }
        }
    }

    @Override
    public SerializedConstraintState dumpState() {
        SerializedConstraintState currentState = super.dumpState();
        Integer selectedCaseIndex = this.cases.indexOf(this.selectedCase);
        currentState.dump((Object)selectedCaseIndex);
        return currentState;
    }

    @Override
    public void restoreState(SerializedConstraintState newState) {
        super.restoreState(newState);
        int index = (Integer)newState.restore(0);
        this.selectedCase = index >= 0 ? this.cases.get(index) : null;
    }
}

