/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.refactoring;

import java.util.ArrayList;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.internal.ui.ras.UIFFDC;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.text.ITextSelection;

public class SelectionUtil {
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_5;

    public static List<IJavaElement> findSelectedElements(ICompilationUnit unit, ITextSelection textSel) {
        ArrayList<IJavaElement> foundElements = new ArrayList<IJavaElement>();
        if (textSel.getLength() > 0) {
            SelectionUtil.findEnclosedElements((IJavaElement)unit, textSel.getOffset(), textSel.getLength(), foundElements);
        }
        if (foundElements.isEmpty()) {
            try {
                IJavaElement el = unit.getElementAt(textSel.getOffset());
                if (el != null) {
                    foundElements.add(el);
                }
            }
            catch (JavaModelException javaModelException) {
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$1$31280822(javaModelException, ajc$tjp_0, (JoinPoint.StaticPart)ajc$tjp_1);
            }
        }
        return foundElements;
    }

    public static void findEnclosedElements(IJavaElement el, int offset, int length, List<IJavaElement> foundElements) {
        if (SelectionUtil.isEnclosed(el, offset, length)) {
            foundElements.add(el);
            return;
        }
        if (el instanceof IParent) {
            try {
                IJavaElement[] children;
                IJavaElement[] iJavaElementArray = children = ((IParent)el).getChildren();
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    IJavaElement child = iJavaElementArray[n2];
                    SelectionUtil.findEnclosedElements(child, offset, length, foundElements);
                    ++n2;
                }
            }
            catch (JavaModelException javaModelException) {
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$1$31280822(javaModelException, ajc$tjp_2, (JoinPoint.StaticPart)ajc$tjp_3);
            }
        }
    }

    public static boolean isEnclosed(IJavaElement _el, int offset, int length) {
        if (!(_el instanceof ISourceReference)) {
            return false;
        }
        try {
            ISourceReference el = (ISourceReference)_el;
            int end = offset + length;
            int elOffset = el.getSourceRange().getOffset();
            int elEnd = elOffset + el.getSourceRange().getLength();
            return offset <= elOffset && elEnd <= end;
        }
        catch (JavaModelException javaModelException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$1$31280822(javaModelException, ajc$tjp_4, (JoinPoint.StaticPart)ajc$tjp_5);
            return false;
        }
    }

    static {
        SelectionUtil.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("SelectionUtil.java", SelectionUtil.class);
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.refactoring.SelectionUtil", "org.eclipse.jdt.core.JavaModelException", "<missing>"), 47);
        ajc$tjp_1 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("9", "findSelectedElements", "org.eclipse.ajdt.internal.ui.refactoring.SelectionUtil", "org.eclipse.jdt.core.ICompilationUnit:org.eclipse.jface.text.ITextSelection", "unit:textSel", "", "java.util.List"), 35);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.refactoring.SelectionUtil", "org.eclipse.jdt.core.JavaModelException", "<missing>"), 66);
        ajc$tjp_3 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("9", "findEnclosedElements", "org.eclipse.ajdt.internal.ui.refactoring.SelectionUtil", "org.eclipse.jdt.core.IJavaElement:int:int:java.util.List", "el:offset:length:foundElements", "", "void"), 54);
        ajc$tjp_4 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.refactoring.SelectionUtil", "org.eclipse.jdt.core.JavaModelException", "<missing>"), 79);
        ajc$tjp_5 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("9", "isEnclosed", "org.eclipse.ajdt.internal.ui.refactoring.SelectionUtil", "org.eclipse.jdt.core.IJavaElement:int:int", "_el:offset:length", "", "boolean"), 71);
    }
}

