/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.executionframework.event.ui.views;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IResource;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gemoc.commons.eclipse.ui.dialogs.SelectAnyIFileDialog;
import org.eclipse.gemoc.executionframework.behavioralinterface.behavioralInterface.Event;
import org.eclipse.gemoc.executionframework.behavioralinterface.behavioralInterface.EventParameter;
import org.eclipse.gemoc.executionframework.event.manager.IEventManager;
import org.eclipse.gemoc.executionframework.event.model.event.EventFactory;
import org.eclipse.gemoc.executionframework.event.model.event.EventOccurrence;
import org.eclipse.gemoc.executionframework.event.model.event.EventOccurrenceArgument;
import org.eclipse.gemoc.executionframework.event.model.event.EventOccurrenceType;
import org.eclipse.gemoc.executionframework.value.model.value.BooleanAttributeValue;
import org.eclipse.gemoc.executionframework.value.model.value.BooleanObjectAttributeValue;
import org.eclipse.gemoc.executionframework.value.model.value.FloatAttributeValue;
import org.eclipse.gemoc.executionframework.value.model.value.FloatObjectAttributeValue;
import org.eclipse.gemoc.executionframework.value.model.value.IntegerAttributeValue;
import org.eclipse.gemoc.executionframework.value.model.value.IntegerObjectAttributeValue;
import org.eclipse.gemoc.executionframework.value.model.value.SingleObjectValue;
import org.eclipse.gemoc.executionframework.value.model.value.SingleReferenceValue;
import org.eclipse.gemoc.executionframework.value.model.value.StringAttributeValue;
import org.eclipse.gemoc.executionframework.value.model.value.Value;
import org.eclipse.gemoc.executionframework.value.model.value.ValueFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class EventOccurrenceConfigurator {
    private final EventFactory eventFactory = EventFactory.eINSTANCE;
    private final ValueFactory valueFactory = ValueFactory.eINSTANCE;
    private final Map<EventParameter, EClass> paramToType;
    private final Map<EClass, List<EObject>> typeToElements;
    private final IEventManager eventManager;
    private EventOccurrence eventOccurrence = null;
    private final Function<Object, String> namingFunction;
    private final ResourceSet executedResourceSet;

    public EventOccurrenceConfigurator(Composite parent, IEventManager eventManager, Event event, Map<EventParameter, EClass> paramToType, Map<EClass, List<EObject>> typeToElements, Function<Object, String> namingFunction) {
        this.eventManager = eventManager;
        this.paramToType = paramToType;
        this.typeToElements = typeToElements;
        this.namingFunction = namingFunction;
        this.executedResourceSet = typeToElements.values().stream().filter(l -> !l.isEmpty()).findAny().map(l -> l.stream().findFirst().map(v -> v.eResource().getResourceSet()).orElse(null)).orElse(null);
        Group group = new Group(parent, 0);
        GridLayout configuratorLayout = new GridLayout();
        GridData configuratorGridData = new GridData(4, 1, true, false);
        configuratorLayout.marginHeight = 10;
        configuratorLayout.marginWidth = 10;
        group.setText(event.getName());
        group.setLayout((Layout)configuratorLayout);
        group.setLayoutData((Object)configuratorGridData);
        this.eventOccurrence = this.createEventOccurrence(event);
        if (!this.eventOccurrence.getArgs().isEmpty()) {
            Group parameterGroup = new Group((Composite)group, 0);
            GridLayout parameterLayout = new GridLayout();
            GridData parameterGridData = new GridData(4, 0x1000000, true, false);
            parameterLayout.numColumns = 3;
            parameterLayout.marginHeight = 10;
            parameterLayout.marginWidth = 10;
            parameterGroup.setText("Parameters");
            parameterGroup.setLayout((Layout)parameterLayout);
            parameterGroup.setLayoutData((Object)parameterGridData);
            this.eventOccurrence.getArgs().forEach(a -> this.addParameterRow((Composite)parameterGroup, a.getParameter(), (EventOccurrenceArgument)a));
        }
        Button sendButton = SWTFactory.createPushButton((Composite)group, (String)"Send", null);
        sendButton.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        sendButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                EventOccurrenceConfigurator.this.eventManager.processEventOccurrence(EventOccurrenceConfigurator.this.copyEventOccurrence(EventOccurrenceConfigurator.this.eventOccurrence));
            }
        });
        group.requestLayout();
    }

    private EventOccurrence copyEventOccurrence(EventOccurrence eventOccurrence) {
        EventOccurrence result = this.eventFactory.createEventOccurrence();
        result.setEvent(eventOccurrence.getEvent());
        result.setType(EventOccurrenceType.ACCEPTED);
        eventOccurrence.getArgs().stream().map(arg -> {
            Value val = arg.getValue();
            EventOccurrenceArgument newArg = this.eventFactory.createEventOccurrenceArgument();
            newArg.setParameter(arg.getParameter());
            Value newVal = (Value)this.valueFactory.create(arg.getValue().eClass());
            newArg.setValue(newVal);
            switch (val.eClass().getClassifierID()) {
                case 3: {
                    ((BooleanAttributeValue)newVal).setAttributeValue(((BooleanAttributeValue)val).isAttributeValue());
                    break;
                }
                case 4: {
                    ((BooleanObjectAttributeValue)newVal).setAttributeValue(((BooleanObjectAttributeValue)val).getAttributeValue());
                    break;
                }
                case 5: {
                    ((IntegerAttributeValue)newVal).setAttributeValue(((IntegerAttributeValue)val).getAttributeValue());
                    break;
                }
                case 6: {
                    ((IntegerObjectAttributeValue)newVal).setAttributeValue(((IntegerObjectAttributeValue)val).getAttributeValue());
                    break;
                }
                case 9: {
                    ((FloatAttributeValue)newVal).setAttributeValue(((FloatAttributeValue)val).getAttributeValue());
                    break;
                }
                case 10: {
                    ((FloatObjectAttributeValue)newVal).setAttributeValue(((FloatObjectAttributeValue)val).getAttributeValue());
                    break;
                }
                case 11: {
                    ((StringAttributeValue)newVal).setAttributeValue(((StringAttributeValue)val).getAttributeValue());
                    break;
                }
                case 21: {
                    ((SingleReferenceValue)newVal).setReferenceValue(((SingleReferenceValue)val).getReferenceValue());
                    break;
                }
                case 23: {
                    ((SingleObjectValue)newVal).setObjectValue(((SingleObjectValue)val).getObjectValue());
                }
            }
            return newArg;
        }).forEach(arg -> {
            boolean bl = result.getArgs().add(arg);
        });
        return result;
    }

    private EventOccurrence createEventOccurrence(Event event) {
        EventOccurrence eventOccurrence = this.eventFactory.createEventOccurrence();
        eventOccurrence.setEvent(event);
        event.getParams().forEach(p -> eventOccurrence.getArgs().add((Object)this.createEventOccurrenceArgument((EventParameter)p)));
        return eventOccurrence;
    }

    private EventOccurrenceArgument createEventOccurrenceArgument(EventParameter parameter) {
        EventOccurrenceArgument argument = this.eventFactory.createEventOccurrenceArgument();
        argument.setParameter(parameter);
        this.createArgumentValue(argument);
        return argument;
    }

    private void createArgumentValue(EventOccurrenceArgument argument) {
        switch (argument.getParameter().getType()) {
            case "java.lang.Boolean": {
                BooleanObjectAttributeValue val = ValueFactory.eINSTANCE.createBooleanObjectAttributeValue();
                val.setAttributeValue(Boolean.valueOf(false));
                argument.setValue((Value)val);
                break;
            }
            case "boolean": {
                BooleanAttributeValue val = ValueFactory.eINSTANCE.createBooleanAttributeValue();
                val.setAttributeValue(false);
                argument.setValue((Value)val);
                break;
            }
            case "java.lang.Float": {
                FloatObjectAttributeValue val = ValueFactory.eINSTANCE.createFloatObjectAttributeValue();
                val.setAttributeValue(Float.valueOf(0.0f));
                argument.setValue((Value)val);
                break;
            }
            case "float": {
                FloatAttributeValue val = ValueFactory.eINSTANCE.createFloatAttributeValue();
                val.setAttributeValue(0.0f);
                argument.setValue((Value)val);
                break;
            }
            case "java.lang.Integer": {
                IntegerObjectAttributeValue val = ValueFactory.eINSTANCE.createIntegerObjectAttributeValue();
                val.setAttributeValue(Integer.valueOf(0));
                argument.setValue((Value)val);
                break;
            }
            case "int": {
                IntegerAttributeValue val = ValueFactory.eINSTANCE.createIntegerAttributeValue();
                val.setAttributeValue(0);
                argument.setValue((Value)val);
                break;
            }
            case "java.lang.String": {
                StringAttributeValue val = ValueFactory.eINSTANCE.createStringAttributeValue();
                val.setAttributeValue("");
                argument.setValue((Value)val);
                break;
            }
            default: {
                SingleReferenceValue val = ValueFactory.eINSTANCE.createSingleReferenceValue();
                argument.setValue((Value)val);
            }
        }
    }

    private void addParameterRow(Composite parent, EventParameter parameter, EventOccurrenceArgument argument) {
        Label parameterName = new Label(parent, 0);
        parameterName.setText(parameter.getName());
        if (argument.getValue() instanceof SingleReferenceValue) {
            EClass type = this.paramToType.get(parameter);
            this.addObjectParameterRow(parent, type, argument);
        } else {
            this.addPrimitiveParameterRow(parent, argument);
        }
    }

    private void addPrimitiveParameterRow(Composite parent, EventOccurrenceArgument argument) {
        Text parameterValue = new Text(parent, 2052);
        parameterValue.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        new Label(parent, 0);
        parameterValue.addModifyListener(e -> ((StringAttributeValue)argument.getValue()).setAttributeValue(parameterValue.getText()));
    }

    private void addObjectParameterRow(Composite parent, EClass type, final EventOccurrenceArgument argument) {
        final Combo parameterValue = new Combo(parent, 12);
        parameterValue.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Button parameterBrowseButton = SWTFactory.createPushButton((Composite)parent, (String)"...", null);
        parameterBrowseButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        final List<EObject> possibleParameters = this.typeToElements.get(type);
        parameterValue.setItems(possibleParameters.stream().map(o -> this.namingFunction.apply(o)).collect(Collectors.toList()).toArray(new String[0]));
        parameterValue.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                EObject selectedArgument = (EObject)possibleParameters.get(parameterValue.getSelectionIndex());
                EventOccurrenceConfigurator.this.setArgumentReferenceValue(argument, selectedArgument);
            }
        });
        if (!possibleParameters.isEmpty()) {
            parameterValue.select(0);
            this.setArgumentReferenceValue(argument, possibleParameters.get(0));
        }
        parameterBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                SelectAnyIFileDialog dialog = new SelectAnyIFileDialog();
                if (dialog.open() == 0) {
                    String modelPath = ((IResource)dialog.getResult()[0]).getFullPath().toPortableString();
                    String uri = "platform:/resource" + modelPath;
                    Resource resource = null;
                    try {
                        resource = EventOccurrenceConfigurator.this.executedResourceSet.getResource(URI.createURI((String)uri), true);
                        EcoreUtil.resolveAll((Resource)resource);
                        EObject root = (EObject)resource.getContents().get(0);
                        EventOccurrenceConfigurator.this.setArgumentObjectValue(argument, root);
                        parameterValue.setText(EventOccurrenceConfigurator.this.namingFunction.apply(root));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    private void setArgumentReferenceValue(EventOccurrenceArgument argument, EObject value) {
        SingleReferenceValue objectValue = this.valueFactory.createSingleReferenceValue();
        objectValue.setReferenceValue(value);
        argument.setValue((Value)objectValue);
    }

    private void setArgumentObjectValue(final EventOccurrenceArgument argument, final EObject value) {
        final SingleObjectValue objectValue = this.valueFactory.createSingleObjectValue();
        TransactionalEditingDomain ed = TransactionUtil.getEditingDomain((Resource)value.eResource());
        if (ed != null) {
            RecordingCommand command = new RecordingCommand(ed, ""){

                protected void doExecute() {
                    objectValue.setObjectValue(value);
                    argument.setValue((Value)objectValue);
                }
            };
            ed.getCommandStack().execute((Command)command);
        }
    }
}

