/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.contribution.xref.internal.ui.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchMessages;

public class CopyAction
extends Action {
    private TreeViewer fViewer;
    private Clipboard fClipboard;
    private static final String INDENT_SPACES = "                                                                      ";

    public CopyAction(TreeViewer viewer, Clipboard clipboard) {
        this.fClipboard = clipboard;
        this.fViewer = viewer;
        this.setText(WorkbenchMessages.Workbench_copy);
        this.setToolTipText(WorkbenchMessages.Workbench_copyToolTip);
        ISharedImages workbenchImages = PlatformUI.getWorkbench().getSharedImages();
        this.setImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_COPY"));
    }

    public void run() {
        this.fClipboard.setContents(new Object[]{this.getContentsAsText()}, new Transfer[]{TextTransfer.getInstance()});
    }

    public String getContentsAsText() {
        TreeItem[] items = this.fViewer.getTree().getSelection();
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < items.length) {
            buf.append(this.nestingLevel(items[i]));
            buf.append(items[i].getText());
            if (i < items.length - 1) {
                buf.append(System.getProperty("line.separator"));
            }
            ++i;
        }
        return buf.toString();
    }

    private String nestingLevel(TreeItem item) {
        int level = 0;
        while (item != null && level < 100) {
            ++level;
            item = item.getParentItem();
        }
        int indent = (level - 1) * 4;
        if (indent < INDENT_SPACES.length()) {
            return INDENT_SPACES.substring(0, indent);
        }
        return INDENT_SPACES;
    }
}

