/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.ale.interpreted.engine.ui.launcher;

import java.util.Arrays;
import java.util.Set;
import java.util.function.BiPredicate;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gemoc.ale.interpreted.engine.AleEngine;
import org.eclipse.gemoc.ale.interpreted.engine.debug.AleDynamicAccessor;
import org.eclipse.gemoc.ale.interpreted.engine.sirius.ALESiriusInterpreter;
import org.eclipse.gemoc.ale.interpreted.engine.sirius.ALESiriusInterpreterProviderAddon;
import org.eclipse.gemoc.ale.interpreted.engine.ui.Activator;
import org.eclipse.gemoc.commons.eclipse.messagingsystem.api.MessagingSystem;
import org.eclipse.gemoc.commons.eclipse.ui.ViewHelper;
import org.eclipse.gemoc.dsl.debug.ide.IDSLDebugger;
import org.eclipse.gemoc.dsl.debug.ide.event.DSLDebugEventDispatcher;
import org.eclipse.gemoc.dsl.debug.ide.event.IDSLDebugEventProcessor;
import org.eclipse.gemoc.executionframework.debugger.GenericSequentialModelDebugger;
import org.eclipse.gemoc.executionframework.debugger.IDynamicPartAccessor;
import org.eclipse.gemoc.executionframework.debugger.OmniscientGenericSequentialModelDebugger;
import org.eclipse.gemoc.executionframework.engine.commons.DefaultExecutionPlatform;
import org.eclipse.gemoc.executionframework.engine.commons.EngineContextException;
import org.eclipse.gemoc.executionframework.engine.commons.GenericModelExecutionContext;
import org.eclipse.gemoc.executionframework.engine.commons.sequential.SequentialRunConfiguration;
import org.eclipse.gemoc.executionframework.engine.ui.launcher.AbstractSequentialGemocLauncher;
import org.eclipse.gemoc.trace.commons.model.trace.Step;
import org.eclipse.gemoc.trace.gemoc.traceaddon.GenericTraceEngineAddon;
import org.eclipse.gemoc.xdsmlframework.api.core.ExecutionMode;
import org.eclipse.gemoc.xdsmlframework.api.core.IExecutionContext;
import org.eclipse.gemoc.xdsmlframework.api.core.IExecutionEngine;
import org.eclipse.gemoc.xdsmlframework.api.core.IRunConfiguration;
import org.eclipse.gemoc.xdsmlframework.api.engine_addon.IEngineAddon;

public class Launcher
extends AbstractSequentialGemocLauncher<GenericModelExecutionContext<SequentialRunConfiguration>, SequentialRunConfiguration> {
    public static final String TYPE_ID = "org.eclipse.gemoc.ale.interpreted.engine.ui.launcher";

    protected AleEngine createExecutionEngine(SequentialRunConfiguration runConfiguration, ExecutionMode executionMode) throws CoreException, EngineContextException {
        AleEngine engine = new AleEngine();
        GenericModelExecutionContext executioncontext = new GenericModelExecutionContext((IRunConfiguration)runConfiguration, executionMode);
        executioncontext.initializeResourceModel();
        engine.initialize((IExecutionContext)executioncontext);
        ALESiriusInterpreter.getDefault().addAleEngine(engine);
        ALESiriusInterpreterProviderAddon aleRTDInterpreter = new ALESiriusInterpreterProviderAddon();
        Activator.getDefault().getMessaggingSystem().debug("Enabled implicit addon: " + aleRTDInterpreter.getAddonID(), this.getPluginID());
        ((DefaultExecutionPlatform)((GenericModelExecutionContext)engine.getExecutionContext()).getExecutionPlatform()).addEngineAddon((IEngineAddon)aleRTDInterpreter);
        return engine;
    }

    protected void prepareViews() {
        ViewHelper.retrieveView((String)"org.eclipse.gemoc.executionframework.ui.views.engine.EnginesStatusView");
    }

    protected SequentialRunConfiguration parseLaunchConfiguration(ILaunchConfiguration configuration) throws CoreException {
        return new SequentialRunConfiguration(configuration);
    }

    protected MessagingSystem getMessagingSystem() {
        return Activator.getDefault().getMessaggingSystem();
    }

    protected void error(String message, Exception e) {
        Activator.error(message, e);
    }

    protected void setDefaultsLaunchConfiguration(ILaunchConfigurationWorkingCopy configuration) {
    }

    protected String getLaunchConfigurationTypeID() {
        return TYPE_ID;
    }

    protected IDSLDebugger getDebugger(ILaunchConfiguration configuration, DSLDebugEventDispatcher dispatcher, EObject firstInstruction, IProgressMonitor monitor) {
        AleEngine engine = (AleEngine)this.getExecutionEngine();
        Set traceAddons = engine.getAddonsTypedBy(GenericTraceEngineAddon.class);
        for (GenericTraceEngineAddon addon : traceAddons) {
            addon.setDynamicPartAccessor((IDynamicPartAccessor)new AleDynamicAccessor(engine.getInterpreter(), engine.getModelUnits()));
        }
        Object debugger = traceAddons.isEmpty() ? new GenericSequentialModelDebugger((IDSLDebugEventProcessor)dispatcher, (IExecutionEngine)engine) : new OmniscientGenericSequentialModelDebugger((IDSLDebugEventProcessor)dispatcher, (IExecutionEngine)engine);
        debugger.setMutableFieldExtractors(Arrays.asList(new AleDynamicAccessor(engine.getInterpreter(), engine.getModelUnits())));
        try {
            if (configuration.getAttribute("GEMOC_LAUNCH_BREAK_START", false)) {
                debugger.addPredicateBreak(new BiPredicate<IExecutionEngine<?>, Step<?>>(){

                    @Override
                    public boolean test(IExecutionEngine<?> t, Step<?> u) {
                        return true;
                    }
                });
            }
        }
        catch (CoreException e) {
            Activator.error(e.getMessage(), e);
        }
        Activator.getDefault().getMessaggingSystem().debug("Enabled implicit addon: " + debugger.getAddonID(), this.getPluginID());
        ((DefaultExecutionPlatform)((GenericModelExecutionContext)engine.getExecutionContext()).getExecutionPlatform()).addEngineAddon((IEngineAddon)debugger);
        return debugger;
    }

    protected String getDebugJobName(ILaunchConfiguration configuration, EObject firstInstruction) {
        return "GEMOC Debug Job";
    }

    protected String getPluginID() {
        return "org.eclipse.gemoc.ale.interpreted.engine.ui";
    }

    public String getModelIdentifier() {
        return "org.eclipse.gemoc.executionframework.engine.ui.generic.debugModel";
    }
}

