/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.ale.ide.ui.wizards;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.FilteredResourcesSelectionDialog;

public class NewAleProjectConfigurationWizardPage
extends WizardPage {
    private static final String SWTBOT_ID = "org.eclipse.swtbot.widget.key";
    public static final String CREATE_ECORE_MODEL_BUTTON_ID = "createEcoreModelRadioButton";
    public static final String ECORE_PACKAGE_NAME_TEXT_ID = "ecorePackageName";
    private static final boolean CREATE_NEW_ECORE_MODEL_BY_DEFAULT = true;
    private static final boolean CREATE_SIRIUS_REPRESENTATION_BY_DEFAULT = true;
    private static final boolean EXPOSE_JAVA_SERVICES_BY_DEFAULT = false;
    private static final boolean CREATE_DSL_FILE_BY_DEFAULT = false;
    private Button useAnExistingEcoreModelFileRadioButton;
    private Text selectedEcoreModelText;
    private Text ecorePackageNameText;
    private Button createRepresentationCheckBox;
    private Button useJavaServicesCheckBox;
    private Button createDslFileCheckBox;

    protected NewAleProjectConfigurationWizardPage() {
        super("New ALE Project");
        this.setTitle("New ALE Project");
        this.setDescription("Configure the project.");
    }

    public boolean useExistingEcoreModel() {
        if (this.useAnExistingEcoreModelFileRadioButton == null) {
            return false;
        }
        return this.useAnExistingEcoreModelFileRadioButton.getSelection();
    }

    public IPath getEcoreModelFile() {
        if (this.selectedEcoreModelText == null) {
            return Path.EMPTY;
        }
        return new Path(this.selectedEcoreModelText.getText());
    }

    public String getEcorePackageName() {
        if (this.ecorePackageNameText == null) {
            return "";
        }
        return this.ecorePackageNameText.getText().trim();
    }

    public boolean createRepresentation() {
        if (this.createRepresentationCheckBox == null) {
            return true;
        }
        return this.createRepresentationCheckBox.getSelection();
    }

    public boolean activateJava() {
        if (this.useJavaServicesCheckBox == null) {
            return false;
        }
        return this.useJavaServicesCheckBox.getSelection();
    }

    public boolean createDslFile() {
        if (this.createDslFileCheckBox == null) {
            return false;
        }
        return this.createDslFileCheckBox.getSelection();
    }

    public void setDefaultEcorePackage(String projectName) {
        this.ecorePackageNameText.setText(projectName);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(1808));
        this.createEcoreModelGroup(container);
        this.createRepresentationGroup(container);
        this.createServicesGroup(container);
        this.setControl((Control)container);
    }

    public void setVisible(boolean isVisible) {
        super.setVisible(isVisible);
        if (isVisible) {
            this.ecorePackageNameText.setFocus();
            this.setPageComplete(this.isValid());
        }
    }

    private void createEcoreModelGroup(Composite container) {
        Group group = new Group(container, 16384);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(768));
        group.setText(" Ecore model ");
        Button createNewEcoreModelFileRadioButton = new Button((Composite)group, 16400);
        createNewEcoreModelFileRadioButton.setText("Create a new Ecore model");
        createNewEcoreModelFileRadioButton.setToolTipText("A new Ecore model will be created in the model/ folder");
        createNewEcoreModelFileRadioButton.setSelection(true);
        createNewEcoreModelFileRadioButton.setData(SWTBOT_ID, (Object)CREATE_ECORE_MODEL_BUTTON_ID);
        GridDataFactory.fillDefaults().span(layout.numColumns, 1).applyTo((Control)createNewEcoreModelFileRadioButton);
        Label ecorePackageNameLabel = new Label((Composite)group, 16384);
        ecorePackageNameLabel.setText("Package name: ");
        GridDataFactory.swtDefaults().indent(LayoutConstants.getIndent(), 0).applyTo((Control)ecorePackageNameLabel);
        this.ecorePackageNameText = new Text((Composite)group, 2048);
        this.ecorePackageNameText.setData(SWTBOT_ID, (Object)ECORE_PACKAGE_NAME_TEXT_ID);
        this.ecorePackageNameText.addListener(24, e -> this.setPageComplete(this.isValid()));
        GridDataFactory.createFrom((GridData)new GridData(768)).span(layout.numColumns - 1, 1).applyTo((Control)this.ecorePackageNameText);
        this.useAnExistingEcoreModelFileRadioButton = new Button((Composite)group, 16400);
        this.useAnExistingEcoreModelFileRadioButton.setText("Use an existing Ecore model");
        this.useAnExistingEcoreModelFileRadioButton.setToolTipText("The project will be configured to reuse an existing Ecore model");
        this.useAnExistingEcoreModelFileRadioButton.setSelection(false);
        GridDataFactory.fillDefaults().span(layout.numColumns, 1).applyTo((Control)this.useAnExistingEcoreModelFileRadioButton);
        Button browseExistingEcoreButton = new Button((Composite)group, 0);
        browseExistingEcoreButton.setText("Select model...");
        browseExistingEcoreButton.setToolTipText("Opens a dialog to select an .ecore file within the workspace");
        GridDataFactory.swtDefaults().indent(LayoutConstants.getIndent(), 0).applyTo((Control)browseExistingEcoreButton);
        browseExistingEcoreButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                FilteredResourcesSelectionDialog dialog = new FilteredResourcesSelectionDialog(shell, false, (IContainer)ResourcesPlugin.getWorkspace().getRoot(), 1);
                dialog.setTitle("Select an Ecore model");
                dialog.setInitialPattern("*.ecore");
                dialog.open();
                Object[] selected = dialog.getResult();
                if (selected != null && selected.length == 1 && selected[0] instanceof IResource) {
                    IResource selectedModel = (IResource)selected[0];
                    NewAleProjectConfigurationWizardPage.this.selectedEcoreModelText.setText(selectedModel.getFullPath().toPortableString());
                }
            }
        });
        this.selectedEcoreModelText = new Text((Composite)group, 2056);
        GridDataFactory.createFrom((GridData)new GridData(768)).span(layout.numColumns - 1, 1).applyTo((Control)this.selectedEcoreModelText);
        this.selectedEcoreModelText.addListener(24, e -> {
            createNewEcoreModelFileRadioButton.setSelection(false);
            this.useAnExistingEcoreModelFileRadioButton.setSelection(true);
            this.setPageComplete(this.isValid());
        });
    }

    private void createRepresentationGroup(Composite container) {
        Group group = new Group(container, 16384);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(768));
        group.setText(" Representation ");
        if (NewAleProjectConfigurationWizardPage.SiriusPluginsAreAvailable()) {
            this.createRepresentationCheckBox = new Button((Composite)group, 32);
            this.createRepresentationCheckBox.setText("Create a Sirius representation");
            this.createRepresentationCheckBox.setToolTipText("Create an .aird representation file linked to the Ecore model in the model/ folder");
            this.createRepresentationCheckBox.setSelection(true);
        } else {
            Text siriusIsNotAvailableText = new Text((Composite)group, 8);
            siriusIsNotAvailableText.setText("Warning: Sirius UI seems not to be installed, we cannot create any representation.");
        }
    }

    private static boolean SiriusPluginsAreAvailable() {
        try {
            DialectManager.INSTANCE.equals(null);
            return true;
        }
        catch (Exception | NoClassDefFoundError e) {
            return false;
        }
    }

    private void createServicesGroup(Composite container) {
        Group group = new Group(container, 16384);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(768));
        group.setText(" Services ");
        this.useJavaServicesCheckBox = new Button((Composite)group, 32);
        this.useJavaServicesCheckBox.setText("Will expose Java services to ALE");
        this.useJavaServicesCheckBox.setToolTipText("Add the Java nature to the project, allowing the definition of ALE services");
        this.useJavaServicesCheckBox.setSelection(false);
        this.createDslFileCheckBox = new Button((Composite)group, 32);
        this.createDslFileCheckBox.setText("Define environment in a .dsl file");
        this.createDslFileCheckBox.setToolTipText("Ease integration with third-parties (GEMOC Studio, Maven) and collaboration with colleagues");
        this.createDslFileCheckBox.setSelection(false);
    }

    public boolean isValid() {
        if (this.useExistingEcoreModel()) {
            return !this.getEcoreModelFile().isEmpty();
        }
        return true;
    }
}

