/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.editor.ui.completion.collectors;

import java.util.Collection;
import lpg.runtime.IToken;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.completion.CompletionProposalUtil;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.completion.LightweightParserUtil;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.completion.QvtCompletionData;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.completion.collectors.AbstractCollector;
import org.eclipse.ocl.ecore.CollectionType;
import org.eclipse.ocl.expressions.OCLExpression;

public class IteratorShorthandCollector
extends AbstractCollector {
    private static final String ITERATOR_TOKEN_FLAG = String.valueOf(IteratorShorthandCollector.class.toString()) + "ITERATOR_TOKEN_FLAG";
    private static final int[] ZERO_DEPTH_TERMINATORS = new int[]{82};

    @Override
    protected boolean isApplicableInternal(QvtCompletionData data) {
        IToken iteratorToken = data.getParentBracingExpression(new QvtCompletionData.ITokenQualificator(){

            @Override
            public boolean isSuited(IToken token) {
                return QvtCompletionData.isKindOf(token, LightweightParserUtil.QVTO_ITERATOR_TERMINALS_WITH_IMPLICIT_ITERATOR);
            }
        }, 1, 5, 1, ZERO_DEPTH_TERMINATORS, LightweightParserUtil.OCLEXPRESSION_MANDATORY_TERMINATION_TOKENS, null);
        if (iteratorToken != null) {
            data.getUserData().put(ITERATOR_TOKEN_FLAG, iteratorToken);
            return true;
        }
        iteratorToken = data.getParentBracingExpression(new QvtCompletionData.ITokenQualificator(){

            @Override
            public boolean isSuited(IToken token) {
                return QvtCompletionData.isKindOf(token, LightweightParserUtil.OCL_ITERATOR_TERMINALS);
            }
        }, 1, 5, 1, ZERO_DEPTH_TERMINATORS, LightweightParserUtil.OCLEXPRESSION_MANDATORY_TERMINATION_TOKENS, null);
        if (iteratorToken != null) {
            data.getUserData().put(ITERATOR_TOKEN_FLAG, iteratorToken);
            return true;
        }
        return false;
    }

    @Override
    public void addPropoposals(Collection<ICompletionProposal> proposals, QvtCompletionData data) {
        EClassifier elementType;
        IToken iteratorToken = (IToken)data.getUserData().get(ITERATOR_TOKEN_FLAG);
        int accessorTokenIndex = iteratorToken.getTokenIndex() - 1;
        if (accessorTokenIndex < 0) {
            return;
        }
        IToken accessorToken = data.getPrsStream().getTokenAt(accessorTokenIndex);
        OCLExpression<EClassifier> source = LightweightParserUtil.getOclExpression(accessorToken, data, LightweightParserUtil.ParserTypeEnum.LIGHTWEIGHT_PARSER);
        if (source == null) {
            return;
        }
        EClassifier sourceType = (EClassifier)source.getType();
        if (sourceType instanceof CollectionType) {
            CollectionType collectionType = (CollectionType)sourceType;
            elementType = (EClassifier)collectionType.getElementType();
        } else {
            elementType = sourceType;
        }
        CompletionProposalUtil.addContextProposals(proposals, elementType, true, true, data);
    }
}

