/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.diverse.melange.ui.builder;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Provider;
import fr.inria.diverse.melange.ast.LanguageExtensions;
import fr.inria.diverse.melange.ast.ModelTypeExtensions;
import fr.inria.diverse.melange.ast.ModelingElementExtensions;
import fr.inria.diverse.melange.eclipse.EclipseProjectHelper;
import fr.inria.diverse.melange.lib.EcoreExtensions;
import fr.inria.diverse.melange.metamodel.melange.Language;
import fr.inria.diverse.melange.metamodel.melange.ModelType;
import fr.inria.diverse.melange.metamodel.melange.ModelTypingSpace;
import fr.inria.diverse.melange.metamodel.melange.ModelingElement;
import fr.inria.diverse.melange.processors.ExtensionPointProcessor;
import fr.inria.diverse.melange.resource.MelangeDerivedStateComputer;
import fr.inria.diverse.melange.utils.DispatchOverrider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNatureDescriptor;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.gemoc.commons.eclipse.pde.classpath.BuildPropertiesHelper;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.builder.EclipseResourceFileSystemAccess2;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.generator.IGenerator;
import org.eclipse.xtext.generator.OutputConfiguration;
import org.eclipse.xtext.generator.OutputConfigurationProvider;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.DerivedStateAwareResource;
import org.eclipse.xtext.ui.resource.XtextResourceSetProvider;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class MelangeBuilder {
    @Inject
    private IGenerator generator;
    @Inject
    private MelangeDerivedStateComputer computer;
    @Inject
    private Provider<EclipseResourceFileSystemAccess2> fileSystemAccessProvider;
    @Inject
    private OutputConfigurationProvider outputProvider;
    @Inject
    private EclipseProjectHelper eclipseHelper;
    @Inject
    private ExtensionPointProcessor extensionProcessor;
    @Inject
    @Extension
    private LanguageExtensions _languageExtensions;
    @Inject
    @Extension
    private ModelingElementExtensions _modelingElementExtensions;
    @Inject
    @Extension
    private ModelTypeExtensions _modelTypeExtensions;
    @Inject
    @Extension
    private EcoreExtensions _ecoreExtensions;
    @Inject
    @Extension
    private IQualifiedNameProvider _iQualifiedNameProvider;
    @Inject
    private DispatchOverrider dispatchWriter;
    @Inject
    private XtextResourceSetProvider rsProvider;
    private static final Logger log = Logger.getLogger(MelangeBuilder.class);

    public void generateAll(Resource res, IProject project, IProgressMonitor monitor) {
        monitor.beginTask("Generating all artifacts", 700);
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)700);
        this.generateInterfaces(res, project, (IProgressMonitor)subMonitor.split(50));
        this.generateLanguages(res, project, (IProgressMonitor)subMonitor.split(300));
        this.generateAdapters(res, project, (IProgressMonitor)subMonitor.split(300));
        this.generatePluginXml(res, project, (IProgressMonitor)subMonitor.split(10));
        this.refreshProjects(res, project, (IProgressMonitor)subMonitor.split(10));
    }

    public void generateInterfaces(Resource res, IProject project, IProgressMonitor monitor) {
        EObject _head = (EObject)IterableExtensions.head((Iterable)res.getContents());
        ModelTypingSpace root = (ModelTypingSpace)_head;
        Iterable mts = Iterables.filter((Iterable)root.getElements(), ModelType.class);
        int nb = IterableExtensions.size((Iterable)mts);
        monitor.beginTask("Generating interfaces", 10 * nb);
        Functions.Function1 _function = it -> this._modelTypeExtensions.isExtracted(it) && !this._modelTypeExtensions.isExternal(it);
        Consumer<ModelType> _function_1 = mt -> {
            boolean _not;
            boolean _isCanceled = monitor.isCanceled();
            if (_isCanceled) {
                throw new OperationCanceledException();
            }
            String _name = mt.getName();
            String _plus = "Generating interface for " + _name;
            monitor.subTask(_plus);
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Registering new EPackage for ");
            String _name_1 = mt.getName();
            _builder.append(_name_1);
            _builder.append(" in EMF registry");
            log.debug((Object)_builder);
            boolean _containsKey = EPackage.Registry.INSTANCE.containsKey((Object)((EPackage)IterableExtensions.head((Iterable)this._modelingElementExtensions.getPkgs((ModelingElement)mt))).getNsURI());
            boolean bl = _not = !_containsKey;
            if (_not) {
                EPackage.Registry.INSTANCE.put((Object)((EPackage)IterableExtensions.head((Iterable)this._modelingElementExtensions.getPkgs((ModelingElement)mt))).getNsURI(), IterableExtensions.head((Iterable)this._modelingElementExtensions.getPkgs((ModelingElement)mt)));
            }
            String ecoreUri = this._modelTypeExtensions.getInferredEcoreUri(mt);
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("Serializing Ecore interface description for ");
            String _name_2 = mt.getName();
            _builder_1.append(_name_2);
            _builder_1.append(" in ");
            _builder_1.append(ecoreUri);
            log.debug((Object)_builder_1);
            this._modelingElementExtensions.createEcore((ModelingElement)mt, ecoreUri, this._modelTypeExtensions.getUri(mt), false);
            String _substring = ecoreUri.substring(0, ecoreUri.lastIndexOf("."));
            String gmUri = String.valueOf(_substring) + ".genmodel";
            GenModel gm = this._modelTypeExtensions.createGenmodel(mt, ecoreUri, gmUri);
            this._modelTypeExtensions.generateModelTypeCode(gm);
            ArrayList exportedPkg = CollectionLiterals.newArrayList();
            Functions.Function1 _function_2 = it -> {
                String _packageName = it.getPackageName();
                return !Objects.equal((Object)_packageName, (Object)"ecore");
            };
            Consumer<GenPackage> _function_3 = p -> {
                exportedPkg.add(p.getQualifiedPackageName().toString());
                String _qualifiedPackageName = p.getQualifiedPackageName();
                String _plus_1 = String.valueOf(_qualifiedPackageName) + ".impl";
                exportedPkg.add(_plus_1);
                String _qualifiedPackageName_1 = p.getQualifiedPackageName();
                String _plus_2 = String.valueOf(_qualifiedPackageName_1) + ".util";
                exportedPkg.add(_plus_2);
            };
            IterableExtensions.filter((Iterable)this._ecoreExtensions.getAllGenPkgs(gm), (Functions.Function1)_function_2).forEach(_function_3);
            this.eclipseHelper.addExportedPackages(project, (Iterable)exportedPkg);
            monitor.worked(10);
        };
        IterableExtensions.filter((Iterable)mts, (Functions.Function1)_function).forEach(_function_1);
    }

    public void generateLanguages(Resource res, IProject project, IProgressMonitor monitor) {
        EObject _head = (EObject)IterableExtensions.head((Iterable)res.getContents());
        ModelTypingSpace root = (ModelTypingSpace)_head;
        Functions.Function1 _function = it -> this._languageExtensions.isGeneratedByMelange(it);
        Iterable toGenerate = IterableExtensions.filter((Iterable)Iterables.filter((Iterable)root.getElements(), Language.class), (Functions.Function1)_function);
        int nb = IterableExtensions.size((Iterable)toGenerate);
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(100 * nb + 10 * nb));
        subMonitor.beginTask("Generating EMF runtime for languages", 100 * nb + 10 * nb);
        Consumer<Language> _function_1 = l -> {
            try {
                boolean _notEquals;
                boolean _isCanceled = monitor.isCanceled();
                if (_isCanceled) {
                    throw new OperationCanceledException();
                }
                SubMonitor sub = subMonitor.split(100);
                String _name = l.getName();
                String _plus = "Generating runtime for " + _name;
                sub.beginTask(_plus, 100);
                String _externalRuntimeName = this._languageExtensions.getExternalRuntimeName(l);
                String _name_1 = project.getName();
                boolean bl = _notEquals = !Objects.equal((Object)_externalRuntimeName, (Object)_name_1);
                if (_notEquals) {
                    String _name_2 = l.getName();
                    String _plus_1 = "Creating new project for " + _name_2;
                    sub.subTask(_plus_1);
                    IProject newProject = null;
                    IProjectNatureDescriptor _natureDescriptor = ResourcesPlugin.getWorkspace().getNatureDescriptor("org.eclipse.gemoc.execution.sequential.javaxdsml.ide.ui.GemocSequentialLanguageNature");
                    boolean _tripleNotEquals = _natureDescriptor != null;
                    newProject = _tripleNotEquals ? this.eclipseHelper.createGemocLangEMFRuntimeProject(this._languageExtensions.getExternalRuntimeName(l), l) : this.eclipseHelper.createEMFRuntimeProject(this._languageExtensions.getExternalRuntimeName(l), l);
                    subMonitor.worked(5);
                    String _name_3 = l.getName();
                    String _plus_2 = "Serializing Ecore description for " + _name_3;
                    sub.subTask(_plus_2);
                    this._languageExtensions.createExternalEcore(l);
                    subMonitor.worked(5);
                    String _name_4 = l.getName();
                    String _plus_3 = "Serializing Genmodel for " + _name_4;
                    sub.subTask(_plus_3);
                    this._languageExtensions.createExternalGenmodel(l);
                    subMonitor.worked(5);
                    sub.subTask("Generating code");
                    this._ecoreExtensions.generateCode((GenModel)IterableExtensions.head((Iterable)this._modelingElementExtensions.getGenmodels((ModelingElement)l.getSyntax())));
                    subMonitor.worked(40);
                    String _name_5 = l.getName();
                    String _plus_4 = "Copying aspects for " + _name_5;
                    sub.subTask(_plus_4);
                    this._languageExtensions.createExternalAspects(l);
                    this._languageExtensions.addRequireBundleForAspects(l);
                    subMonitor.worked(40);
                    String _name_6 = l.getName();
                    String _plus_5 = "Updating dependencies for " + _name_6;
                    sub.subTask(_plus_5);
                    String _externalRuntimeName_1 = this._languageExtensions.getExternalRuntimeName(l);
                    this.eclipseHelper.addDependencies(project, Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{_externalRuntimeName_1})));
                    BuildPropertiesHelper.addEntryInProperty((IProject)newProject, (String)"bin.includes", (String)"plugin.xml", (IProgressMonitor)subMonitor);
                    BuildPropertiesHelper.addEntryInProperty((IProject)newProject, (String)"bin.includes", (String)"plugin.properties", (IProgressMonitor)subMonitor);
                    BuildPropertiesHelper.addEntryInProperty((IProject)newProject, (String)"bin.includes", (String)"model/", (IProgressMonitor)subMonitor);
                    String _name_7 = l.getName();
                    String _plus_6 = String.valueOf(_name_7) + ".dsl";
                    BuildPropertiesHelper.addEntryInProperty((IProject)newProject, (String)"bin.includes", (String)_plus_6, (IProgressMonitor)subMonitor);
                } else {
                    String _name_8 = l.getName();
                    String _plus_7 = "Creating EMFRuntime in current project for " + _name_8;
                    sub.subTask(_plus_7);
                    this.eclipseHelper.createEMFRuntimeInMelangeProject(project, l, monitor);
                    subMonitor.worked(5);
                    String _name_9 = l.getName();
                    String _plus_8 = "Serializing Ecore description for " + _name_9;
                    sub.subTask(_plus_8);
                    this._languageExtensions.createExternalEcore(l);
                    subMonitor.worked(5);
                    String _name_10 = l.getName();
                    String _plus_9 = "Serializing Genmodel for " + _name_10;
                    sub.subTask(_plus_9);
                    this._languageExtensions.createExternalGenmodel(l);
                    subMonitor.worked(5);
                    sub.subTask("Generating code");
                    this._ecoreExtensions.generateCode((GenModel)IterableExtensions.head((Iterable)this._modelingElementExtensions.getGenmodels((ModelingElement)l.getSyntax())));
                    subMonitor.worked(40);
                    String _name_11 = l.getName();
                    String _plus_10 = "Copying aspects for " + _name_11;
                    sub.subTask(_plus_10);
                    this._languageExtensions.createExternalAspects(l);
                    this._languageExtensions.addRequireBundleForAspects(l);
                    String _name_12 = l.getName();
                    String _plus_11 = String.valueOf(_name_12) + ".dsl";
                    BuildPropertiesHelper.addEntryInProperty((IProject)project, (String)"bin.includes", (String)_plus_11, (IProgressMonitor)subMonitor);
                    subMonitor.worked(45);
                }
                this.refreshProjects(res, project, (IProgressMonitor)subMonitor);
                this.waitForAutoBuild();
                subMonitor.worked(5);
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        };
        toGenerate.forEach(_function_1);
        this._languageExtensions.makeAllSemantics(root);
        SubMonitor sub = subMonitor.split(10 * nb);
        sub.beginTask("Rewriting dispatch", 10 * nb);
        Consumer<Language> _function_2 = l -> {
            String _name = l.getName();
            String _plus = "Rewrite dispatch for " + _name;
            sub.subTask(_plus);
            this.dispatchWriter.overrideDispatch(l, JavaCore.create((IProject)project));
            sub.worked(10);
            this._languageExtensions.createDsl(l);
        };
        toGenerate.forEach(_function_2);
        this.refreshProjects(res, project, (IProgressMonitor)subMonitor);
    }

    public void generateAdapters(Resource res, IProject project, IProgressMonitor monitor) {
        try {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            subMonitor.beginTask("Generating adapters", 100);
            ResourceSet rs = this.rsProvider.get(project);
            Resource _resource = rs.getResource(res.getURI(), true);
            DerivedStateAwareResource res2 = (DerivedStateAwareResource)_resource;
            EclipseResourceFileSystemAccess2 _get = (EclipseResourceFileSystemAccess2)this.fileSystemAccessProvider.get();
            Procedures.Procedure1 _function = f -> {
                f.setMonitor((IProgressMonitor)subMonitor.split(50));
                f.setProject(project);
            };
            EclipseResourceFileSystemAccess2 fsa = (EclipseResourceFileSystemAccess2)ObjectExtensions.operator_doubleArrow((Object)_get, (Procedures.Procedure1)_function);
            Consumer<OutputConfiguration> _function_1 = it -> fsa.getOutputConfigurations().put(it.getName(), it);
            this.outputProvider.getOutputConfigurations().forEach(_function_1);
            if (res2 instanceof DerivedStateAwareResource) {
                subMonitor.subTask("Inferring derived state");
                this.computer.inferFullDerivedState(res2);
                subMonitor.worked(50);
                subMonitor.subTask("Generating code");
                this.generator.doGenerate((Resource)res2, (IFileSystemAccess)fsa);
                IJavaProject jProject = JavaCore.create((IProject)project);
                Functions.Function1 _function_2 = it -> it.getElementName().contains(".adapters.");
                Functions.Function1 _function_3 = it -> it.getElementName();
                Iterable adapterPkgs = IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)jProject.getPackageFragments())), (Functions.Function1)_function_2), (Functions.Function1)_function_3);
                EObject _head = (EObject)IterableExtensions.head((Iterable)res2.getContents());
                QualifiedName mainPkg = this._iQualifiedNameProvider.getFullyQualifiedName((EObject)((ModelTypingSpace)_head));
                Set exportedPkgs = IterableExtensions.toSet((Iterable)adapterPkgs);
                exportedPkgs.add(mainPkg.toString());
                this.eclipseHelper.addExportedPackages(project, (Iterable)exportedPkgs);
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public void generatePluginXml(Resource res, IProject project, IProgressMonitor monitor) {
        monitor.beginTask("Generating new plugin.xml", 1);
        monitor.subTask("Generating new plugin.xml");
        try {
            EObject _head = (EObject)IterableExtensions.head((Iterable)res.getContents());
            ModelTypingSpace root = (ModelTypingSpace)_head;
            this.extensionProcessor.preProcess((EObject)root, false);
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                Exception e = (Exception)_t;
                log.error((Object)"Fatal exception", (Throwable)e);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        monitor.worked(1);
    }

    public void refreshProjects(Resource res, IProject project, IProgressMonitor monitor) {
        try {
            EObject _head = (EObject)IterableExtensions.head((Iterable)res.getContents());
            ModelTypingSpace root = (ModelTypingSpace)_head;
            Functions.Function1 _function = it -> this._languageExtensions.isGeneratedByMelange(it);
            Iterable languages = IterableExtensions.filter((Iterable)Iterables.filter((Iterable)root.getElements(), Language.class), (Functions.Function1)_function);
            int _size = IterableExtensions.size((Iterable)languages);
            int _plus = 1 + _size;
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)_plus);
            project.refreshLocal(2, (IProgressMonitor)subMonitor.split(1));
            Consumer<Language> _function_1 = l -> {
                try {
                    boolean _notEquals;
                    String _externalRuntimeName = this._languageExtensions.getExternalRuntimeName(l);
                    String _name = project.getName();
                    boolean bl = _notEquals = !Objects.equal((Object)_externalRuntimeName, (Object)_name);
                    if (_notEquals) {
                        project.getWorkspace().getRoot().getProject(this._languageExtensions.getExternalRuntimeName(l)).refreshLocal(2, (IProgressMonitor)subMonitor.split(1));
                    }
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            };
            languages.forEach(_function_1);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public void cleanAll(Resource res, IProject project, IProgressMonitor monitor) {
        monitor.beginTask("Cleaning old derived artifacts", 60);
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)60);
        monitor.subTask("Cleaning generated interfaces");
        this.cleanInterfaces(res, project, (IProgressMonitor)subMonitor.split(20));
        monitor.subTask("Cleaning generated adapters");
        this.cleanAdapters(res, project, (IProgressMonitor)subMonitor.split(20));
        monitor.subTask("Cleaning generated projects");
        this.cleanLanguages(res, project, (IProgressMonitor)subMonitor.split(20));
    }

    public void cleanLanguages(Resource res, IProject project, IProgressMonitor monitor) {
        EObject _head = (EObject)IterableExtensions.head((Iterable)res.getContents());
        ModelTypingSpace root = (ModelTypingSpace)_head;
        ArrayList danglingBundles = CollectionLiterals.newArrayList();
        Functions.Function1 _function = it -> this._languageExtensions.isGeneratedByMelange(it);
        Consumer<Language> _function_1 = l -> {
            try {
                String runtimeName = this._languageExtensions.getExternalRuntimeName(l);
                String _name = project.getName();
                boolean _equals = Objects.equal((Object)_name, (Object)runtimeName);
                if (_equals) {
                    IFolder runtimeFolder = project.getFolder("src-model-gen/" + runtimeName);
                    runtimeFolder.delete(true, monitor);
                } else {
                    IProject runtimeProject = project.getWorkspace().getRoot().getProject(runtimeName);
                    runtimeProject.delete(true, true, monitor);
                    danglingBundles.add(runtimeName);
                }
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        };
        IterableExtensions.filter((Iterable)Iterables.filter((Iterable)root.getElements(), Language.class), (Functions.Function1)_function).forEach(_function_1);
        this.eclipseHelper.removeDependencies(project, (Iterable)danglingBundles);
    }

    public void cleanInterfaces(Resource res, IProject project, IProgressMonitor monitor) {
        try {
            IFolder modelGenFolder = project.getFolder("model-gen/");
            boolean _exists = modelGenFolder.exists();
            if (_exists) {
                Consumer<IResource> _function = it -> {
                    try {
                        it.delete(true, monitor);
                    }
                    catch (Throwable _e) {
                        throw Exceptions.sneakyThrow((Throwable)_e);
                    }
                };
                ((List)Conversions.doWrapArray((Object)modelGenFolder.members())).forEach(_function);
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public void cleanAdapters(Resource res, IProject project, IProgressMonitor monitor) {
        try {
            IFolder srcGenFolder = project.getFolder("src-gen/");
            boolean _exists = srcGenFolder.exists();
            if (_exists) {
                Consumer<IResource> _function = it -> {
                    try {
                        it.delete(true, monitor);
                    }
                    catch (Throwable _e) {
                        throw Exceptions.sneakyThrow((Throwable)_e);
                    }
                };
                ((List)Conversions.doWrapArray((Object)srcGenFolder.members())).forEach(_function);
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private void waitForAutoBuild() {
        boolean wasInterrupted = false;
        do {
            try {
                Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, null);
                wasInterrupted = false;
            }
            catch (Throwable _t) {
                if (_t instanceof OperationCanceledException) {
                    OperationCanceledException e = (OperationCanceledException)_t;
                    log.error((Object)e);
                    continue;
                }
                if (_t instanceof InterruptedException) {
                    wasInterrupted = true;
                    continue;
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        } while (wasInterrupted);
    }
}

