/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.commons.utils;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.LinkedBlockingQueue;

public class ExtensibleInputStream
extends InputStream {
    LinkedBlockingQueue<InputStream> messages = new LinkedBlockingQueue();

    @Override
    public int read() throws IOException {
        this.waitForMessage();
        InputStream current = this.messages.peek();
        int c = current.read();
        if (c != -1) {
            return c;
        }
        this.messages.poll();
        this.waitForMessage();
        current = this.messages.peek();
        return current.read();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessage(String message) {
        this.messages.add(new ByteArrayInputStream(message.getBytes()));
        ExtensibleInputStream extensibleInputStream = this;
        synchronized (extensibleInputStream) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForMessage() {
        if (this.messages.isEmpty()) {
            try {
                ExtensibleInputStream extensibleInputStream = this;
                synchronized (extensibleInputStream) {
                    this.wait();
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

