/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.common.ui.services.editor;

import org.eclipse.core.runtime.Plugin;
import org.eclipse.gmf.runtime.common.core.service.AbstractProvider;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.common.ui.services.editor.IEditorProvider;
import org.eclipse.gmf.runtime.common.ui.services.editor.OpenEditorOperation;
import org.eclipse.gmf.runtime.common.ui.services.internal.CommonUIServicesDebugOptions;
import org.eclipse.gmf.runtime.common.ui.services.internal.CommonUIServicesPlugin;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractEditorProvider
extends AbstractProvider
implements IEditorProvider {
    @Override
    public IEditorPart openEditor(IEditorInput editorInput) {
        try {
            return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor(editorInput, this.getEditorId(editorInput));
        }
        catch (PartInitException e) {
            Trace.catching((Plugin)CommonUIServicesPlugin.getDefault(), (String)CommonUIServicesDebugOptions.EXCEPTIONS_CATCHING, ((Object)((Object)CommonUIServicesPlugin.getDefault())).getClass(), (String)"openEditor", (Throwable)e);
            Log.error((Plugin)CommonUIServicesPlugin.getDefault(), (int)1, (String)"openEditor", (Throwable)e);
            return null;
        }
    }

    public boolean provides(IOperation operation) {
        return operation instanceof OpenEditorOperation && this.canOpen(((OpenEditorOperation)operation).getEditorInput());
    }

    protected abstract String getEditorId(IEditorInput var1);

    protected abstract boolean canOpen(IEditorInput var1);
}

