/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.addon.eventscheduling.timeline.ui.commands;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gemoc.dsl.debug.ide.sirius.ui.DebugSiriusIdeUiPlugin;
import org.eclipse.gemoc.dsl.debug.ide.sirius.ui.SiriusEditorUtils;
import org.eclipse.gemoc.dsl.debug.ide.ui.EMFEditorUtils;
import org.eclipse.gemoc.timeline.editpart.PossibleStepEditPart;
import org.eclipse.gemoc.timeline.model.PossibleStep;
import org.eclipse.gemoc.trace.commons.model.helper.StepHelper;
import org.eclipse.gemoc.trace.commons.model.trace.MSEOccurrence;
import org.eclipse.gemoc.trace.commons.model.trace.Step;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.ui.business.api.dialect.DialectEditor;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class ShowCallerHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        PossibleStep step;
        Object element;
        Object selected;
        ISelection selection = HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection && (selected = ((IStructuredSelection)selection).getFirstElement()) instanceof PossibleStepEditPart && (element = (step = ((PossibleStepEditPart)selected).getModel()).getPossibleStep()) instanceof Step) {
            LinkedHashSet<EObject> callers = new LinkedHashSet<EObject>();
            for (MSEOccurrence mseOccurrence : StepHelper.collectAllMSEOccurrences((Step)((Step)element))) {
                if (mseOccurrence.getMse().getCaller() == null) continue;
                callers.add(mseOccurrence.getMse().getCaller());
            }
            this.openEditorsAndShowInstructions(new ArrayList<EObject>(callers));
        }
        return null;
    }

    protected Map<IEditorPart, List<EObject>> openEditorsAndShowInstructions(List<EObject> instructions) {
        LinkedHashMap<IEditorPart, List<EObject>> result = new LinkedHashMap<IEditorPart, List<EObject>>();
        for (EObject eObject : instructions) {
            IEditorPart editor = this.openEditor(eObject);
            ArrayList<EObject> eObjects = (ArrayList<EObject>)result.get(editor);
            if (eObjects == null) {
                eObjects = new ArrayList<EObject>();
                result.put(editor, eObjects);
            }
            eObjects.add(eObject);
        }
        for (Map.Entry entry : result.entrySet()) {
            if (entry.getKey() instanceof DialectEditor) {
                SiriusEditorUtils.showInstructions((DialectEditor)((DialectEditor)entry.getKey()), instructions);
                continue;
            }
            ArrayList<URI> instructionURIs = new ArrayList<URI>();
            for (EObject instruction : instructions) {
                URI instructionURI = EcoreUtil.getURI((EObject)instruction);
                if (instructionURI == null) continue;
                instructionURIs.add(instructionURI);
            }
            EMFEditorUtils.selectInstructions((IEditorPart)((IEditorPart)entry.getKey()), instructionURIs);
        }
        return result;
    }

    private IEditorPart openEditor(EObject instruction) {
        IEditorPart res;
        URI instructionURI = EcoreUtil.getURI((EObject)instruction);
        if (instructionURI != null) {
            List representations;
            Object representation;
            List sessions;
            Session inSession = SessionManager.INSTANCE.getSession(instruction);
            Object session = inSession != null ? inSession : ((sessions = SiriusEditorUtils.getSessions((URI)instructionURI)).size() > 1 ? this.selectSession(sessions) : (sessions.size() == 1 ? (Session)sessions.get(0) : null));
            res = session != null ? ((representation = (representations = SiriusEditorUtils.getRepresentations((Session)session, (URI)instructionURI)).size() > 1 ? this.selectRepresentation(representations) : (representations.size() == 1 ? (DRepresentation)representations.get(0) : null)) != null ? DialectUIManager.INSTANCE.openEditor(session, representation, (IProgressMonitor)new NullProgressMonitor()) : this.openEMFEditor(instruction)) : this.openEMFEditor(instruction);
        } else {
            return null;
        }
        return res;
    }

    private IEditorPart openEMFEditor(EObject instruction) {
        IEditorPart editor = null;
        try {
            IEditorInput input = EMFEditorUtils.getEditorInput((Object)instruction);
            String editorId = EMFEditorUtils.getEditorID((IEditorInput)input, (Object)instruction);
            editor = input != null && editorId != null ? PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor(input, editorId) : null;
        }
        catch (PartInitException e) {
            DebugSiriusIdeUiPlugin.getPlugin().log((Object)e);
        }
        return editor;
    }

    protected Session selectSession(List<Session> sessions) {
        return sessions.get(0);
    }

    protected DRepresentation selectRepresentation(List<DRepresentation> representations) {
        return representations.get(0);
    }
}

