/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.structures;

import java.util.Iterator;
import java.util.Map;

public final class Structures {
    public static final String NULL = "null";

    public static String toIterableString(Iterable<?> iterable_p) {
        if (iterable_p == null) {
            return NULL;
        }
        StringBuilder builder = new StringBuilder();
        builder.append('[');
        Iterator<?> it = iterable_p.iterator();
        while (it.hasNext()) {
            Object element = it.next();
            String segment = element == iterable_p ? "(this collection)" : (element == null ? NULL : element.toString());
            builder.append(segment);
            if (!it.hasNext()) continue;
            builder.append('.');
        }
        builder.append(']');
        return builder.toString();
    }

    public static String toMapEntryString(Map.Entry<?, ?> entry_p) {
        if (entry_p == null) {
            return NULL;
        }
        StringBuilder builder = new StringBuilder();
        Object key = entry_p.getKey();
        String keySegment = key == entry_p ? "(this entry)" : (key == null ? NULL : key.toString());
        Object value = entry_p.getValue();
        String valueSegment = value == entry_p ? "(this entry)" : (value == null ? NULL : value.toString());
        builder.append(keySegment);
        builder.append(':');
        builder.append(valueSegment);
        return builder.toString();
    }

    public static String toMapString(Map map_p) {
        if (map_p == null) {
            return NULL;
        }
        StringBuilder builder = new StringBuilder();
        builder.append('[');
        Iterator it = map_p.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String segment = entry == map_p ? "(this)" : (entry == null ? NULL : entry.toString());
            builder.append(segment);
            if (!it.hasNext()) continue;
            builder.append(',');
        }
        builder.append(']');
        return builder.toString();
    }
}

