/*
 * Decompiled with CFR 0.152.
 */
package fr.kairos.timesquare.ccsl.simple;

import fr.kairos.timesquare.ccsl.IRelation;
import java.util.HashMap;

public final class Relation
implements IRelation {
    private String relationName;
    private HashMap<String, Integer> params;
    private String left;
    private String right;

    public Relation(String relationName, String left, String right) {
        this.relationName = relationName;
        this.left = left;
        this.right = right;
    }

    public Relation set(String name, int value) {
        if (this.params == null) {
            this.params = new HashMap();
        }
        this.params.put(name, value);
        return this;
    }

    @Override
    public int getIntParam(String name, int defaut) {
        if (this.params != null && this.params.containsKey(name)) {
            return this.params.get(name);
        }
        return defaut;
    }

    public String toString() {
        return String.valueOf(this.relationName) + " " + this.left + " " + this.right;
    }

    @Override
    public String getLeft() {
        return this.left;
    }

    @Override
    public String getRight() {
        return this.right;
    }

    @Override
    public String getConstraintName() {
        return this.relationName;
    }

    public void copyParamFrom(IRelation rel) {
        if (rel instanceof Relation) {
            Relation r = (Relation)rel;
            if (r.params != null) {
                for (String k : r.params.keySet()) {
                    this.set(k, r.params.get(k));
                }
            }
        } else {
            throw new RuntimeException("Do not know how to copy params");
        }
    }
}

