/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.execution.concurrent.ccsljavaengine.dse;

import fr.inria.aoste.trace.EventOccurrence;
import fr.inria.aoste.trace.ModelElementReference;
import fr.inria.aoste.trace.Reference;
import fr.inria.aoste.trace.TraceFactory;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.api.dse.IMoccmlMSEStateController;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.api.moc.ICCSLSolver;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.api.moc.ISolver;
import org.eclipse.gemoc.moccml.mapping.feedback.feedback.ModelSpecificEvent;

public class DefaultMSEStateController
implements IMoccmlMSEStateController {
    private Resource feedbackModelResource = null;
    public Map<String, Boolean> _mseNextStates = new HashMap<String, Boolean>();

    private void applyForcePresence(ICCSLSolver solver, EventOccurrence eventOccurrence) {
        solver.forceEventOccurrence(eventOccurrence);
    }

    private void applyForceAbsence(ICCSLSolver solver, EventOccurrence eventOccurrence) {
        solver.forbidEventOccurrence(eventOccurrence);
    }

    private EventOccurrence createEventoccurence(String mseURI) {
        ModelSpecificEvent mse = (ModelSpecificEvent)this.feedbackModelResource.getEObject(mseURI);
        EventOccurrence eo = TraceFactory.eINSTANCE.createEventOccurrence();
        ModelElementReference mer = TraceFactory.eINSTANCE.createModelElementReference();
        mer.getElementRef().add((Object)mse.getSolverEvent().eContainer().eContainer());
        mer.getElementRef().add((Object)mse.getSolverEvent().eContainer());
        mer.getElementRef().add((Object)mse.getSolverEvent());
        eo.setReferedElement((Reference)mer);
        return eo;
    }

    public void applyMSEFutureStates(ICCSLSolver solver) {
        for (Map.Entry<String, Boolean> entry : this._mseNextStates.entrySet()) {
            EventOccurrence eo = this.createEventoccurence(entry.getKey());
            if (entry.getValue().booleanValue()) {
                this.applyForcePresence(solver, eo);
                continue;
            }
            this.applyForceAbsence(solver, eo);
        }
    }

    public void forcePresenceInTheFuture(ModelSpecificEvent mse) {
        this.setFutureClockState(mse, true);
    }

    public void forceAbsenceTickInTheFuture(ModelSpecificEvent mse) {
        this.setFutureClockState(mse, false);
    }

    private void setFutureClockState(ModelSpecificEvent mse, Boolean willTick) {
        String mseURI = this.feedbackModelResource.getURIFragment((EObject)mse);
        this._mseNextStates.put(mseURI, willTick);
    }

    public void freeInTheFuture(String mseURI) {
        HashSet<Map.Entry<String, Boolean>> allEntrySet = new HashSet<Map.Entry<String, Boolean>>(this._mseNextStates.entrySet());
        for (Map.Entry entry : allEntrySet) {
            if (((String)entry.getKey()).compareTo(mseURI) != 0) continue;
            this._mseNextStates.remove(entry.getKey());
        }
    }

    public void applyMSEFutureStates(ISolver solver) {
        if (solver instanceof ICCSLSolver) {
            this.applyMSEFutureStates((ICCSLSolver)solver);
        }
    }

    public void setFeedBackModelResource(Resource resFeedbackModel) {
        this.feedbackModelResource = resFeedbackModel;
    }

    public Resource getFeedBackModelResource() {
        return this.feedbackModelResource;
    }
}

