/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.vcd.model.visitor;

import fr.inria.aoste.timesquare.vcd.IVcdDiagram;
import fr.inria.aoste.timesquare.vcd.model.VCDDefinitions;
import fr.inria.aoste.timesquare.vcd.model.visitor.TraceCollector;
import fr.inria.aoste.timesquare.vcd.model.visitor.VarCollector;
import fr.inria.aoste.timesquare.vcd.preferences.VcdColorPreferences;
import fr.inria.aoste.timesquare.vcd.view.Iupdate;
import fr.inria.aoste.timesquare.vcd.view.VcdDiagram;
import fr.inria.aoste.timesquare.vcd.view.VcdFactory;
import org.eclipse.swt.widgets.Shell;

public class Collector {
    private TraceCollector _traceCollector;
    private VCDDefinitions _vcdDefinitions;
    private Iupdate _vcdDiagram = null;
    private static boolean _block = true;

    public VcdFactory collect(VCDDefinitions vcdDef, VcdColorPreferences mca) {
        VcdFactory factory = new VcdFactory(mca);
        VarCollector varC = new VarCollector(vcdDef.getArraylistDeclarationCommand());
        vcdDef.visit(varC);
        factory.setVcdDef(vcdDef);
        this._traceCollector = new TraceCollector(varC, factory);
        vcdDef.setFactory(factory);
        vcdDef.visit(this._traceCollector);
        this._vcdDefinitions = vcdDef;
        return factory;
    }

    public static VcdDiagram drawInWindow(VCDDefinitions vcdDef) {
        Shell shell = new Shell();
        VcdColorPreferences mca = VcdColorPreferences.createColor();
        vcdDef.setFactory(new VcdFactory(mca));
        VcdDiagram window = new VcdDiagram(shell, "VCD viewer", vcdDef.getFactory());
        Collector.drawInEditor(window, vcdDef, mca);
        window.setBlockOnOpen(_block);
        window.create();
        window.getShell().setActive();
        window.open();
        return window;
    }

    public static void drawInEditor(IVcdDiagram editor, VCDDefinitions vcdDef, VcdColorPreferences mca) {
        Collector.drawInEditor(editor, vcdDef, "VCD viewer", mca);
    }

    public static void drawInEditor(IVcdDiagram editor, VCDDefinitions vcdDef, String name, VcdColorPreferences mca) {
        Collector co = new Collector();
        VcdFactory factory = co.collect(vcdDef, mca);
        Collector.drawInEditor(editor, factory, name, co);
    }

    public static void drawInEditor(IVcdDiagram editor, VcdFactory vcdFactory, String name, Collector collector) {
        editor.setTc(collector._traceCollector);
        editor.setVcdModel(collector._vcdDefinitions);
        editor.setVcdFactory(vcdFactory);
        vcdFactory.setVcddia(editor);
        collector._vcdDiagram = (Iupdate)((Object)editor);
    }

    public final Iupdate getVcdDiagram() {
        return this._vcdDiagram;
    }

    public static final void setBlock(boolean block) {
        _block = block;
    }

    public static final boolean isBlock() {
        return _block;
    }
}

