/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.vcd.view;

import fr.inria.aoste.timesquare.utils.console.ErrorConsole;
import fr.inria.aoste.timesquare.vcd.IVcd;
import fr.inria.aoste.timesquare.vcd.ListConnections;
import fr.inria.aoste.timesquare.vcd.figure.Balise;
import fr.inria.aoste.timesquare.vcd.figure.ConstraintsConnection;
import fr.inria.aoste.timesquare.vcd.model.Description;
import fr.inria.aoste.timesquare.vcd.model.IVar;
import fr.inria.aoste.timesquare.vcd.model.VcdChopboxAnchor;
import fr.inria.aoste.timesquare.vcd.model.comment.ConstraintCommentCommand;
import fr.inria.aoste.timesquare.vcd.model.comment.IConstraintData;
import fr.inria.aoste.timesquare.vcd.preferences.VcdColorPreferences;
import fr.inria.aoste.timesquare.vcd.view.Eventline;
import fr.inria.aoste.timesquare.vcd.view.IConstructContraint;
import fr.inria.aoste.timesquare.vcd.view.figure.Draw1;
import fr.inria.aoste.timesquare.vcd.view.figure.ExtendFigure;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.XYAnchor;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.ToolItem;

public class ConstraintsFactory
implements IConstructContraint {
    private ListConnections _listConnnections;
    private IVcd _vdt;
    private VcdColorPreferences _mca;

    public ConstraintsFactory(ListConnections list, IVcd vdt) {
        this._listConnnections = list;
        this._vdt = vdt;
        this._mca = vdt.getColorPreferences();
        vdt.getVcdFactory().setConstraintsFactory(this);
    }

    public VcdColorPreferences getMca() {
        return this._mca;
    }

    @Override
    public void addToList(ArrayList<ConstraintsConnection> listSync, ConstraintsConnection poly) {
        ConstraintsConnection polyc = poly;
        if (polyc.isGlobal() == null) {
            ErrorConsole.println((String)("Warning :  " + poly.getComment() + " must be set Global Flag "));
            System.out.println("Warning :  " + poly.getComment() + " must be set Global Flag ");
        }
        if (polyc.getComment() == null) {
            ErrorConsole.println((String)"Warning :  must be set  Comment Flag  ");
            System.out.println("Warning :  must be set  Comment Flag   ");
        }
        Iterator<ConstraintsConnection> it = listSync.iterator();
        boolean state = true;
        IFigure startAnchor1 = null;
        IFigure startAnchor2 = null;
        IFigure endAnchor1 = null;
        IFigure endAnchor2 = null;
        block0: while (it.hasNext()) {
            Rectangle bounds;
            ConstraintsConnection pc = it.next();
            Boolean b1 = pc.isGlobal();
            Boolean b2 = poly.isGlobal();
            if (b1 == null && b2 != null || b1 != null && b2 == null || b1 != null && b2 != null && b1.booleanValue() != b2.booleanValue() || pc.getComment() != poly.getComment()) continue;
            if (pc.getTargetAnchor() != null && polyc.getSourceAnchor() != null && polyc.getTargetAnchor() != null && pc.getSourceAnchor() != null) {
                Rectangle rect;
                startAnchor1 = pc.getSourceAnchor().getOwner();
                startAnchor2 = polyc.getSourceAnchor().getOwner();
                endAnchor1 = pc.getTargetAnchor().getOwner();
                endAnchor2 = polyc.getTargetAnchor().getOwner();
                if (startAnchor1 instanceof PolylineConnection && startAnchor2 instanceof PolylineConnection && endAnchor1 instanceof PolylineConnection && endAnchor2 instanceof PolylineConnection && ((PolylineConnection)startAnchor1).getPoints().getBounds().equals((Object)((PolylineConnection)startAnchor2).getPoints().getBounds()) && ((PolylineConnection)endAnchor1).getPoints().getBounds().equals((Object)((PolylineConnection)endAnchor2).getPoints().getBounds())) {
                    state = false;
                    listSync.remove((Object)pc);
                    if (this._vdt.getCanvas().getContents().getChildren().contains((Object)pc)) {
                        this._vdt.getCanvas().getContents().remove((IFigure)pc);
                    }
                    Rectangle bounds2 = pc.getBounds();
                    this._vdt.getCanvas().redraw(bounds2.x, bounds2.y, bounds2.width, bounds2.height, true);
                    break;
                }
                if (startAnchor1 instanceof RectangleFigure && startAnchor2 instanceof RectangleFigure && endAnchor1 instanceof RectangleFigure && endAnchor2 instanceof RectangleFigure) {
                    Rectangle rect1 = new Rectangle(((RectangleFigure)startAnchor1).getBounds());
                    Rectangle rect2 = new Rectangle(((RectangleFigure)endAnchor1).getBounds());
                    if (rect1.expand(5, 5).intersects(((RectangleFigure)startAnchor2).getBounds()) && rect2.expand(5, 5).intersects(((RectangleFigure)endAnchor2).getBounds())) {
                        state = false;
                        listSync.remove((Object)pc);
                        if (this._vdt.getCanvas().getContents().getChildren().contains((Object)pc)) {
                            this._vdt.getCanvas().getContents().remove((IFigure)pc);
                        }
                        Rectangle bounds3 = pc.getBounds();
                        this._vdt.getCanvas().redraw(bounds3.x, bounds3.y, bounds3.width, bounds3.height, true);
                        break;
                    }
                }
                if (startAnchor1 instanceof PolylineConnection && startAnchor2 instanceof PolylineConnection && endAnchor1 instanceof RectangleFigure && endAnchor2 instanceof RectangleFigure && ((PolylineConnection)startAnchor1).getPoints().getBounds().equals((Object)((PolylineConnection)startAnchor2).getPoints().getBounds()) && (rect = new Rectangle(((RectangleFigure)endAnchor1).getBounds())).expand(5, 5).intersects(((RectangleFigure)endAnchor2).getBounds())) {
                    state = false;
                    listSync.remove((Object)pc);
                    if (this._vdt.getCanvas().getContents().getChildren().contains((Object)pc)) {
                        this._vdt.getCanvas().getContents().remove((IFigure)pc);
                    }
                    bounds = pc.getBounds();
                    this._vdt.getCanvas().redraw(bounds.x, bounds.y, bounds.width, bounds.height, true);
                    break;
                }
                if (!(startAnchor1 instanceof RectangleFigure) || !(startAnchor2 instanceof RectangleFigure) || !(endAnchor1 instanceof PolylineConnection) || !(endAnchor2 instanceof PolylineConnection) || !(rect = new Rectangle(((RectangleFigure)startAnchor2).getBounds())).expand(5, 5).intersects(((RectangleFigure)startAnchor1).getBounds()) || !((PolylineConnection)endAnchor1).getPoints().getBounds().equals((Object)((PolylineConnection)endAnchor2).getPoints().getBounds())) continue;
                state = false;
                listSync.remove((Object)pc);
                if (this._vdt.getCanvas().getContents().getChildren().contains((Object)pc)) {
                    this._vdt.getCanvas().getContents().remove((IFigure)pc);
                }
                bounds = pc.getBounds();
                this._vdt.getCanvas().redraw(bounds.x, bounds.y, bounds.width, bounds.height, true);
                break;
            }
            if (polyc.getPoints().size() <= 2) continue;
            int i = 0;
            while (i < pc.getPoints().size()) {
                if (i != pc.getPoints().size() - 1) {
                    if (!pc.getPoints().getPoint(i).equals((Object)polyc.getPoints().getPoint(i))) {
                        continue block0;
                    }
                } else {
                    state = false;
                    listSync.remove((Object)pc);
                    this._vdt.getCanvas().getContents().remove((IFigure)pc);
                    bounds = pc.getBounds();
                    this._vdt.getCanvas().redraw(bounds.x, bounds.y, bounds.width, bounds.height, true);
                    continue block0;
                }
                ++i;
            }
        }
        if (state) {
            listSync.add(poly);
        }
    }

    @Override
    public ConstraintsConnection constructCoincidenceConnection(Color color, Draw1 f1, Draw1 f2) {
        ConstraintsConnection c = new ConstraintsConnection();
        c.setForegroundColor(color);
        c.setLineWidth(2);
        c.setOpaque(true);
        ChopboxAnchor sourceAnchor = new ChopboxAnchor((IFigure)f1);
        ChopboxAnchor targetAnchor = new ChopboxAnchor((IFigure)f2);
        c.setSourceAnchor((ConnectionAnchor)sourceAnchor);
        c.setTargetAnchor((ConnectionAnchor)targetAnchor);
        PolygonDecoration decoration = new PolygonDecoration();
        PointList decorationPointList = new PointList();
        decorationPointList.addPoint(-2, 0);
        decorationPointList.addPoint(-1, 1);
        decorationPointList.addPoint(0, 0);
        decorationPointList.addPoint(-1, -1);
        decoration.setTemplate(decorationPointList);
        c.setTargetDecoration((RotatableDecoration)decoration);
        c.setSourceDecoration((RotatableDecoration)decoration);
        c.getInstants().add(f1.getInstant());
        c.getInstants().add(f2.getInstant());
        return c;
    }

    @Override
    public ConstraintsConnection constructCoincidenceConnection(Color color, Eventline c1, int c1_tickNumber, Eventline c2, int c2_tickNumber) {
        int c1TickInstant = c1.getTickInstants().get(c1_tickNumber - 1);
        int c2TickInstant = c2.getTickInstants().get(c2_tickNumber - 1);
        ConstraintsConnection c = new ConstraintsConnection();
        c.setForegroundColor(color);
        c.setLineWidth(2);
        c.setOpaque(true);
        VcdChopboxAnchor sourceAnchor = new VcdChopboxAnchor((IFigure)c1, c1TickInstant);
        VcdChopboxAnchor targetAnchor = new VcdChopboxAnchor((IFigure)c2, c2TickInstant);
        c.setSourceAnchor((ConnectionAnchor)sourceAnchor);
        c.setTargetAnchor((ConnectionAnchor)targetAnchor);
        PolygonDecoration decoration = new PolygonDecoration();
        decoration.setTemplate(PolygonDecoration.TRIANGLE_TIP);
        c.setTargetDecoration((RotatableDecoration)decoration);
        c.setSourceDecoration((RotatableDecoration)decoration);
        return c;
    }

    @Override
    public ConstraintsConnection constructDashConnection(Color color, Eventline c1, int c1_tickNumber, Eventline c2, int c2_tickNumber, boolean empty) {
        int c1TickInstant = c1.getTickInstants().get(c1_tickNumber - 1);
        int c2TickInstant = c2.getTickInstants().get(c2_tickNumber - 1);
        ConstraintsConnection c = new ConstraintsConnection();
        c.setForegroundColor(color);
        c.setLineStyle(2);
        c.setLineWidth(2);
        c.setOpaque(true);
        VcdChopboxAnchor sourceAnchor = new VcdChopboxAnchor((IFigure)c1, c1TickInstant);
        VcdChopboxAnchor targetAnchor = new VcdChopboxAnchor((IFigure)c2, c2TickInstant);
        c.setSourceAnchor((ConnectionAnchor)sourceAnchor);
        c.setTargetAnchor((ConnectionAnchor)targetAnchor);
        PolygonDecoration decoration = new PolygonDecoration();
        decoration.setTemplate(PolygonDecoration.TRIANGLE_TIP);
        if (empty) {
            decoration.setForegroundColor(color);
            decoration.setBackgroundColor(this._mca.colorBlack());
        }
        c.setTargetDecoration((RotatableDecoration)decoration);
        return c;
    }

    @Override
    public ConstraintsConnection constructDashConnection(Color color, Draw1 f1, Draw1 f2, boolean empty) {
        ConstraintsConnection c = new ConstraintsConnection();
        c.setForegroundColor(color);
        c.setLineStyle(2);
        c.setLineWidth(2);
        c.setOpaque(true);
        ChopboxAnchor sourceAnchor = new ChopboxAnchor((IFigure)f1);
        ChopboxAnchor targetAnchor = new ChopboxAnchor((IFigure)f2);
        c.setSourceAnchor((ConnectionAnchor)sourceAnchor);
        c.setTargetAnchor((ConnectionAnchor)targetAnchor);
        PolygonDecoration decoration = new PolygonDecoration();
        decoration.setTemplate(PolygonDecoration.TRIANGLE_TIP);
        if (empty) {
            decoration.setForegroundColor(color);
            decoration.setBackgroundColor(this._mca.colorBlack());
        }
        c.setTargetDecoration((RotatableDecoration)decoration);
        c.getInstants().add(f1.getInstant());
        c.getInstants().add(f2.getInstant());
        return c;
    }

    @Override
    public ConstraintsConnection constructConnection(Color color, IFigure f1, Point f2) {
        ConstraintsConnection c = new ConstraintsConnection();
        c.setForegroundColor(color);
        c.setLineWidth(2);
        c.setOpaque(true);
        ChopboxAnchor sourceAnchor = new ChopboxAnchor(f1);
        XYAnchor targetAnchor = new XYAnchor(f2);
        c.setSourceAnchor((ConnectionAnchor)sourceAnchor);
        c.setTargetAnchor((ConnectionAnchor)targetAnchor);
        return c;
    }

    @Override
    public ConstraintsConnection constructPolylineConnection(Color color, Point pt1, Point pt2) {
        ConstraintsConnection poly = new ConstraintsConnection();
        poly.setPoints(new PointList());
        poly.setForegroundColor(color);
        poly.setOutlineXOR(true);
        poly.setLineWidth(2);
        poly.setOpaque(true);
        poly.addPoint(pt1);
        poly.addPoint(pt2);
        return poly;
    }

    @Override
    public int synchrone(String name, int date) {
        ArrayList<ExtendFigure> figures = this._vdt.getVcdFactory().getNameforfigures().get(name);
        int n = 0;
        for (IFigure iFigure : figures) {
            if (((PolylineConnection)iFigure).getLocation().x == date) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    @Override
    public int firstAfter(String name, int date) {
        ArrayList<ExtendFigure> figures = this._vdt.getVcdFactory().getNameforfigures().get(name);
        int n = 0;
        for (IFigure iFigure : figures) {
            if (((PolylineConnection)iFigure).getLocation().x >= date) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    @Override
    public int firstAfterStrict(String name, int date) {
        ArrayList<ExtendFigure> figures = this._vdt.getVcdFactory().getNameforfigures().get(name);
        int n = 0;
        for (IFigure iFigure : figures) {
            if (((PolylineConnection)iFigure).getLocation().x > date) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    @Override
    public int lastBefore(String name, int px) {
        ArrayList<ExtendFigure> figures = this._vdt.getVcdFactory().getNameforfigures().get(name);
        int n = 0;
        int k = -1;
        for (IFigure iFigure : figures) {
            if (((PolylineConnection)iFigure).getLocation().x < px) {
                k = n;
            }
            ++n;
        }
        return k;
    }

    @Override
    public int lastBeforeweak(String name, int px) {
        ArrayList<ExtendFigure> figures = this._vdt.getVcdFactory().getNameforfigures().get(name);
        int n = 0;
        int k = -1;
        for (IFigure iFigure : figures) {
            if (((PolylineConnection)iFigure).getLocation().x <= px) {
                k = n;
            }
            ++n;
        }
        return k;
    }

    public void drawOneTickConstraints2(IFigure fig, ConstraintCommentCommand cc, String currentclock) {
        Rectangle bounds;
        Dimension dim;
        if (cc.getClock().equals(currentclock)) {
            switch (cc.getFunction()) {
                case _filteredby: 
                case _alternateswith: 
                case _synchronizeswith: 
                case _sampledon: 
                case _sustains: 
                case _precedes: 
                case _isperiodicon: {
                    if (cc.getConstraints() == null || !cc.getConstraints().haveAllClockVisible() || !(fig instanceof Draw1)) break;
                    cc.getConstraints().draw((Draw1)fig, currentclock);
                    break;
                }
                case _restrictedto: {
                    break;
                }
                case _oneshoton: {
                    break;
                }
            }
            for (IFigure iFigure : this._listConnnections.getListConstraints()) {
                dim = this._vdt.getCanvas().getContents().getPreferredSize();
                this._vdt.getCanvas().getContents().add(iFigure);
                bounds = iFigure.getBounds();
                this._vdt.getCanvas().redraw(bounds.x, bounds.y, bounds.width, bounds.height, true);
                this._vdt.getCanvas().getContents().setPreferredSize(dim);
            }
        }
        if (cc.getReferenceClocks().contains(currentclock)) {
            switch (cc.getFunction()) {
                case _filteredby: 
                case _alternateswith: 
                case _synchronizeswith: 
                case _sampledon: 
                case _sustains: 
                case _precedes: 
                case _isperiodicon: {
                    if (cc.getConstraints() == null || !cc.getConstraints().haveAllClockVisible() || !(fig instanceof Draw1)) break;
                    cc.getConstraints().draw((Draw1)fig, currentclock);
                    break;
                }
                case _restrictedto: {
                    break;
                }
                case _union: {
                    break;
                }
            }
            for (IFigure iFigure : this._listConnnections.getListConstraints()) {
                dim = this._vdt.getCanvas().getContents().getPreferredSize();
                this._vdt.getCanvas().getContents().add(iFigure);
                bounds = iFigure.getBounds();
                this._vdt.getCanvas().redraw(bounds.x, bounds.y, bounds.width, bounds.height, true);
                this._vdt.getCanvas().getContents().setPreferredSize(dim);
            }
        }
    }

    public boolean drawOneTickConstraints1(IFigure fig) {
        if (fig != null) {
            Description descr = fig instanceof Label ? this._vdt.getVcdFactory().getFigureForDescription(fig.getParent()) : this._vdt.getVcdFactory().getFigureForDescription(fig);
            if (descr == null) {
                return false;
            }
            String currentclock = descr.getName();
            if (fig instanceof PolylineConnection || fig instanceof Label) {
                for (IConstraintData cc : this._vdt.getVcdModel().getConstraintList()) {
                    if (cc instanceof ConstraintCommentCommand) {
                        this.drawOneTickConstraints2(fig, (ConstraintCommentCommand)cc, currentclock);
                        continue;
                    }
                    if (!cc.getConstraints().haveAllClockVisible() || !(fig instanceof Draw1)) continue;
                    cc.getConstraints().draw((Draw1)fig, currentclock);
                }
                if (!fig.getForegroundColor().equals((Object)this._mca.colorLightGreenFirable())) {
                    fig.setForegroundColor(this._mca.colorLightGreenFirable());
                }
            }
        }
        return true;
    }

    public boolean drawOneTickConstraints(int tickInstant, String clockName) {
        for (IConstraintData cc : this._vdt.getVcdModel().getConstraintList()) {
            if (cc instanceof ConstraintCommentCommand || !cc.getConstraints().haveAllClockVisible()) continue;
            cc.getConstraints().drawOneTick(tickInstant, clockName);
        }
        return true;
    }

    public void drawOneTickConstraints2Test(IFigure fig, ConstraintCommentCommand cc, String currentclock) {
        Rectangle bounds;
        Dimension dim;
        if (cc.getClock().equals(currentclock)) {
            switch (cc.getFunction()) {
                case _filteredby: 
                case _alternateswith: 
                case _synchronizeswith: 
                case _sampledon: 
                case _sustains: 
                case _precedes: 
                case _isperiodicon: {
                    if (cc.getConstraints() == null) break;
                    cc.getConstraints().haveAllClockVisible();
                    break;
                }
                case _restrictedto: {
                    break;
                }
                case _oneshoton: {
                    break;
                }
            }
            for (IFigure iFigure : this._listConnnections.getListConstraints()) {
                dim = this._vdt.getCanvas().getContents().getPreferredSize();
                this._vdt.getCanvas().getContents().add(iFigure);
                bounds = iFigure.getBounds();
                this._vdt.getCanvas().redraw(bounds.x, bounds.y, bounds.width, bounds.height, true);
                this._vdt.getCanvas().getContents().setPreferredSize(dim);
            }
        }
        if (cc.getReferenceClocks().contains(currentclock)) {
            switch (cc.getFunction()) {
                case _filteredby: 
                case _alternateswith: 
                case _synchronizeswith: 
                case _sampledon: 
                case _sustains: 
                case _precedes: 
                case _isperiodicon: {
                    if (cc.getConstraints() == null || !cc.getConstraints().haveAllClockVisible() || !(fig instanceof Draw1)) break;
                    cc.getConstraints().draw((Draw1)fig, currentclock);
                    break;
                }
                case _restrictedto: {
                    break;
                }
                case _union: {
                    break;
                }
            }
            for (IFigure iFigure : this._listConnnections.getListConstraints()) {
                dim = this._vdt.getCanvas().getContents().getPreferredSize();
                this._vdt.getCanvas().getContents().add(iFigure);
                bounds = iFigure.getBounds();
                this._vdt.getCanvas().redraw(bounds.x, bounds.y, bounds.width, bounds.height, true);
                this._vdt.getCanvas().getContents().setPreferredSize(dim);
            }
        }
    }

    @Override
    public void addAndRedraw(IFigure figure) {
        Dimension dim = this._vdt.getCanvas().getContents().getPreferredSize();
        this._vdt.getCanvas().getContents().add(figure);
        Rectangle bounds = figure.getBounds();
        this._vdt.getCanvas().redraw(bounds.x, bounds.y, bounds.width, bounds.height, true);
        this._vdt.getCanvas().getContents().setPreferredSize(dim);
    }

    @Override
    public void redraw(IFigure figure) {
        Dimension dim = this._vdt.getCanvas().getContents().getPreferredSize();
        Rectangle bounds = figure.getBounds();
        this._vdt.getCanvas().redraw(bounds.x, bounds.y, bounds.width, bounds.height, true);
        this._vdt.getCanvas().getContents().setPreferredSize(dim);
    }

    public void redrawSyncInterval(ConstraintCommentCommand cc, Color color) {
        if (cc == null) {
            return;
        }
        for (IFigure iFigure : this._listConnnections.getListInterval().get(cc)) {
            this._vdt.getCanvas().getContents().remove(iFigure);
        }
        this._listConnnections.getListInterval().get(cc).clear();
        Iterator<IFigure> iterator = this._listConnnections.lastClock1Get(cc).iterator();
        Iterator<IFigure> ot = this._listConnnections.lastClock2Get(cc).iterator();
        while (iterator.hasNext() && ot.hasNext()) {
            Point pt1 = ((PolylineConnection)iterator.next()).getPoints().getPoint(3);
            Point pt2 = ((PolylineConnection)ot.next()).getPoints().getPoint(3);
            ConstraintsConnection poly = null;
            if (pt1.x > pt2.x) {
                poly = pt1.y > pt2.y ? this.constructPolylineConnection(color, new Point(pt1.x + 5, pt1.y + 15), new Point(pt1.x + 5, pt2.y - 15)) : this.constructPolylineConnection(color, new Point(pt1.x + 5, pt1.y - 15), new Point(pt1.x + 5, pt2.y + 15));
                this._listConnnections.getListInterval().get(cc).add(poly);
                this._vdt.getCanvas().getContents().add((IFigure)poly);
                continue;
            }
            poly = pt2.y > pt1.y ? this.constructPolylineConnection(color, new Point(pt2.x + 5, pt2.y + 15), new Point(pt2.x + 5, pt1.y - 15)) : this.constructPolylineConnection(color, new Point(pt2.x + 5, pt2.y - 15), new Point(pt2.x + 5, pt1.y + 15));
            this._listConnnections.getListInterval().get(cc).add(poly);
            this._vdt.getCanvas().getContents().add((IFigure)poly);
        }
    }

    public void drawSyncInterval(ConstraintCommentCommand cc, Color color) {
        for (IFigure iFigure : this._listConnnections.getListInterval().get(cc)) {
            if (iFigure == null || this._vdt.getCanvas().getContents() != iFigure.getParent()) continue;
            this._vdt.getCanvas().getContents().remove(iFigure);
        }
        Dimension dimension = this._vdt.getCanvas().getContents().getPreferredSize();
        this._listConnnections.clearInterval(cc);
        String clock1 = null;
        String clock2 = null;
        clock1 = cc.getClock();
        clock2 = cc.getReferenceClocks().get(0);
        int occurencesclock1 = Integer.valueOf(cc.getReferenceClocks().get(1));
        int occurencesclock2 = Integer.valueOf(cc.getReferenceClocks().get(2));
        if (this._vdt.getVcdFactory().getNameforfigures().get(clock1) == null) {
            return;
        }
        if (this._vdt.getVcdFactory().getNameforfigures().get(clock2) == null) {
            return;
        }
        this._listConnnections.lastClock1Get(cc).clear();
        this._listConnnections.lastClock2Get(cc).clear();
        int i = 0;
        while (i < this._vdt.getVcdFactory().getNameforfigures().get(clock1).size()) {
            if ((i + 1) % occurencesclock1 == 0) {
                this._listConnnections.lastClock1Get(cc).add(this._vdt.getVcdFactory().getNameforfigures().get(clock1).get(i));
                this._listConnnections.firstClock1Get(cc).add(this._vdt.getVcdFactory().getNameforfigures().get(clock1).get(i - (occurencesclock1 - 1)));
            }
            ++i;
        }
        i = 0;
        while (i < this._vdt.getVcdFactory().getNameforfigures().get(clock2).size()) {
            if ((i + 1) % occurencesclock2 == 0) {
                this._listConnnections.lastClock2Get(cc).add(this._vdt.getVcdFactory().getNameforfigures().get(clock2).get(i));
                this._listConnnections.firstClock2Get(cc).add(this._vdt.getVcdFactory().getNameforfigures().get(clock2).get(i - (occurencesclock2 - 1)));
            }
            ++i;
        }
        Iterator<IFigure> it = this._listConnnections.lastClock1Get(cc).iterator();
        Iterator<IFigure> ot = this._listConnnections.lastClock2Get(cc).iterator();
        while (it.hasNext() && ot.hasNext()) {
            Point pt1 = ((PolylineConnection)it.next()).getPoints().getPoint(3);
            Point pt2 = ((PolylineConnection)ot.next()).getPoints().getPoint(3);
            ConstraintsConnection poly = null;
            poly = pt1.x > pt2.x ? (pt1.y > pt2.y ? this.constructPolylineConnection(color, new Point(pt1.x + 5, pt1.y + 15), new Point(pt1.x + 5, pt2.y - 15)) : this.constructPolylineConnection(color, new Point(pt1.x + 5, pt1.y - 15), new Point(pt1.x + 5, pt2.y + 15))) : (pt2.y > pt1.y ? this.constructPolylineConnection(color, new Point(pt2.x + 5, pt2.y + 15), new Point(pt2.x + 5, pt1.y - 15)) : this.constructPolylineConnection(color, new Point(pt2.x + 5, pt2.y - 15), new Point(pt2.x + 5, pt1.y + 15)));
            this._listConnnections.getListInterval().get(cc).add(poly);
            if (poly == null) continue;
            this._vdt.getCanvas().getContents().add((IFigure)poly);
        }
        this._vdt.getCanvas().getContents().setPreferredSize(dimension);
    }

    public IVcd getVdt() {
        return this._vdt;
    }

    public void hideCoincidence() {
        for (IFigure figs : this._listConnnections.getListCoincidence()) {
            figs.setForegroundColor(this._mca.colorLightGreenFirable());
        }
        this._listConnnections.getListCoincidence().clear();
    }

    public void hideConstraints() {
        if (this._vdt.getToolbar().getItems().length == 0) {
            return;
        }
        ToolItem[] toolItemArray = this._vdt.getToolbar().getItems();
        int n = toolItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            ToolItem item = toolItemArray[n2];
            item.setText("");
            ++n2;
        }
    }

    public void addhiddenGhost(RectangleFigure rect) {
        RectangleFigure temp = new RectangleFigure();
        PolylineConnection poly = new PolylineConnection();
        PointList pl = new PointList();
        poly.setPoints(pl);
        temp.setOpaque(false);
        temp.setFill(true);
        poly.setOpaque(false);
        poly.setFill(true);
        Rectangle bounds = rect.getBounds();
        temp.setForegroundColor(this._mca.colorBlack());
        temp.setBackgroundColor(this._mca.colorBlack());
        poly.setForegroundColor(this._mca.colorLightGreenFirable());
        poly.setBackgroundColor(this._mca.colorLightGreenFirable());
        temp.setBounds(bounds);
        pl.addPoint(new Point(bounds.x, bounds.y + bounds.height - 1));
        pl.addPoint(new Point(bounds.x + bounds.width, bounds.y + bounds.height - 1));
        poly.setPoints(pl);
        if (rect.getParent() != null) {
            rect.getParent().add((IFigure)temp);
            rect.getParent().add((IFigure)poly);
        }
        this._listConnnections.listGhostAdd((IFigure)temp);
        this._listConnnections.listGhostAdd((IFigure)poly);
    }

    public void hideGhost(int index) {
        try {
            IVar var = this._vdt.getTraceCollector().getSelectedClocks().get(index);
            var.getValueFactory().setGhostVisible(false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void hideAllGhost() {
        ArrayList<IVar> listVar = this._vdt.getTraceCollector().getAllnames();
        ArrayList<IVar> listVar2 = this._vdt.getTraceCollector().getSelectedClocks();
        for (IVar var : listVar) {
            if (var.getValueFactory() == null) continue;
            var.getValueFactory().setGhostVisible(false);
        }
        for (IVar var : listVar2) {
            if (var.getValueFactory() == null) continue;
            var.getValueFactory().setGhostVisible(false);
        }
    }

    public void showConstraint(IFigure fig) {
        if (fig != null && (fig instanceof PolylineConnection || fig instanceof Label)) {
            Description descr = null;
            if (fig instanceof PolylineConnection) {
                descr = this._vdt.getVcdFactory().getFigureForDescription(fig);
            }
            if (fig instanceof Label) {
                descr = this._vdt.getVcdFactory().getFigureForDescription(fig.getParent());
            }
            if (descr == null) {
                return;
            }
            String currentclock = descr.getName();
            int i = 0;
            for (ConstraintCommentCommand cc : this._vdt.getVcdModel().getConstraintCommentCommand()) {
                if (!cc.getClock().equals(currentclock) && !cc.getReferenceClocks().contains(currentclock)) continue;
                if (this._vdt.getToolbar() == null) {
                    return;
                }
                ToolItem[] toolItemArray = this._vdt.getToolbar().getItems();
                int n = toolItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ToolItem item = toolItemArray[n2];
                    if (item.getText().equals(cc.toString())) {
                        return;
                    }
                    ++n2;
                }
                String fonction = "";
                switch (cc.getFunction()) {
                    // Empty switch
                }
                fonction = cc.toString();
                if (i >= this._vdt.getToolbar().getItems().length) {
                    ToolItem toolItem = new ToolItem(this._vdt.getToolbar(), 8);
                }
                ToolItem item = this._vdt.getToolbar().getItems()[i];
                item.setText(fonction);
                ++i;
            }
        }
    }

    public void showGhost(int index) {
        try {
            IVar var = this._vdt.getTraceCollector().getSelectedClocks().get(index);
            var.getValueFactory().setGhostVisible(true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void showAllGhost() {
        ArrayList<IVar> listVar = this._vdt.getTraceCollector().getAllnames();
        ArrayList<IVar> listVar2 = this._vdt.getTraceCollector().getSelectedClocks();
        for (IVar var : listVar) {
            if (var.getValueFactory() == null) continue;
            var.getValueFactory().setGhostVisible(true);
        }
        for (IVar var : listVar2) {
            if (var.getValueFactory() == null) continue;
            var.getValueFactory().setGhostVisible(true);
        }
    }

    private Balise createBalise(int x, int y) {
        Balise rect = new Balise();
        rect.setOpaque(false);
        rect.setFill(true);
        rect.setForegroundColor(this._mca.colorBlack());
        rect.setBackgroundColor(this._mca.colorBlack());
        rect.setBounds(new Rectangle(x, y, 1, 1));
        return rect;
    }

    @Override
    public ArrayList<ConstraintsConnection> constructPacket(Color color, Draw1 f1, Draw1 f2) {
        ArrayList<ConstraintsConnection> res = new ArrayList<ConstraintsConnection>();
        Balise[] tab = new Balise[4];
        tab[0] = this.createBalise(f1.getBounds().getTopLeft().x - 2, f1.getBounds().getTopLeft().y - 4);
        tab[0].setAnchor(f1);
        tab[0].setLinkTo(Balise.Linkto.tl);
        tab[1] = this.createBalise(f2.getBounds().getTopRight().x + 2, f2.getBounds().getTopRight().y - 4);
        tab[1].setAnchor(f2);
        tab[1].setLinkTo(Balise.Linkto.tr);
        tab[2] = this.createBalise(f2.getBounds().getBottomRight().x + 2, f2.getBounds().getBottomRight().y + 5);
        tab[2].setAnchor(f2);
        tab[2].setLinkTo(Balise.Linkto.br);
        tab[3] = this.createBalise(f1.getBounds().getBottomLeft().x - 2, f1.getBounds().getBottomLeft().y + 5);
        tab[3].setAnchor(f1);
        tab[3].setLinkTo(Balise.Linkto.bl);
        int i = 0;
        while (i < 4) {
            for (Object obj : f1.getParent().getChildren()) {
                if (!(obj instanceof Balise)) continue;
                Balise rect = (Balise)((Object)obj);
                if (!tab[i].getBounds().equals((Object)rect.getBounds())) continue;
                tab[i] = rect;
            }
            ++i;
        }
        f1.getParent().add((IFigure)tab[0]);
        f1.getParent().add((IFigure)tab[1]);
        f1.getParent().add((IFigure)tab[2]);
        f1.getParent().add((IFigure)tab[3]);
        int j = 0;
        while (j < 4) {
            ConstraintsConnection poly = new ConstraintsConnection();
            poly.setOpaque(false);
            poly.setLineWidth(2);
            poly.setForegroundColor(color);
            ChopboxAnchor sourceAnchor = new ChopboxAnchor((IFigure)tab[j]);
            ChopboxAnchor targetAnchor = j == 3 ? new ChopboxAnchor((IFigure)tab[0]) : new ChopboxAnchor((IFigure)tab[j + 1]);
            poly.setSourceAnchor((ConnectionAnchor)sourceAnchor);
            poly.setTargetAnchor((ConnectionAnchor)targetAnchor);
            poly.getInstants().add(f1.getInstant());
            poly.getInstants().add(f2.getInstant());
            res.add(poly);
            ++j;
        }
        return res;
    }

    public int getDateOf(String name, int n) {
        return 0;
    }
}

