/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core.search;

import org.aspectj.org.eclipse.jdt.core.search.IJavaSearchScope;
import org.aspectj.org.eclipse.jdt.core.search.SearchDocument;
import org.aspectj.org.eclipse.jdt.core.search.SearchParticipant;
import org.aspectj.org.eclipse.jdt.core.search.SearchPattern;
import org.aspectj.org.eclipse.jdt.core.search.SearchRequestor;
import org.aspectj.org.eclipse.jdt.internal.compiler.util.Util;
import org.aspectj.org.eclipse.jdt.internal.core.index.IndexLocation;
import org.aspectj.org.eclipse.jdt.internal.core.search.IndexSelector;
import org.aspectj.org.eclipse.jdt.internal.core.search.JavaSearchDocument;
import org.aspectj.org.eclipse.jdt.internal.core.search.indexing.BinaryIndexer;
import org.aspectj.org.eclipse.jdt.internal.core.search.indexing.ManifestIndexer;
import org.aspectj.org.eclipse.jdt.internal.core.search.indexing.SourceIndexer;
import org.aspectj.org.eclipse.jdt.internal.core.search.matching.MatchLocator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;

public class JavaSearchParticipant
extends SearchParticipant {
    private ThreadLocal indexSelector = new ThreadLocal();
    private SourceIndexer sourceIndexer;

    @Override
    public void beginSearching() {
        super.beginSearching();
        this.indexSelector.set(null);
    }

    @Override
    public void doneSearching() {
        this.indexSelector.set(null);
        super.doneSearching();
    }

    @Override
    public String getDescription() {
        return "Java";
    }

    @Override
    public SearchDocument getDocument(String documentPath) {
        return new JavaSearchDocument(documentPath, this);
    }

    @Override
    public void indexDocument(SearchDocument document, IPath indexPath) {
        document.removeAllIndexEntries();
        String documentPath = document.getPath();
        if (org.aspectj.org.eclipse.jdt.internal.core.util.Util.isJavaLikeFileName(documentPath)) {
            this.sourceIndexer = new SourceIndexer(document);
            this.sourceIndexer.indexDocument();
        } else if (Util.isClassFileName(documentPath)) {
            new BinaryIndexer(document).indexDocument();
        } else if (documentPath.endsWith("Automatic-Module-Name")) {
            new ManifestIndexer(document).indexDocument();
        }
    }

    @Override
    public void indexResolvedDocument(SearchDocument document, IPath indexPath) {
        String documentPath = document.getPath();
        if (org.aspectj.org.eclipse.jdt.internal.core.util.Util.isJavaLikeFileName(documentPath)) {
            if (this.sourceIndexer != null) {
                this.sourceIndexer.indexResolvedDocument();
            }
            this.sourceIndexer = null;
        }
    }

    @Override
    public void resolveDocument(SearchDocument document) {
        String documentPath = document.getPath();
        if (org.aspectj.org.eclipse.jdt.internal.core.util.Util.isJavaLikeFileName(documentPath) && this.sourceIndexer != null) {
            this.sourceIndexer.resolveDocument();
        }
    }

    @Override
    public void locateMatches(SearchDocument[] indexMatches, SearchPattern pattern, IJavaSearchScope scope, SearchRequestor requestor, IProgressMonitor monitor) throws CoreException {
        MatchLocator matchLocator = new MatchLocator(pattern, requestor, scope, monitor);
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        matchLocator.locateMatches(indexMatches);
    }

    @Override
    public IPath[] selectIndexes(SearchPattern pattern, IJavaSearchScope scope) {
        IndexSelector selector = (IndexSelector)this.indexSelector.get();
        if (selector == null) {
            selector = new IndexSelector(scope, pattern);
            this.indexSelector.set(selector);
        }
        IndexLocation[] urls = selector.getIndexLocations();
        IPath[] paths = new IPath[urls.length];
        int i = 0;
        while (i < urls.length) {
            paths[i] = new Path(urls[i].getIndexFile().getPath());
            ++i;
        }
        return paths;
    }

    public IndexLocation[] selectIndexURLs(SearchPattern pattern, IJavaSearchScope scope) {
        IndexSelector selector = (IndexSelector)this.indexSelector.get();
        if (selector == null) {
            selector = new IndexSelector(scope, pattern);
            this.indexSelector.set(selector);
        }
        return selector.getIndexLocations();
    }
}

