/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.trace.gemoc.generator.util;

import com.google.common.base.Objects;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.xtext.xbase.lib.Exceptions;

public class PluginProjectHelper {
    public static final String ISO_8859_1 = "iso-8859-1";

    public static IProject createPluginProject(String projectName, List<String> srcFolders, List<IProject> referencedProjects, Set<String> requiredBundles, List<String> exportedPackages, IProgressMonitor progressMonitor) {
        try {
            boolean _notEquals;
            boolean _not;
            IProject project = null;
            progressMonitor.beginTask("", 10);
            progressMonitor.subTask("Creating project " + projectName);
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            project = workspace.getRoot().getProject(projectName);
            IJavaProject javaProject = JavaCore.create((IProject)project);
            IProjectDescription projectDescription = ResourcesPlugin.getWorkspace().newProjectDescription(projectName);
            projectDescription.setLocation(null);
            boolean _exists = project.exists();
            boolean bl = _not = !_exists;
            if (_not) {
                SubProgressMonitor _subProgressMonitor = new SubProgressMonitor(progressMonitor, 1);
                project.create(projectDescription, (IProgressMonitor)_subProgressMonitor);
            }
            ArrayList<IClasspathEntry> classpathEntries = new ArrayList<IClasspathEntry>();
            int _size = referencedProjects.size();
            boolean bl2 = _notEquals = _size != 0;
            if (_notEquals) {
                IProject[] referencedProjectsArray = new IProject[referencedProjects.size()];
                projectDescription.setReferencedProjects(referencedProjects.toArray(referencedProjectsArray));
                for (IProject referencedProject : referencedProjects) {
                    IClasspathEntry referencedProjectClasspathEntry = JavaCore.newProjectEntry((IPath)referencedProject.getFullPath());
                    classpathEntries.add(referencedProjectClasspathEntry);
                }
            }
            String[] natureIdsArray = new String[]{"org.eclipse.jdt.core.javanature", "org.eclipse.pde.PluginNature"};
            projectDescription.setNatureIds(natureIdsArray);
            ICommand java = projectDescription.newCommand();
            java.setBuilderName("org.eclipse.jdt.core.javabuilder");
            ICommand manifest = projectDescription.newCommand();
            manifest.setBuilderName("org.eclipse.pde.ManifestBuilder");
            ICommand schema = projectDescription.newCommand();
            schema.setBuilderName("org.eclipse.pde.SchemaBuilder");
            ICommand[] commandArray = new ICommand[]{java, manifest, schema};
            projectDescription.setBuildSpec(commandArray);
            SubProgressMonitor _subProgressMonitor_1 = new SubProgressMonitor(progressMonitor, 1);
            project.open((IProgressMonitor)_subProgressMonitor_1);
            SubProgressMonitor _subProgressMonitor_2 = new SubProgressMonitor(progressMonitor, 1);
            project.setDescription(projectDescription, (IProgressMonitor)_subProgressMonitor_2);
            Collections.reverse(srcFolders);
            for (String src : srcFolders) {
                boolean _not_1;
                IFolder srcContainer = project.getFolder(src);
                boolean _exists_1 = srcContainer.exists();
                boolean bl3 = _not_1 = !_exists_1;
                if (_not_1) {
                    SubProgressMonitor _subProgressMonitor_3 = new SubProgressMonitor(progressMonitor, 1);
                    srcContainer.create(false, true, (IProgressMonitor)_subProgressMonitor_3);
                }
                IClasspathEntry srcClasspathEntry = JavaCore.newSourceEntry((IPath)srcContainer.getFullPath());
                classpathEntries.add(0, srcClasspathEntry);
            }
            Path _path = new Path("org.eclipse.jdt.launching.JRE_CONTAINER");
            classpathEntries.add(JavaCore.newContainerEntry((IPath)_path));
            Path _path_1 = new Path("org.eclipse.pde.core.requiredPlugins");
            classpathEntries.add(JavaCore.newContainerEntry((IPath)_path_1));
            IClasspathEntry[] classPathEntriesArray = new IClasspathEntry[classpathEntries.size()];
            IClasspathEntry[] _array = classpathEntries.toArray(classPathEntriesArray);
            SubProgressMonitor _subProgressMonitor_3 = new SubProgressMonitor(progressMonitor, 1);
            javaProject.setRawClasspath(_array, (IProgressMonitor)_subProgressMonitor_3);
            Path _path_2 = new Path("/" + projectName + "/bin");
            SubProgressMonitor _subProgressMonitor_4 = new SubProgressMonitor(progressMonitor, 1);
            javaProject.setOutputLocation((IPath)_path_2, (IProgressMonitor)_subProgressMonitor_4);
            PluginProjectHelper.createManifest(projectName, requiredBundles, exportedPackages, progressMonitor, project);
            PluginProjectHelper.createBuildProps(progressMonitor, project, srcFolders);
            return project;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static IFile createFile(String name, IContainer container, String content, IProgressMonitor progressMonitor) {
        IFile iFile;
        Path _path = new Path(name);
        IFile file = container.getFile((IPath)_path);
        PluginProjectHelper.assertExist(file.getParent());
        byte[] _bytes = content.getBytes(file.getCharset());
        ByteArrayInputStream stream = new ByteArrayInputStream(_bytes);
        try {
            boolean _exists = file.exists();
            if (_exists) {
                file.setContents((InputStream)stream, true, true, progressMonitor);
            } else {
                file.create((InputStream)stream, true, progressMonitor);
            }
            progressMonitor.worked(1);
            iFile = file;
        }
        catch (Throwable throwable) {
            try {
                ((InputStream)stream).close();
                throw throwable;
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        }
        ((InputStream)stream).close();
        return iFile;
    }

    private static void createBuildProps(IProgressMonitor progressMonitor, IProject project, List<String> srcFolders) {
        StringBuilder bpContent = new StringBuilder("source.. = ");
        Iterator<String> iterator = srcFolders.iterator();
        while (iterator.hasNext()) {
            bpContent.append(iterator.next()).append("/");
            boolean _hasNext = iterator.hasNext();
            if (!_hasNext) continue;
            bpContent.append(",");
        }
        bpContent.append("\n");
        bpContent.append("bin.includes = META-INF/,.\n");
        PluginProjectHelper.createFile("build.properties", (IContainer)project, bpContent.toString(), progressMonitor);
    }

    private static void createManifest(String projectName, Set<String> requiredBundles, List<String> exportedPackages, IProgressMonitor progressMonitor, IProject project) throws CoreException {
        boolean _not;
        StringBuilder maniContent = new StringBuilder("Manifest-Version: 1.0\n");
        maniContent.append("Bundle-ManifestVersion: 2\n");
        maniContent.append("Bundle-Name: " + projectName + "\n");
        maniContent.append("Bundle-SymbolicName: " + projectName + "; singleton:=true\n");
        maniContent.append("Bundle-Version: 1.0.0\n");
        boolean _isEmpty = requiredBundles.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            maniContent.append("Require-Bundle: ");
        }
        for (String entry : requiredBundles) {
            maniContent.append(" " + entry + ",\n");
        }
        if (!Objects.equal(exportedPackages, null) && !exportedPackages.isEmpty()) {
            String _get = exportedPackages.get(0);
            String _plus = "Require-Bundle: " + _get;
            maniContent.append(_plus);
            int x = exportedPackages.size();
            int i = 1;
            while (i < x) {
                String _get_1 = exportedPackages.get(i);
                String _plus_1 = ",\n " + _get_1;
                maniContent.append(_plus_1);
                ++i;
            }
            maniContent.append("\n");
        }
        maniContent.append("Bundle-RequiredExecutionEnvironment: J2SE-1.5\r\n");
        IFolder metaInf = project.getFolder("META-INF");
        SubProgressMonitor _subProgressMonitor = new SubProgressMonitor(progressMonitor, 1);
        metaInf.create(false, true, (IProgressMonitor)_subProgressMonitor);
        PluginProjectHelper.createFile("MANIFEST.MF", (IContainer)metaInf, maniContent.toString(), progressMonitor);
    }

    private static void assertExist(IContainer c) {
        try {
            boolean _not;
            boolean _exists = c.exists();
            boolean bl = _not = !_exists;
            if (_not) {
                boolean _not_1;
                boolean _exists_1 = c.getParent().exists();
                boolean bl2 = _not_1 = !_exists_1;
                if (_not_1) {
                    PluginProjectHelper.assertExist(c.getParent());
                }
                if (c instanceof IFolder) {
                    NullProgressMonitor _nullProgressMonitor = new NullProgressMonitor();
                    ((IFolder)c).create(false, true, (IProgressMonitor)_nullProgressMonitor);
                }
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }
}

