/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.ccslkernel.runtime.expressions;

import fr.inria.aoste.timesquare.ccslkernel.runtime.ICCSLConstraint;
import fr.inria.aoste.timesquare.ccslkernel.runtime.SerializedConstraintState;
import fr.inria.aoste.timesquare.ccslkernel.runtime.elements.RuntimeClock;
import fr.inria.aoste.timesquare.ccslkernel.runtime.exceptions.SimulationException;
import fr.inria.aoste.timesquare.ccslkernel.runtime.expressions.AbstractRuntimeExpression;
import fr.inria.aoste.timesquare.ccslkernel.runtime.helpers.AbstractSemanticHelper;
import fr.inria.aoste.timesquare.ccslkernel.runtime.helpers.AbstractUpdateHelper;

public class RuntimeInf
extends AbstractRuntimeExpression {
    private RuntimeClock clock1;
    private RuntimeClock clock2;
    private int _deltaWithC1;
    private int _deltaWithC2;

    public RuntimeInf(RuntimeClock iClock, RuntimeClock clock1, RuntimeClock clock2) {
        super(iClock);
        this.clock1 = clock1;
        this.clock2 = clock2;
        this._deltaWithC1 = 0;
        this._deltaWithC2 = 0;
    }

    @Override
    public void start(AbstractSemanticHelper helper) throws SimulationException {
        if (!this.canCallStart()) {
            return;
        }
        super.start(helper);
        this._deltaWithC1 = 0;
        this._deltaWithC2 = 0;
    }

    @Override
    public void semantic(AbstractSemanticHelper helper) throws SimulationException {
        if (!this.canCallSemantic()) {
            return;
        }
        super.semantic(helper);
        if (this.clock1 instanceof ICCSLConstraint) {
            ((ICCSLConstraint)((Object)this.clock1)).semantic(helper);
        }
        if (this.clock2 instanceof ICCSLConstraint) {
            ((ICCSLConstraint)((Object)this.clock2)).semantic(helper);
        }
        if (this.isDead()) {
            helper.inhibitClock(this.getExpressionClock());
            return;
        }
        RuntimeClock eClock = this.getExpressionClock();
        if (this._deltaWithC1 == 0) {
            if (this._deltaWithC2 == 0) {
                helper.semanticBDDAnd(helper.createEqual(eClock, helper.createUnion(this.getClock1(), this.getClock2())));
            } else {
                helper.semanticBDDAnd(helper.createEqual(eClock, this.getClock1()));
            }
        } else if (this._deltaWithC2 == 0) {
            helper.semanticBDDAnd(helper.createEqual(eClock, this.getClock2()));
        } else {
            helper.semanticBDDAnd(helper.createNot(eClock));
        }
        helper.registerClockUse(new RuntimeClock[]{eClock, this.clock1, this.clock2});
    }

    @Override
    public void update(AbstractUpdateHelper helper) throws SimulationException {
        RuntimeClock eClock;
        if (!this.canCallUpdate()) {
            return;
        }
        super.update(helper);
        if (this.clock1 instanceof ICCSLConstraint) {
            ((ICCSLConstraint)((Object)this.clock1)).update(helper);
        }
        if (this.clock2 instanceof ICCSLConstraint) {
            ((ICCSLConstraint)((Object)this.clock2)).update(helper);
        }
        if (helper.clockHasFired(eClock = this.getExpressionClock())) {
            ++this._deltaWithC1;
            ++this._deltaWithC2;
        }
        if (helper.clockHasFired(this.clock1)) {
            --this._deltaWithC1;
        }
        if (helper.clockHasFired(this.clock2)) {
            --this._deltaWithC2;
        }
    }

    @Override
    public void deathSemantic(AbstractSemanticHelper helper) throws SimulationException {
        super.deathSemantic(helper);
        if (this.clock1 instanceof ICCSLConstraint) {
            ((ICCSLConstraint)((Object)this.clock1)).deathSemantic(helper);
        }
        if (this.clock2 instanceof ICCSLConstraint) {
            ((ICCSLConstraint)((Object)this.clock2)).deathSemantic(helper);
        }
        helper.registerDeathConjunctionImplies(this.clock1, this.clock2, this.getExpressionClock());
    }

    public RuntimeClock getClock1() {
        return this.clock1;
    }

    public RuntimeClock getClock2() {
        return this.clock2;
    }

    @Override
    public SerializedConstraintState dumpState() {
        SerializedConstraintState currentState = super.dumpState();
        currentState.dump(new Integer(this._deltaWithC1));
        currentState.dump(new Integer(this._deltaWithC2));
        return currentState;
    }

    @Override
    public void restoreState(SerializedConstraintState newState) {
        super.restoreState(newState);
        this._deltaWithC1 = (Integer)newState.restore(2);
        this._deltaWithC2 = (Integer)newState.restore(3);
    }
}

