/**
 * Copyright (c) 2016, 2017 Inria and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Inria - initial API and implementation
 */
package org.eclipse.gemoc.xdsmlframework.commons;

import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@SuppressWarnings("all")
public class DynamicAnnotationHelper {
  public static final String DYNAMIC_ANNOTATION_URI = "aspect";

  private static boolean isDynamic(final EModelElement o) {
    final Function1<EAnnotation, Boolean> _function = (EAnnotation a) -> {
      return Boolean.valueOf(a.getSource().equals(DynamicAnnotationHelper.DYNAMIC_ANNOTATION_URI));
    };
    return IterableExtensions.<EAnnotation>exists(o.getEAnnotations(), _function);
  }

  public static boolean isDynamic(final EClass c) {
    return DynamicAnnotationHelper.isDynamic(((EModelElement) c));
  }

  public static boolean isDynamic(final EStructuralFeature p) {
    return (DynamicAnnotationHelper.isDynamic(((EModelElement) p)) || DynamicAnnotationHelper.isDynamic(p.getEContainingClass()));
  }

  public static EAnnotation createDynamicAnnotation() {
    final EAnnotation dynamicAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
    dynamicAnnotation.setSource(DynamicAnnotationHelper.DYNAMIC_ANNOTATION_URI);
    return dynamicAnnotation;
  }
}
