/**
 * ---------------------------------------------------------------------------------------------
 * Copyright (c) 2020 Inria and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * --------------------------------------------------------------------------------------------
 */
package org.eclipse.gemoc.protocols.eaop.api.data;

import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

/**
 * Information about a MSEOccurence.
 */
@SuppressWarnings("all")
public class MSEOccurenceDto {
  private MSEDto mse;

  /**
   * TODO !
   */
  private String parameters;

  /**
   * TODO !
   */
  private String result;

  @Pure
  public MSEDto getMse() {
    return this.mse;
  }

  public void setMse(final MSEDto mse) {
    this.mse = mse;
  }

  /**
   * TODO !
   */
  @Pure
  public String getParameters() {
    return this.parameters;
  }

  /**
   * TODO !
   */
  public void setParameters(final String parameters) {
    this.parameters = parameters;
  }

  /**
   * TODO !
   */
  @Pure
  public String getResult() {
    return this.result;
  }

  /**
   * TODO !
   */
  public void setResult(final String result) {
    this.result = result;
  }

  @Override
  @Pure
  public String toString() {
    ToStringBuilder b = new ToStringBuilder(this);
    b.add("mse", this.mse);
    b.add("parameters", this.parameters);
    b.add("result", this.result);
    return b.toString();
  }

  @Override
  @Pure
  public boolean equals(final Object obj) {
    if (this == obj)
      return true;
    if (obj == null)
      return false;
    if (getClass() != obj.getClass())
      return false;
    MSEOccurenceDto other = (MSEOccurenceDto) obj;
    if (this.mse == null) {
      if (other.mse != null)
        return false;
    } else if (!this.mse.equals(other.mse))
      return false;
    if (this.parameters == null) {
      if (other.parameters != null)
        return false;
    } else if (!this.parameters.equals(other.parameters))
      return false;
    if (this.result == null) {
      if (other.result != null)
        return false;
    } else if (!this.result.equals(other.result))
      return false;
    return true;
  }

  @Override
  @Pure
  public int hashCode() {
    final int prime = 31;
    int result = 1;
    result = prime * result + ((this.mse== null) ? 0 : this.mse.hashCode());
    result = prime * result + ((this.parameters== null) ? 0 : this.parameters.hashCode());
    return prime * result + ((this.result== null) ? 0 : this.result.hashCode());
  }
}
