/**
 * Copyright (c) 2017 Inria and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Inria - initial API and implementation
 */
package fr.inria.diverse.k3.al.annotationprocessor.stepmanager;

@SuppressWarnings("all")
public interface IStepManager {
  void executeStep(final Object caller, final StepCommand command, final String className, final String methodName);

  default void executeStep(final Object caller, final Object[] parameters, final StepCommand command, final String className, final String methodName) {
    this.executeStep(caller, command, className, methodName);
  }

  boolean canHandle(final Object caller);
}
