/**
 * Copyright (c) 2017 Inria and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Inria - initial API and implementation
 */
package fr.inria.diverse.k3.al.annotationprocessor.stepmanager;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@SuppressWarnings("all")
public class StepManagerRegistry {
  private static StepManagerRegistry instance;

  private Set<IStepManager> registeredManagers;

  private StepManagerRegistry() {
    HashSet<IStepManager> _hashSet = new HashSet<IStepManager>();
    this.registeredManagers = Collections.<IStepManager>synchronizedSet(_hashSet);
  }

  public static StepManagerRegistry getInstance() {
    if ((StepManagerRegistry.instance == null)) {
      StepManagerRegistry _stepManagerRegistry = new StepManagerRegistry();
      StepManagerRegistry.instance = _stepManagerRegistry;
    }
    return StepManagerRegistry.instance;
  }

  public void registerManager(final IStepManager manager) {
    if ((manager != null)) {
      this.registeredManagers.add(manager);
    }
  }

  public void unregisterManager(final IStepManager manager) {
    if ((manager != null)) {
      this.registeredManagers.remove(manager);
    }
  }

  public IStepManager findStepManager(final Object caller) {
    synchronized (this.registeredManagers) {
      final Function1<IStepManager, Boolean> _function = (IStepManager m) -> {
        return Boolean.valueOf(m.canHandle(caller));
      };
      return IterableExtensions.<IStepManager>findFirst(this.registeredManagers, _function);
    }
  }
}
